/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.BlockTags;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.items.ItemTags;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidTeleporter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RaidUtils {
    private static final Set<String> POKEMON_BLACKLIST = new HashSet<String>();
    private static final Set<String> ABILITY_BLACKLIST = new HashSet<String>();
    private static final Set<String> MOVE_BLACKLIST = new HashSet<String>();
    private static final Set<String> COMMAND_BLACKLIST = new HashSet<String>();
    private static int MAX_COMMAND_SPLIT;

    public static boolean isPokemonBlacklisted(Pokemon pokemon) {
        return POKEMON_BLACKLIST.contains(pokemon.getSpecies().getName().toLowerCase());
    }

    public static boolean isAbilityBlacklisted(Ability ability) {
        return ABILITY_BLACKLIST.contains(ability.getName());
    }

    public static boolean isMoveBlacklisted(String move) {
        return MOVE_BLACKLIST.contains(move);
    }

    public static boolean isCommandBlacklisted(String command) {
        return COMMAND_BLACKLIST.contains(command);
    }

    public static int getMaxCommandSplit() {
        return MAX_COMMAND_SPLIT;
    }

    public static boolean hasSkyAccess(LevelReader level, BlockPos blockPos) {
        int topY = level.getChunk(blockPos).getHeight(Heightmap.Types.MOTION_BLOCKING, blockPos.getX() & 0xF, blockPos.getZ() & 0xF);
        return blockPos.getY() >= topY;
    }

    public static void teleportPlayerToRaid(ServerPlayer player, MinecraftServer server, RaidRegion region) {
        ServerLevel level = ModDimensions.getRaidDimension(server);
        if (level == null) {
            return;
        }
        ((IRaidTeleporter)player).crd_setHomePos(player.position());
        ((IRaidTeleporter)player).crd_setHomeLevel(player.level().dimension().location());
        Vec3 playerPos = region.getPlayerPos();
        player.teleportTo(level, playerPos.x, playerPos.y, playerPos.z, new HashSet(), 180.0f, 0.0f);
    }

    public static void teleportPlayerSafe(ServerPlayer player, ServerLevel level, Vec3 targetPos, float yaw, float pitch) {
        PlayerExtensionsKt.party((ServerPlayer)player).forEach(pokemon -> {
            if (pokemon.getState() instanceof ActivePokemonState) {
                pokemon.recall();
            }
        });
        int groundY = level.getChunk(BlockPos.containing((Position)targetPos)).getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)targetPos.x(), (int)targetPos.z()) + 1;
        player.teleportTo(level, targetPos.x(), (double)groundY, targetPos.z(), new HashSet(), yaw, pitch);
    }

    public static void leaveRaid(Player player) {
        RaidDenNetworkMessages.JOIN_RAID.accept((ServerPlayer)player, false);
        RaidJoinHelper.Participant participant = RaidJoinHelper.getParticipant(player);
        if (participant == null) {
            return;
        }
        UUID raid = participant.raid();
        RaidRegion region = RaidRegionHelper.getRegion(raid);
        if (region == null) {
            RaidUtils.leaveRaidFallback(player);
            return;
        }
        ServerLevel level = ModDimensions.getRaidDimension(player.getServer());
        if (level == null) {
            return;
        }
        RaidInstance instance = RaidHelper.ACTIVE_RAIDS.get(raid);
        if (instance == null) {
            RaidUtils.leaveRaidFallback(player);
            return;
        }
        if (instance.getRaidState() != RaidState.NOT_STARTED) {
            return;
        }
        int players = level.getEntitiesOfClass(Player.class, region.bound(), p -> RaidJoinHelper.isParticipating(p, false)).size();
        if (players > (RaidUtils.isRaidDimension(player.level()) ? 1 : 0)) {
            return;
        }
        int items = level.getEntitiesOfClass(ItemEntity.class, region.bound()).size();
        if (items > 0 && RaidUtils.isRaidDimension(player.level())) {
            return;
        }
        instance.removePlayer((ServerPlayer)player);
        instance.closeRaid(player.getServer());
        PokemonEntity entity = instance.getBossEntity();
        if (!entity.isRemoved()) {
            ((IRaidAccessor)entity).crd_flagForRemoval();
        }
    }

    private static void leaveRaidFallback(Player player) {
        RaidHelper.removeRequests(player.getUUID());
        RaidJoinHelper.removeParticipant(player);
    }

    public static boolean isRaidDenKey(ItemStack itemStack) {
        return itemStack.is(ItemTags.RAID_DEN_KEY) || (Boolean)itemStack.getOrDefault((DataComponentType)ModComponents.RAID_DEN_KEY.value(), (Object)false) != false;
    }

    public static boolean isRaidDimension(Level level) {
        return level.dimensionTypeRegistration().is(ModDimensions.RAID_DIM_TYPE);
    }

    public static boolean cannotBreak(Player player, Level level) {
        return RaidUtils.isRaidDimension(level) && !player.isCreative();
    }

    public static boolean cannotPlace(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        return RaidUtils.isRaidDimension(level) && !player.isCreative() && !level.getBlockState(hitResult.getBlockPos()).is(BlockTags.CAN_INTERACT);
    }

    public static boolean canBreak(Level level, Player player, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        RaidCrystalBlockEntity raidCrystal;
        if (RaidUtils.cannotBreak(player, level)) {
            return false;
        }
        return !(blockEntity instanceof RaidCrystalBlockEntity) || (raidCrystal = (RaidCrystalBlockEntity)blockEntity).getPlayerCount() == 0;
    }

    public static InteractionResult canPlace(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        return RaidUtils.cannotPlace(player, level, hand, hitResult) ? InteractionResult.FAIL : InteractionResult.PASS;
    }

    public static void init() {
        POKEMON_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.pokemon));
        ABILITY_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.abilities));
        MOVE_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.moves));
        COMMAND_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.commands));
        int maxSplit = 1;
        for (String command : COMMAND_BLACKLIST) {
            maxSplit = Math.max(maxSplit, command.split(" ").length);
        }
        MAX_COMMAND_SPLIT = Math.min(maxSplit, 4);
    }
}

