/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.showdown.loader;

import com.necro.raid.dens.common.CobblemonRaidDens;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public abstract class ShowdownLoader {
    protected abstract boolean isMegaShowdownLoaded();

    public void load() {
        if (this.isMegaShowdownLoaded()) {
            return;
        }
        CobblemonRaidDens.LOGGER.info("Initiating showdown files");
        Path showdown_sim = Path.of("./showdown/sim", new String[0]);
        Path showdown_data = Path.of("./showdown/data", new String[0]);
        Path showdown = Path.of("./showdown", new String[0]);
        Path showdown_mod_data = Path.of("./showdown/data/mods/cobblemon", new String[0]);
        try {
            Files.createDirectories(showdown_sim, new FileAttribute[0]);
            Files.createDirectories(showdown_data, new FileAttribute[0]);
            this.yoink("/assets/cobblemonraiddens/showdown/conditions.js", showdown_data.resolve("conditions.js"));
            this.yoink("/assets/cobblemonraiddens/showdown/index.js", showdown.resolve("index.js"));
            if (!Files.exists(showdown_mod_data.resolve("conditions.js"), new LinkOption[0])) {
                this.yoink("/assets/cobblemonraiddens/showdown/mods/conditions.js", showdown_mod_data.resolve("conditions.js"));
            }
        }
        catch (IOException e) {
            CobblemonRaidDens.LOGGER.error("Failed to load showdown files: {}", (Object)e.getMessage());
        }
    }

    private void yoink(String resourcePath, Path targetPath) throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                return;
            }
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

