/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.showdown.instructions;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectContext;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectTimeline;
import com.cobblemon.mod.common.api.moves.animations.ActionEffects;
import com.cobblemon.mod.common.api.moves.animations.UsersProvider;
import com.cobblemon.mod.common.battles.dispatch.ActionEffectInstruction;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Unit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class ShieldAddInstruction
implements ActionEffectInstruction {
    private final BattleMessage message;
    private CompletableFuture<?> future;
    private Set<String> holds;
    private final BattlePokemon pokemon;

    public ShieldAddInstruction(PokemonBattle battle, BattleMessage message) {
        this.message = message;
        this.future = CompletableFuture.completedFuture(Unit.INSTANCE);
        this.holds = new HashSet<String>();
        this.pokemon = this.message.battlePokemon(0, battle);
    }

    @NotNull
    public CompletableFuture<?> getFuture() {
        return this.future;
    }

    public void setFuture(@NotNull CompletableFuture<?> future) {
        this.future = future;
    }

    @NotNull
    public Set<String> getHolds() {
        return this.holds;
    }

    public void setHolds(@NotNull Set<String> set) {
        this.holds = set;
    }

    @NotNull
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"shield_add");
    }

    public void preActionEffect(@NotNull PokemonBattle battle) {
    }

    public void runActionEffect(@NotNull PokemonBattle battle, @NotNull MoLangRuntime runtime) {
        if (this.pokemon == null) {
            return;
        }
        battle.dispatch(() -> {
            ActionEffectTimeline actionEffect = ActionEffects.INSTANCE.getEffectWithBattleContext(MiscUtilsKt.cobblemonResource((String)"protect"), this.pokemon);
            if (actionEffect == null) {
                actionEffect = (ActionEffectTimeline)ActionEffects.INSTANCE.getActionEffects().get(MiscUtilsKt.cobblemonResource((String)"generic_move"));
            }
            ArrayList<PokemonBattle> providers = new ArrayList<PokemonBattle>(List.of(battle));
            providers.add((PokemonBattle)new UsersProvider(new Entity[]{this.pokemon.getEffectedPokemon().getEntity()}));
            ActionEffectContext context = new ActionEffectContext(actionEffect, new HashSet(), providers, runtime, false, false, new ArrayList(), ((ServerPlayer)battle.getPlayers().getFirst()).level());
            this.setFuture(actionEffect.run(context));
            this.setHolds(context.getHolds());
            this.future.thenAccept(v -> this.holds.clear());
            return DispatchResultKt.getGO();
        });
    }

    public void postActionEffect(@NotNull PokemonBattle battle) {
        if (this.pokemon == null || this.pokemon.getEntity() == null) {
            return;
        }
        battle.dispatch(() -> {
            battle.getMinorBattleActions().put(this.pokemon.getUuid(), this.message);
            return new UntilDispatch(() -> !this.holds.contains("effects"));
        });
    }
}

