/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.reloaders;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.mixins.tags.TagEntryMixin;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.reloaders.AbstractReloadImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import org.jetbrains.annotations.NotNull;

public class RaidTagReloadImpl
extends AbstractReloadImpl {
    private final Map<ResourceLocation, TagFile> files = new HashMap<ResourceLocation, TagFile>();

    public RaidTagReloadImpl() {
        super("tags/raid/boss", AbstractReloadImpl.DataType.JSON);
    }

    @Override
    public void load(@NotNull ResourceManager manager) {
        manager.listResources(this.path, path -> path.toString().endsWith(this.suffix())).forEach((id, resource) -> {
            List resources = manager.getResourceStack(id);
            for (Resource res : resources) {
                try {
                    InputStream input = res.open();
                    try {
                        ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace(this.idRemove, "").replace(this.suffix(), ""));
                        this.loadJson(input, key);
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (Exception e) {
                    this.onError((ResourceLocation)id, e);
                }
            }
        });
        this.postLoad();
    }

    @Override
    protected void preLoad() {
    }

    @Override
    protected void onLoad(ResourceLocation key, JsonObject object) {
        Optional<TagFile> tagOpt = TagFile.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)object).result().map(Pair::getFirst);
        tagOpt.ifPresent(tag -> {
            TagFile existing = this.files.get(key);
            if (existing == null || tag.replace()) {
                this.files.put(key, (TagFile)tag);
            } else {
                this.files.put(key, this.mergeTags(existing, (TagFile)tag));
            }
        });
    }

    @Override
    protected void onError(ResourceLocation id, Exception e) {
        CobblemonRaidDens.LOGGER.error("Failed to load boss tag {}", (Object)id, (Object)e);
    }

    @Override
    protected void postLoad() {
        RaidRegistry.setTags(this.resolve(this.files));
    }

    private TagFile mergeTags(TagFile base, TagFile additional) {
        ArrayList combined = new ArrayList(base.entries());
        combined.addAll(additional.entries());
        return new TagFile(combined, false);
    }

    private Map<ResourceLocation, Set<ResourceLocation>> resolve(Map<ResourceLocation, TagFile> files) {
        HashMap<ResourceLocation, Set<ResourceLocation>> resolved = new HashMap<ResourceLocation, Set<ResourceLocation>>();
        for (Map.Entry<ResourceLocation, TagFile> entry : files.entrySet()) {
            this.resolveTag(entry.getKey(), files, resolved, new HashSet<ResourceLocation>());
        }
        return resolved;
    }

    private Set<ResourceLocation> resolveTag(ResourceLocation id, Map<ResourceLocation, TagFile> all, Map<ResourceLocation, Set<ResourceLocation>> cache, Set<ResourceLocation> visited) {
        if (cache.containsKey(id)) {
            return cache.get(id);
        }
        if (!visited.add(id)) {
            throw new IllegalStateException("Circular tag reference in " + String.valueOf(id));
        }
        TagFile file = all.get(id);
        if (file == null) {
            return Set.of();
        }
        HashSet<ResourceLocation> elements = new HashSet<ResourceLocation>();
        for (TagEntry tag : file.entries()) {
            if (((TagEntryMixin)tag).isTag()) {
                elements.addAll(this.resolveTag(((TagEntryMixin)tag).getId(), all, cache, visited));
                continue;
            }
            elements.add(((TagEntryMixin)tag).getId());
        }
        cache.put(id, elements);
        return elements;
    }
}

