/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.reloaders;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.reloaders.AbstractReloadImpl;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class RaidBossReloadImpl
extends AbstractReloadImpl {
    public RaidBossReloadImpl() {
        super("raid/boss", AbstractReloadImpl.DataType.JSON);
    }

    @Override
    protected void preLoad() {
        RaidRegistry.clear();
    }

    @Override
    protected void onLoad(ResourceLocation key, JsonObject object) {
        Optional<RaidBoss> raidBossOpt = RaidBoss.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)object).result().map(Pair::getFirst);
        raidBossOpt.ifPresent(raidBoss -> {
            raidBoss.setId(key);
            RaidRegistry.register(raidBoss);
        });
    }

    @Override
    protected void onError(ResourceLocation id, Exception e) {
        CobblemonRaidDens.LOGGER.error("Failed to load raid boss {}", (Object)id, (Object)e);
    }

    @Override
    protected void postLoad() {
    }
}

