/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.helpers;

import com.necro.raid.dens.common.data.dimension.RaidRegion;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class RaidRegionHelper {
    private static final int SPACING = 2000;
    private static final int RAID_CAP = 10000;
    private static final Map<UUID, Integer> INDEX_MAP = new HashMap<UUID, Integer>();
    private static final Map<Integer, RaidRegion> REGION_MAP = new HashMap<Integer, RaidRegion>();

    public static RaidRegion createRegion(UUID raid, ResourceLocation structure) {
        OptionalInt optionalIndex = IntStream.range(0, 10000).filter(i -> !REGION_MAP.containsKey(i)).findFirst();
        if (optionalIndex.isEmpty()) {
            return null;
        }
        int index = optionalIndex.getAsInt();
        RaidRegion region = new RaidRegion(RaidRegionHelper.coordFromIndex(index), structure);
        INDEX_MAP.put(raid, index);
        REGION_MAP.put(index, region);
        return region;
    }

    public static RaidRegion getRegion(UUID raid) {
        Integer index = INDEX_MAP.get(raid);
        if (index == null) {
            return null;
        }
        return REGION_MAP.get(index);
    }

    public static void clearRegion(UUID raid, ServerLevel level) {
        Integer index = INDEX_MAP.remove(raid);
        if (index == null) {
            return;
        }
        REGION_MAP.remove(index).clearRegion(level);
    }

    private static BlockPos coordFromIndex(int index) {
        int z;
        int x;
        int side;
        if (index == 0) {
            return BlockPos.ZERO;
        }
        int k = (int)Math.ceil((Math.sqrt(index + 1) - 1.0) / 2.0);
        int start = (2 * k - 1) * (2 * k - 1);
        int t = index - start;
        if (t < (side = 2 * k)) {
            x = k;
            z = -k + t;
        } else if (t < 2 * side) {
            x = k - (t - side);
            z = k;
        } else if (t < 3 * side) {
            x = -k;
            z = k - (t - 2 * side);
        } else {
            x = -k + (t - 3 * side);
            z = -k;
        }
        return new BlockPos(x * 2000, 0, z * 2000);
    }
}

