/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.battle;

import com.necro.raid.dens.common.raids.battle.BossSide;
import com.necro.raid.dens.common.raids.battle.RaidConditions;
import com.necro.raid.dens.common.raids.battle.TrainerSide;
import com.necro.raid.dens.common.showdown.events.ClearFieldShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ClearTerrainShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ClearWeatherShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SetFieldShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SetTerrainShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SetWeatherShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SwapSideConditionsShowdownEvent;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class RaidBattleState {
    public final TrainerSide trainerSide = new TrainerSide();
    public final BossSide bossSide = new BossSide();
    public String terrain = null;
    public Set<String> fields = new HashSet<String>();
    public String weather = null;

    public Optional<ShowdownEvent> addTerrain(String terrain) {
        if (this.terrain != null && this.terrain.equals(terrain)) {
            return Optional.empty();
        }
        this.terrain = terrain;
        return Optional.of(new SetTerrainShowdownEvent(terrain, true));
    }

    public Optional<ShowdownEvent> removeTerrain() {
        if (this.terrain == null) {
            return Optional.empty();
        }
        this.terrain = null;
        return Optional.of(new ClearTerrainShowdownEvent());
    }

    public Optional<ShowdownEvent> addField(String field) {
        if (this.fields.contains(field)) {
            return this.removeField(field);
        }
        this.fields.add(field);
        return Optional.of(new SetFieldShowdownEvent(field));
    }

    public Optional<ShowdownEvent> removeField(String field) {
        if (!this.fields.contains(field)) {
            return Optional.empty();
        }
        this.fields.remove(field);
        return Optional.of(new ClearFieldShowdownEvent(field));
    }

    public Optional<ShowdownEvent> addWeather(String weather) {
        if (this.weather != null && this.weather.equals(weather)) {
            return Optional.empty();
        }
        if (this.weather != null && RaidConditions.PRIMAL_WEATHER.contains(this.weather) && !RaidConditions.PRIMAL_WEATHER.contains(weather)) {
            return Optional.empty();
        }
        this.weather = weather;
        return Optional.of(new SetWeatherShowdownEvent(weather, true));
    }

    public Optional<ShowdownEvent> removeWeather() {
        if (this.weather == null) {
            return Optional.empty();
        }
        this.weather = null;
        return Optional.of(new ClearWeatherShowdownEvent());
    }

    public Optional<ShowdownEvent> swapSideConditions() {
        if (this.trainerSide.sideConditions.isEmpty() && this.bossSide.sideConditions.isEmpty()) {
            return Optional.empty();
        }
        Set tempSideConditions = this.trainerSide.sideConditions;
        this.trainerSide.sideConditions = this.bossSide.sideConditions;
        this.bossSide.sideConditions = tempSideConditions;
        return Optional.of(new SwapSideConditionsShowdownEvent());
    }
}

