/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.raid;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.UUID;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonBattle.class})
public abstract class PokemonBattleMixin
implements IRaidBattle {
    @Unique
    private RaidInstance crd_raidInstance;
    @Unique
    private boolean crd_queueTera;

    @Shadow(remap=false)
    public abstract int getTurn();

    @Shadow(remap=false)
    public abstract void log(String var1);

    @Shadow(remap=false)
    public abstract UUID getBattleId();

    @Override
    public boolean crd_isRaidBattle() {
        return this.crd_raidInstance != null;
    }

    @Override
    public RaidInstance crd_getRaidBattle() {
        return this.crd_raidInstance;
    }

    @Override
    public void crd_setRaidBattle(RaidInstance raidInstance) {
        this.crd_raidInstance = raidInstance;
    }

    @Inject(method={"turn(I)V"}, at={@At(value="RETURN")}, remap=false)
    private void turnInject(int newTurnNumber, CallbackInfo ci) {
        if (!this.crd_isRaidBattle()) {
            return;
        }
        this.crd_raidInstance.runScriptByTurn(newTurnNumber, (PokemonBattle)this);
    }

    @Inject(method={"writeShowdownAction([Ljava/lang/String;)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void triggerTerastallization(String[] messages, CallbackInfo ci) {
        if (this.getTurn() != 1 && !this.crd_queueTera) {
            return;
        }
        if (!this.crd_isRaidBattle()) {
            return;
        }
        if (!messages[0].startsWith(">p2")) {
            return;
        }
        if (!this.crd_raidInstance.getRaidBoss().isTera()) {
            return;
        }
        if (!messages[0].startsWith(">p2 move")) {
            this.crd_queueTera = true;
            return;
        }
        this.log(String.join((CharSequence)"\n", messages));
        String[] messageList = new String[]{messages[0] + " terastal"};
        ShowdownService.Companion.getService().send(this.getBattleId(), messageList);
        this.crd_queueTera = false;
        ci.cancel();
    }
}

