/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.battlesync;

import com.cobblemon.mod.common.api.battles.interpreter.BasicContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.dispatch.DispatchResult;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.interpreter.instructions.BoostInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BoostInstruction.class})
public abstract class BoostInstructionMixin {
    @Shadow(remap=false)
    public abstract BattlePokemon getPokemon();

    @Shadow(remap=false)
    public abstract int getStages();

    @Shadow(remap=false)
    public abstract String getStatKey();

    @Shadow
    public abstract boolean isBoost();

    @Inject(method={"postActionEffect(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V"}, at={@At(value="HEAD")}, remap=false)
    private void postActionEffectInject(PokemonBattle battle, CallbackInfo ci) {
        if (!((IRaidBattle)battle).crd_isRaidBattle()) {
            return;
        }
        RaidInstance raid = ((IRaidBattle)battle).crd_getRaidBattle();
        BattlePokemon battlePokemon = this.getPokemon();
        if (battlePokemon == null || battlePokemon.getEntity() == null) {
            return;
        }
        if (!((IRaidAccessor)battlePokemon.getEntity()).crd_isRaidBoss()) {
            return;
        }
        Stats stat = Stats.Companion.getStat(this.getStatKey());
        battle.dispatch(() -> this.lambda$postActionEffectInject$2(raid, battle, (Stat)stat));
    }

    private /* synthetic */ DispatchResult lambda$postActionEffectInject$2(RaidInstance raid, PokemonBattle battle, Stat stat) {
        int stages = this.getStages();
        raid.updateBattleState(battle, battleState -> battleState.bossSide.pokemon.boost(stat, this.isBoost() ? stages : -stages));
        raid.updateBattleContext(battle, b -> {
            BattlePokemon pokemon = ((ActiveBattlePokemon)b.getSide2().getActivePokemon().getFirst()).getBattlePokemon();
            if (pokemon == null) {
                return;
            }
            BasicContext context = new BasicContext(this.getStatKey(), b.getTurn(), this.isBoost() ? BattleContext.Type.BOOST : BattleContext.Type.UNBOOST, null);
            for (int i = 0; i < stages; ++i) {
                pokemon.getContextManager().add(new BattleContext[]{context});
            }
        });
        return DispatchResultKt.getGO();
    }
}

