/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.loot.function;

import com.cobblemon.mod.common.CobblemonItems;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.data.raid.RaidType;
import com.necro.raid.dens.common.loot.LootFunctions;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class GemTypeFunction
extends LootItemConditionalFunction {
    private static ItemStack[] GEMS = null;
    public static final MapCodec<GemTypeFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> GemTypeFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, GemTypeFunction::new));

    protected GemTypeFunction(List<LootItemCondition> list) {
        super(list);
    }

    @NotNull
    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)LootFunctions.GEM_TYPE_FUNCTION.value();
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack itemStack, LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity == null) {
            return itemStack;
        }
        if (!(entity instanceof LivingEntity)) {
            return itemStack;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack heldItem = livingEntity.getMainHandItem();
        if (!heldItem.has((DataComponentType)ModComponents.TIER_COMPONENT.value())) {
            return itemStack;
        }
        RaidTier raidTier = (RaidTier)((Object)heldItem.get((DataComponentType)ModComponents.TIER_COMPONENT.value()));
        if (!heldItem.has((DataComponentType)ModComponents.TYPE_COMPONENT.value())) {
            return itemStack;
        }
        RaidType raidType = (RaidType)((Object)heldItem.get((DataComponentType)ModComponents.TYPE_COMPONENT.value()));
        assert (raidTier != null && raidType != null);
        if (raidType == RaidType.NONE) {
            return itemStack;
        }
        itemStack = this.getGem(raidType, lootContext.getRandom());
        return itemStack;
    }

    public static LootItemConditionalFunction.Builder<?> apply() {
        return GemTypeFunction.simpleBuilder(GemTypeFunction::new);
    }

    private ItemStack getRandomGem(RandomSource randomSource) {
        if (GEMS == null) {
            GEMS = new ItemStack[]{CobblemonItems.FIGHTING_GEM.getDefaultInstance(), CobblemonItems.FLYING_GEM.getDefaultInstance(), CobblemonItems.POISON_GEM.getDefaultInstance(), CobblemonItems.GROUND_GEM.getDefaultInstance(), CobblemonItems.ROCK_GEM.getDefaultInstance(), CobblemonItems.BUG_GEM.getDefaultInstance(), CobblemonItems.GHOST_GEM.getDefaultInstance(), CobblemonItems.STEEL_GEM.getDefaultInstance(), CobblemonItems.FIRE_GEM.getDefaultInstance(), CobblemonItems.WATER_GEM.getDefaultInstance(), CobblemonItems.GRASS_GEM.getDefaultInstance(), CobblemonItems.ELECTRIC_GEM.getDefaultInstance(), CobblemonItems.PSYCHIC_GEM.getDefaultInstance(), CobblemonItems.ICE_GEM.getDefaultInstance(), CobblemonItems.DRAGON_GEM.getDefaultInstance(), CobblemonItems.DARK_GEM.getDefaultInstance(), CobblemonItems.FAIRY_GEM.getDefaultInstance(), CobblemonItems.NORMAL_GEM.getDefaultInstance()};
        }
        int rand = randomSource.nextInt(0, 18);
        return GEMS[rand];
    }

    private ItemStack getGem(RaidType raidType, RandomSource randomSource) {
        return switch (raidType) {
            case RaidType.NORMAL -> CobblemonItems.NORMAL_GEM.getDefaultInstance();
            case RaidType.FIGHTING -> CobblemonItems.FIGHTING_GEM.getDefaultInstance();
            case RaidType.FLYING -> CobblemonItems.FLYING_GEM.getDefaultInstance();
            case RaidType.POISON -> CobblemonItems.POISON_GEM.getDefaultInstance();
            case RaidType.GROUND -> CobblemonItems.GROUND_GEM.getDefaultInstance();
            case RaidType.ROCK -> CobblemonItems.ROCK_GEM.getDefaultInstance();
            case RaidType.BUG -> CobblemonItems.BUG_GEM.getDefaultInstance();
            case RaidType.GHOST -> CobblemonItems.GHOST_GEM.getDefaultInstance();
            case RaidType.STEEL -> CobblemonItems.STEEL_GEM.getDefaultInstance();
            case RaidType.FIRE -> CobblemonItems.FIRE_GEM.getDefaultInstance();
            case RaidType.WATER -> CobblemonItems.WATER_GEM.getDefaultInstance();
            case RaidType.GRASS -> CobblemonItems.GRASS_GEM.getDefaultInstance();
            case RaidType.ELECTRIC -> CobblemonItems.ELECTRIC_GEM.getDefaultInstance();
            case RaidType.PSYCHIC -> CobblemonItems.PSYCHIC_GEM.getDefaultInstance();
            case RaidType.ICE -> CobblemonItems.ICE_GEM.getDefaultInstance();
            case RaidType.DRAGON -> CobblemonItems.DRAGON_GEM.getDefaultInstance();
            case RaidType.DARK -> CobblemonItems.DARK_GEM.getDefaultInstance();
            case RaidType.FAIRY -> CobblemonItems.FAIRY_GEM.getDefaultInstance();
            default -> this.getRandomGem(randomSource);
        };
    }
}

