/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.dimensions;

import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;

public class ModDimensions {
    public static final ResourceKey<DimensionType> RAID_DIM_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_dimension_type"));
    public static final ResourceKey<Biome> RAID_DIM_BIOME = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_den"));
    public static final ResourceKey<LevelStem> RAID_DIM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_dimension"));
    public static final ResourceKey<Level> RAID_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_dimension"));

    public static ServerLevel getRaidDimension(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        return server.getLevel(RAID_DIMENSION);
    }

    public static void onDimensionChange(ServerPlayer player, ServerLevel from, ServerLevel to) {
        RaidJoinHelper.Participant participant = RaidJoinHelper.getParticipant((Player)player);
        if (participant == null) {
            return;
        }
        RaidInstance raid = RaidHelper.ACTIVE_RAIDS.get(participant.raid());
        if (raid == null) {
            return;
        }
        if (RaidUtils.isRaidDimension((Level)from)) {
            raid.removeFromBossEvent(player);
        } else if (RaidUtils.isRaidDimension((Level)to)) {
            raid.addToBossEvent(player);
        }
    }
}

