/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.data.dimension;

import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.registry.RaidDenRegistry;
import com.necro.raid.dens.common.util.IRaidTeleporter;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RaidRegion {
    private static final int RADIUS = 128;
    private final BlockPos centre;
    private final AABB bound;
    private ResourceLocation structure;

    public RaidRegion(BlockPos centre, ResourceLocation structure) {
        this.centre = centre;
        this.bound = new AABB((double)(centre.getX() - 128), -64.0, (double)(centre.getZ() - 128), (double)(centre.getX() + 128), 128.0, (double)(centre.getZ() + 128));
        this.structure = structure;
    }

    public BlockPos centre() {
        return this.centre;
    }

    public AABB bound() {
        return this.bound;
    }

    public BlockPos getOffset() {
        return BlockPos.containing((Position)RaidDenRegistry.getOffset(this.structure).add(this.centre.getBottomCenter()));
    }

    public Vec3 getPlayerPos() {
        return RaidDenRegistry.getPlayerPos(this.structure).add(Vec3.atLowerCornerOf((Vec3i)this.centre));
    }

    public Vec3 getBossPos() {
        return RaidDenRegistry.getBossPos(this.structure).add(Vec3.atLowerCornerOf((Vec3i)this.centre));
    }

    public void clearRegion(ServerLevel level) {
        int minX = this.centre.getX() - 128;
        int maxX = this.centre.getX() + 128;
        int minZ = this.centre.getZ() - 128;
        int maxZ = this.centre.getZ() + 128;
        int chunkMinX = minX >> 4;
        int chunkMaxX = maxX >> 4;
        int chunkMinZ = minZ >> 4;
        int chunkMaxZ = maxZ >> 4;
        level.getEntitiesOfClass(ServerPlayer.class, this.bound()).forEach(player -> {
            RaidUtils.leaveRaid((Player)player);
            ((IRaidTeleporter)player).crd_returnHome();
        });
        for (Entity e : level.getEntitiesOfClass(Entity.class, this.bound())) {
            if (e == null || e instanceof Player) continue;
            e.discard();
        }
        for (int cx = chunkMinX; cx <= chunkMaxX; ++cx) {
            for (int cz = chunkMinZ; cz <= chunkMaxZ; ++cz) {
                LevelChunk chunk = level.getChunk(cx, cz);
                LevelChunkSection[] sections = chunk.getSections();
                for (int i = 0; i < sections.length; ++i) {
                    LevelChunkSection section = sections[i];
                    if (section == null || section.hasOnlyAir()) continue;
                    Registry registry = level.registryAccess().registryOrThrow(Registries.BIOME);
                    chunk.getSections()[i] = new LevelChunkSection(new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES), (PalettedContainerRO)new PalettedContainer(registry.asHolderIdMap(), (Object)registry.getHolderOrThrow(ModDimensions.RAID_DIM_BIOME), PalettedContainer.Strategy.SECTION_BIOMES));
                    chunk.getBlockEntities().keySet().forEach(arg_0 -> ((LevelChunk)chunk).removeBlockEntity(arg_0));
                    section.recalcBlockCounts();
                }
                chunk.setUnsaved(true);
            }
        }
    }

    public void placeStructure(ServerLevel level) {
        StructureTemplateManager manager = level.getServer().getStructureManager();
        StructureTemplate template = manager.get(this.structure).orElseGet(() -> {
            this.structure = RaidDenRegistry.DEFAULT;
            return manager.getOrCreate(this.structure);
        });
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.clearProcessors();
        settings.addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        BlockPos offset = this.getOffset();
        template.placeInWorld((ServerLevelAccessor)level, offset, offset, settings, level.getRandom(), 0);
        level.setBlockAndUpdate(this.centre(), ModBlocks.INSTANCE.getRaidHomeBlock().defaultBlockState());
        ChunkPos chunkPos = new ChunkPos(this.centre());
        level.getChunkSource().addRegionTicket(TicketType.FORCED, chunkPos, 1, (Object)chunkPos);
    }

    public void removeRegionTicket(ServerLevel level) {
        ChunkPos chunkPos = new ChunkPos(this.centre());
        level.getChunkSource().removeRegionTicket(TicketType.FORCED, chunkPos, 1, (Object)chunkPos);
    }
}

