/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.data.adapters;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonArray;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;

public record ScriptAdapter(List<String> functions) {
    public static final Codec<ScriptAdapter> CODEC = Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).xmap(either -> (ScriptAdapter)either.map(ScriptAdapter::new, ScriptAdapter::new), script -> {
        if (script.functions.size() == 1) {
            return Either.left((Object)script.functions.getFirst());
        }
        return Either.right(script.functions);
    });

    public ScriptAdapter(String function) {
        this(List.of(function));
    }

    public JsonElement serialize() {
        if (this.functions().size() == 1) {
            return new JsonPrimitive((Object)this.functions().getFirst());
        }
        JsonArray array = new JsonArray();
        this.functions().forEach(function -> array.add((JsonElement)new JsonPrimitive(function)));
        return array;
    }

    public static ScriptAdapter deserialize(JsonElement json) {
        JsonElement jsonElement = json;
        Objects.requireNonNull(jsonElement);
        JsonElement jsonElement2 = jsonElement;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class, JsonArray.class}, (Object)jsonElement2, n)) {
            case 0: {
                JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                return new ScriptAdapter((String)primitive.getValue());
            }
            case 1: {
                JsonArray array = (JsonArray)jsonElement2;
                ArrayList<String> functions = new ArrayList<String>();
                for (JsonElement element : array) {
                    if (!(element instanceof JsonPrimitive)) continue;
                    JsonPrimitive primitive = (JsonPrimitive)element;
                    functions.add((String)primitive.getValue());
                }
                return new ScriptAdapter(functions);
            }
        }
        throw new IllegalArgumentException("Expected string or string array for Script, got: " + String.valueOf(json));
    }
}

