/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.config;

import com.cobblemon.mod.common.api.mark.Mark;
import com.cobblemon.mod.common.api.mark.Marks;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.data.adapters.ScriptAdapter;
import com.necro.raid.dens.common.data.raid.RaidAI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.resources.ResourceLocation;

@Config(name="cobblemonraiddens/tier_five")
public class TierFiveConfig
implements ConfigData,
TierConfig {
    @Comment(value="Raids require key items to interact with. Default: false")
    public boolean requires_key = false;
    @Comment(value="Whether all players require the unique key or just the host. Default: true")
    public boolean all_require_unique = true;
    @Comment(value="Maximum number of players in a raid (Set to -1 for no limit). Default: 4")
    public int max_players = 4;
    @Comment(value="Number of clears until the raid den deactivates (Set to -1 for no limit). Default: 3")
    public int max_clears = 3;
    @Comment(value="The max number of cheers a player can use per raid. Default: 3")
    public int max_cheers = 3;
    @Comment(value="The chance for raid bosses to have their hidden ability. Default: 0.20")
    public double ha_rate = 0.2;
    @Comment(value="The max number Pokemon a player can use in a raid. Default: 1")
    public int raid_party_size = 1;
    @Comment(value="Raid boss HP multiplier. Default: 20")
    public int health_multiplier = 20;
    @Comment(value="Bonus raid boss HP multiplier for each extra player that joins the raid battle. Default: 1.0")
    public float multiplayer_health_multiplier = 1.0f;
    @Comment(value="Raid boss level. Default: 75")
    public int boss_level = 75;
    @Comment(value="Reward Pokemon level. Default: 75")
    public int reward_level = 75;
    @Comment(value="Reward Pokemon number of max IVs. Default: 4")
    public int ivs = 4;
    @Comment(value="The default shiny chance for raid bosses as 1 in X (Set to -1 to use the Cobblemon rate). Default: -1.0")
    public float shiny_rate = -1.0f;
    @Comment(value="How much currency is rewarded for clearing a raid boss (Requires CobbleDollars). Default: 20000")
    public int currency = 20000;
    @Comment(value="The max number of Pokemon that can be caught from a raid battle. Default: -1.")
    public int max_catches = -1;
    @Comment(value="The default script to add to raid bosses without a script. Default: {}")
    public Map<String, ScriptAdapter> default_scripts = new HashMap<String, ScriptAdapter>();
    @Comment(value="The battle AI used by the raid boss (Options: RANDOM, STRONG, RCT). Default: RANDOM")
    public RaidAI raid_ai = RaidAI.RANDOM;
    @Comment(value="The list of marks the reward Pokemon will have. Default: [].")
    public String[] marks = new String[0];

    @Override
    public boolean requiresKey() {
        return this.requires_key;
    }

    @Override
    public boolean allRequireUniqueKey() {
        return this.all_require_unique;
    }

    @Override
    public int maxPlayers() {
        return this.max_players;
    }

    @Override
    public int maxClears() {
        return this.max_clears;
    }

    @Override
    public double haRate() {
        return this.ha_rate;
    }

    @Override
    public int maxCheers() {
        return this.max_cheers;
    }

    @Override
    public int raidPartySize() {
        return this.raid_party_size;
    }

    @Override
    public int healthMultiplier() {
        return this.health_multiplier;
    }

    @Override
    public float multiplayerHealthMultiplier() {
        return this.multiplayer_health_multiplier;
    }

    @Override
    public int bossLevel() {
        return this.boss_level;
    }

    @Override
    public int rewardLevel() {
        return this.reward_level;
    }

    @Override
    public int ivs() {
        return this.ivs;
    }

    @Override
    public float shinyRate() {
        return this.shiny_rate;
    }

    @Override
    public int currency() {
        return this.currency;
    }

    @Override
    public int maxCatches() {
        return this.max_catches;
    }

    @Override
    public Map<String, ScriptAdapter> defaultScripts() {
        return this.default_scripts;
    }

    @Override
    public RaidAI raidAI() {
        return this.raid_ai;
    }

    @Override
    public List<Mark> marks() {
        return Arrays.stream(this.marks).map(string -> Marks.getByIdentifier((ResourceLocation)ResourceLocation.parse((String)string))).filter(Objects::nonNull).toList();
    }
}

