/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.compat.jade;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.jade.ElementalTypeElement;
import com.necro.raid.dens.common.compat.jade.TeraTypeElement;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidFeature;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.data.raid.RaidType;
import com.necro.raid.dens.common.registry.RaidRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum RaidCrystalComponents implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    private IElement getIconClient(BlockAccessor accessor, IElement currentIcon) {
        RaidBoss raidBoss;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return currentIcon;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        if (RaidRegistry.REGISTRY == null) {
            RaidRegistry.REGISTRY = blockEntity.getLevel().registryAccess().registryOrThrow(RaidRegistry.RAID_BOSS_KEY);
        }
        if ((raidBoss = (RaidBoss)RaidRegistry.REGISTRY.get(raidCrystal.getRaidBossLocation())) == null) {
            return currentIcon;
        }
        if (raidBoss.getDisplayAspects() == null) {
            raidBoss.createDisplayAspects();
        }
        ItemStack stack = PokemonItem.from((Species)raidBoss.getDisplaySpecies(), raidBoss.getDisplayAspects(), (int)1, null);
        return IElementHelper.get().item(stack, 1.5f);
    }

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (!accessor.isServerConnected()) {
            return this.getIconClient(accessor, currentIcon);
        }
        CompoundTag serverData = accessor.getServerData();
        if (!serverData.contains("boss_aspects") || !serverData.contains("boss_species")) {
            return currentIcon;
        }
        IElementHelper elements = IElementHelper.get();
        Species species = PokemonSpecies.getByIdentifier((ResourceLocation)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace((String)serverData.getString("boss_species"), (String)"cobblemon"));
        if (species == null) {
            return currentIcon;
        }
        HashSet<String> aspects = new HashSet<String>();
        ListTag listTag = serverData.getList("boss_aspects", 8);
        for (Tag t : listTag) {
            StringTag tag = (StringTag)t;
            aspects.add(tag.getAsString());
        }
        ItemStack stack = PokemonItem.from((Species)species, aspects, (int)1, null);
        return elements.item(stack, 1.5f);
    }

    private IElement getTeraTypeIcon(RaidType type) {
        String string = String.format("mega_showdown:textures/gui/summary/tera_types/%s.png", type.getSerializedName());
        return new TeraTypeElement(ResourceLocation.parse((String)string), 32, 32);
    }

    private IElement getElementalTypeIcon(RaidType type) {
        String string = "cobblemon:textures/gui/types_small.png";
        return new ElementalTypeElement(ResourceLocation.parse((String)string), 324, 18, type);
    }

    private void appendTooltipClient(ITooltip tooltip, BlockAccessor accessor) {
        RaidBoss raidBoss;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        BlockState blockState = accessor.getBlockState();
        if (RaidRegistry.REGISTRY == null) {
            RaidRegistry.REGISTRY = raidCrystal.getLevel().registryAccess().registryOrThrow(RaidRegistry.RAID_BOSS_KEY);
        }
        if ((raidBoss = (RaidBoss)RaidRegistry.REGISTRY.get(raidCrystal.getRaidBossLocation())) == null) {
            return;
        }
        RaidTier tier = (RaidTier)((Object)blockState.getValue(RaidCrystalBlock.RAID_TIER));
        RaidType type = (RaidType)((Object)blockState.getValue(RaidCrystalBlock.RAID_TYPE));
        RaidFeature feature = raidBoss.getFeature();
        if (raidBoss.getDisplayAspects() == null) {
            raidBoss.createDisplayAspects();
        }
        MutableComponent component = raidBoss.getDisplaySpecies().getTranslatedName();
        component.append(" | ").append((Component)Component.translatable((String)feature.getTranslatable()));
        component.append(" | ").append(tier.getStars());
        tooltip.add((Component)component, this.getUid());
        IElementHelper helper = IElementHelper.get();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(helper.text((Component)Component.literal((String)" ")));
        if (type != RaidType.STELLAR) {
            elements.add(this.getElementalTypeIcon(type));
            tooltip.append(0, elements);
        } else if (ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            elements.add(this.getTeraTypeIcon(type));
            tooltip.append(0, elements);
        }
        int catches = raidBoss.getMaxCatches();
        if (catches == 0) {
            tooltip.add((IElement)helper.text((Component)Component.translatable((String)"jade.cobblemonraiddens.not_catchable").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY)).scale(0.5f));
        } else if (catches > 0) {
            tooltip.add((IElement)helper.text((Component)Component.translatable((String)"jade.cobblemonraiddens.max_catches", (Object[])new Object[]{catches}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY)).scale(0.5f));
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!accessor.isServerConnected()) {
            this.appendTooltipClient(tooltip, accessor);
            return;
        }
        CompoundTag serverData = accessor.getServerData();
        if (!serverData.contains("raid_boss")) {
            return;
        }
        MutableComponent component = Component.translatable((String)serverData.getString("raid_boss"));
        if (serverData.contains("raid_feature")) {
            component.append(" | ").append((Component)Component.translatable((String)serverData.getString("raid_feature")));
        }
        BlockState blockState = accessor.getBlockState();
        RaidTier tier = (RaidTier)((Object)blockState.getValue(RaidCrystalBlock.RAID_TIER));
        component.append(" | ").append(tier.getStars());
        tooltip.add((Component)component, this.getUid());
        RaidType type = (RaidType)((Object)blockState.getValue(RaidCrystalBlock.RAID_TYPE));
        IElementHelper helper = IElementHelper.get();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(helper.text((Component)Component.literal((String)" ")));
        if (type != RaidType.STELLAR) {
            elements.add(this.getElementalTypeIcon(type));
            tooltip.append(0, elements);
        } else if (ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            elements.add(this.getTeraTypeIcon(type));
            tooltip.append(0, elements);
        }
        MutableComponent component1 = Component.empty();
        if (serverData.contains("player_count")) {
            component1.append((Component)Component.translatable((String)"jade.cobblemonraiddens.player_count", (Object[])new Object[]{serverData.getInt("player_count")}));
            component1.append(" | ");
        }
        if (serverData.contains("next_reset")) {
            component1.append(serverData.getString("next_reset"));
        }
        if (!component1.equals((Object)Component.empty())) {
            tooltip.add((Component)component1);
        }
        if (serverData.contains("max_catches")) {
            int catches = serverData.getInt("max_catches");
            if (catches == 0) {
                tooltip.add((IElement)helper.text((Component)Component.translatable((String)"jade.cobblemonraiddens.not_catchable").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY)).scale(0.5f));
            } else {
                tooltip.add((IElement)helper.text((Component)Component.translatable((String)"jade.cobblemonraiddens.max_catches", (Object[])new Object[]{catches}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY)).scale(0.5f));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        RaidBoss raidBoss = raidCrystal.getRaidBoss();
        if (raidBoss == null) {
            return;
        }
        if (raidBoss.getDisplaySpecies() == null) {
            raidBoss.createDisplayAspects();
        }
        Species species = raidBoss.getDisplaySpecies();
        String translatable = String.format("%s.species.%s.name", species.getResourceIdentifier().getNamespace(), species.showdownId());
        compoundTag.putString("raid_boss", translatable);
        compoundTag.putString("raid_feature", raidBoss.getFeature().getTranslatable());
        compoundTag.putString("boss_species", species.getResourceIdentifier().toString());
        ListTag bossAspects = new ListTag();
        for (String aspect : raidBoss.getDisplayAspects()) {
            if (aspect == null) continue;
            bossAspects.add((Object)StringTag.valueOf((String)aspect));
        }
        for (SpeciesFeature form : raidBoss.getRaidForm()) {
            String aspect;
            if (form instanceof StringSpeciesFeature) {
                aspect = ((StringSpeciesFeature)form).getValue();
            } else {
                if (!(form instanceof FlagSpeciesFeature)) continue;
                aspect = form.getName();
            }
            bossAspects.add((Object)StringTag.valueOf((String)aspect));
        }
        compoundTag.put("boss_aspects", (Tag)bossAspects);
        if (raidCrystal.getPlayerCount() > 0) {
            compoundTag.putInt("player_count", raidCrystal.getPlayerCount());
        }
        if (raidCrystal.getTicksUntilNextReset() > 0L) {
            compoundTag.putString("next_reset", this.formatTicks(raidCrystal.getTicksUntilNextReset()));
        }
        if (raidBoss.getMaxCatches() >= 0) {
            compoundTag.putInt("max_catches", raidBoss.getMaxCatches().intValue());
        }
    }

    private String formatTicks(long ticks) {
        int totalSeconds = (int)ticks / 20;
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_crystal");
    }
}

