/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.commands;

import com.cobblemon.mod.common.api.permission.Permission;
import com.cobblemon.mod.common.api.permission.PermissionLevel;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.necro.raid.dens.common.commands.RaidDenCommands;
import com.necro.raid.dens.common.commands.permission.RaidDenPermission;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RaidSpawnCommands {
    private static final Permission SPAWN_BOSS = new RaidDenPermission("command.spawnboss", PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"crd").then(PermissionUtilsKt.permission((ArgumentBuilder)Commands.literal((String)"spawnboss").then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.literal((String)"boss").then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(RaidDenCommands.RAID_BOSSES).executes(context -> RaidSpawnCommands.spawnBoss(Vec3Argument.getVec3((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), true, true, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"noAI", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss(Vec3Argument.getVec3((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), true, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"isInvulnerable", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss(Vec3Argument.getVec3((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), BoolArgumentType.getBool((CommandContext)context, (String)"isInvulnerable"), false))).then(Commands.argument((String)"isPersistent", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss(Vec3Argument.getVec3((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), BoolArgumentType.getBool((CommandContext)context, (String)"isInvulnerable"), BoolArgumentType.getBool((CommandContext)context, (String)"isPersistent")))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"boss").requires(CommandSourceStack::isPlayer)).then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(RaidDenCommands.RAID_BOSSES).executes(context -> RaidSpawnCommands.spawnBoss((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), true, true, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"noAI", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), true, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"isInvulnerable", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), BoolArgumentType.getBool((CommandContext)context, (String)"isInvulnerable"), false))).then(Commands.argument((String)"isPersistent", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), BoolArgumentType.getBool((CommandContext)context, (String)"isInvulnerable"), BoolArgumentType.getBool((CommandContext)context, (String)"isPersistent"))))))))), (Permission)SPAWN_BOSS, (boolean)true)));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        RaidSpawnCommands.register(dispatcher);
    }

    private static int spawnBoss(CommandContext<CommandSourceStack> context, Vec3 vec3, ResourceLocation boss, boolean noAI, boolean isInvulnerable, boolean isPersistent) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        return RaidSpawnCommands.spawnBoss(vec3, player.serverLevel(), boss, noAI, isInvulnerable, isPersistent);
    }

    private static int spawnBoss(Vec3 vec3, ServerLevel dimension, ResourceLocation boss, boolean noAI, boolean isInvulnerable, boolean isPersistent) {
        if (RaidUtils.isRaidDimension((Level)dimension)) {
            return 0;
        }
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(boss);
        if (raidBoss == null) {
            return 0;
        }
        PokemonEntity pokemonEntity = raidBoss.getBossEntity(dimension, null);
        if (noAI) {
            pokemonEntity.setNoAi(true);
        }
        if (isInvulnerable) {
            pokemonEntity.setInvulnerable(true);
        }
        if (isPersistent) {
            pokemonEntity.setPersistenceRequired();
        }
        pokemonEntity.moveTo(vec3);
        dimension.addFreshEntity((Entity)pokemonEntity);
        return 1;
    }
}

