/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.entity;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidBucket;
import com.necro.raid.dens.common.data.raid.RaidCycleMode;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.data.raid.RaidType;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.events.RaidDenSpawnEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.SetRaidBossEvent;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.registry.RaidBucketRegistry;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.util.IRaidAccessor;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class RaidCrystalBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private UUID raidHost;
    private int clears;
    private int inactiveTicks;
    private int soundTicks = 0;
    private UUID uuid;
    private ResourceLocation raidBucket;
    private ResourceLocation raidBoss;
    private long lastReset;
    private boolean isOpen = false;
    private Set<String> aspects;
    private Consumer<ServerPlayer> aspectSync;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RaidCrystalBlockEntity(BlockEntityType<? extends RaidCrystalBlockEntity> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.uuid = UUID.randomUUID();
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (level.isClientSide()) {
            return;
        }
        boolean isIdle = this.isIdle();
        if (RaidHelper.hasRaidState(this.getUuid()) && isIdle) {
            this.closeRaid();
        }
        if (this.canGenerateBoss(blockState) && (this.raidBoss == null || !RaidRegistry.exists(this.raidBoss))) {
            this.generateRaidBoss(level, blockPos, blockState);
        }
        if (this.raidHost != null && isIdle) {
            if (++this.inactiveTicks > 2400) {
                this.closeRaid();
            }
        } else {
            this.inactiveTicks = 0;
        }
        if (!((Boolean)blockState.getValue((Property)RaidCrystalBlock.CAN_RESET)).booleanValue()) {
            return;
        }
        if (CobblemonRaidDens.CONFIG.reset_time <= 0) {
            return;
        }
        if (this.isInProgress()) {
            return;
        }
        long gameTime = level.getGameTime();
        if (this.lastReset == 0L) {
            this.lastReset = gameTime;
        } else if (gameTime - this.lastReset > (long)CobblemonRaidDens.CONFIG.reset_time * 20L) {
            this.generateRaidBoss(level, blockPos, blockState);
        }
        if (!this.isActive(blockState)) {
            return;
        }
        if (++this.soundTicks % 120 == 0) {
            level.playSound(null, blockPos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.soundTicks = 0;
        }
    }

    public void generateRaidBoss(Level level, BlockPos blockPos, BlockState blockState) {
        RaidBoss raidBoss;
        RaidCycleMode cycleMode = (RaidCycleMode)((Object)blockState.getValue(RaidCrystalBlock.CYCLE_MODE));
        ResourceLocation bossLocation = null;
        if (cycleMode == RaidCycleMode.NONE) {
            return;
        }
        if (this.raidBucket != null) {
            bossLocation = RaidBucketRegistry.getBucket(this.raidBucket).getRandomRaidBoss(level.getRandom(), level);
        }
        if (bossLocation == null) {
            RaidTier tier = cycleMode.canCycleTier() ? RaidTier.getWeightedRandom(level.getRandom(), level) : (RaidTier)((Object)blockState.getValue(RaidCrystalBlock.RAID_TIER));
            RaidType type = cycleMode.canCycleType() ? null : (RaidType)((Object)blockState.getValue(RaidCrystalBlock.RAID_TYPE));
            bossLocation = RaidRegistry.getRandomRaidBoss(level.getRandom(), level, tier, type, null);
        }
        if ((raidBoss = RaidRegistry.getRaidBoss(bossLocation)) == null) {
            return;
        }
        SetRaidBossEvent event = new SetRaidBossEvent(raidBoss);
        RaidEvents.SET_RAID_BOSS.emit((Object[])new SetRaidBossEvent[]{event});
        raidBoss = event.getRaidBoss();
        if (raidBoss == null) {
            this.inactiveTicks = 0;
            this.lastReset = level.getGameTime();
            return;
        }
        this.setRaidBoss(raidBoss.getId(), level.getGameTime());
        level.setBlock(blockPos, (BlockState)((BlockState)((BlockState)blockState.setValue(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier()))).setValue(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).setValue((Property)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        RaidEvents.RAID_DEN_SPAWN.emit((Object[])new RaidDenSpawnEvent[]{new RaidDenSpawnEvent((ServerLevel)level, blockPos, raidBoss)});
    }

    public boolean spawnRaidBoss() {
        if (this.getLevel() == null) {
            return false;
        }
        RaidBoss raidBoss = this.getRaidBoss();
        RaidRegion region = RaidRegionHelper.getRegion(this.getUuid());
        ServerLevel level = ModDimensions.getRaidDimension(this.getLevel().getServer());
        if (raidBoss == null || region == null || level == null) {
            CobblemonRaidDens.LOGGER.error("Could not load Raid Boss {}", (Object)this.raidBoss);
            this.setRaidBoss(null, 0L);
            return false;
        }
        region.placeStructure(level);
        PokemonEntity pokemonEntity = raidBoss.getBossEntity(level, this.aspects);
        pokemonEntity.setNoAi(true);
        pokemonEntity.setInvulnerable(true);
        ((IRaidAccessor)pokemonEntity).crd_setRaidId(this.getUuid());
        if (CobblemonRaidDens.CONFIG.sync_rewards && this.aspects == null) {
            this.aspects = pokemonEntity.getAspects();
        }
        pokemonEntity.moveTo(region.getBossPos());
        level.addFreshEntity((Entity)pokemonEntity);
        if (pokemonEntity.getPokemon().getAbility().getName().equals("imposter")) {
            this.setAspectSync(player -> RaidDenNetworkMessages.RAID_ASPECT.accept((ServerPlayer)player, (Entity)pokemonEntity));
        }
        RaidHelper.ACTIVE_RAIDS.put(this.getUuid(), new RaidInstance(pokemonEntity, this.raidHost));
        return true;
    }

    public void clearRaid() {
        ++this.clears;
        this.aspects = null;
        if (this.isAtMaxClears()) {
            RaidHelper.resetClearedRaids(this.getUuid());
            if (this.getLevel() != null) {
                this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    private boolean shouldClear(RaidState raidState) {
        if (raidState == null) {
            return false;
        }
        if (raidState == RaidState.SUCCESS) {
            return true;
        }
        return CobblemonRaidDens.CONFIG.max_clears_include_fails && raidState != RaidState.CANCELLED;
    }

    public void closeRaid() {
        if (this.getLevel() == null) {
            return;
        }
        ServerLevel level = ModDimensions.getRaidDimension(this.getLevel().getServer());
        if (level == null) {
            return;
        }
        if (this.shouldClear(RaidHelper.getRaidState(this.getUuid()))) {
            this.clearRaid();
        }
        RaidRegionHelper.clearRegion(this.getUuid(), level);
        this.clearRaidHost();
        this.inactiveTicks = 0;
        this.getLevel().getChunkAt(this.getBlockPos()).setUnsaved(true);
        this.setChanged();
        this.isOpen = false;
        this.setAspectSync(null);
    }

    public UUID getRaidHost() {
        return this.raidHost;
    }

    public boolean canSetRaidHost() {
        return this.getRaidHost() == null;
    }

    public void setRaidHost(Player player) {
        this.raidHost = player.getUUID();
        this.setChanged();
    }

    public void clearRaidHost() {
        this.raidHost = null;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public RaidBucket getRaidBucket() {
        return RaidBucketRegistry.getBucket(this.raidBucket);
    }

    public RaidBoss getRaidBoss() {
        return RaidRegistry.getRaidBoss(this.raidBoss);
    }

    public ResourceLocation getRaidBossLocation() {
        return this.raidBoss;
    }

    public int getPlayerCount() {
        RaidInstance raid = RaidHelper.ACTIVE_RAIDS.get(this.getUuid());
        if (raid == null) {
            return 0;
        }
        return raid.getPlayers().size();
    }

    public long getTicksUntilNextReset() {
        if (this.getLevel() == null) {
            return 0L;
        }
        if (!((Boolean)this.getBlockState().getValue((Property)RaidCrystalBlock.CAN_RESET)).booleanValue()) {
            return 0L;
        }
        if (CobblemonRaidDens.CONFIG.reset_time <= 0) {
            return 0L;
        }
        return (long)CobblemonRaidDens.CONFIG.reset_time * 20L - (this.getLevel().getGameTime() - this.lastReset);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen() {
        this.isOpen = true;
    }

    public boolean isPlayerParticipating(Player player) {
        return RaidJoinHelper.isParticipating(player, this.getUuid());
    }

    public boolean isInProgress() {
        return RaidHelper.ACTIVE_RAIDS.containsKey(this.getUuid());
    }

    public boolean isIdle() {
        if (this.getLevel() == null) {
            return false;
        }
        RaidRegion region = RaidRegionHelper.getRegion(this.getUuid());
        if (region == null) {
            return true;
        }
        ServerLevel level = ModDimensions.getRaidDimension(this.getLevel().getServer());
        if (level == null) {
            return false;
        }
        int activePlayers = level.getEntitiesOfClass(Player.class, region.bound()).size();
        return activePlayers == 0;
    }

    public boolean isActive(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)RaidCrystalBlock.ACTIVE) != false && blockState.getValue(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE && this.raidBoss != null;
    }

    public boolean canGenerateBoss(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)RaidCrystalBlock.ACTIVE) != false && blockState.getValue(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE;
    }

    public boolean renderBeacon(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)RaidCrystalBlock.ACTIVE) != false && blockState.getValue(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE;
    }

    public void resetClears() {
        this.clears = 0;
    }

    public boolean isAtMaxClears() {
        RaidBoss boss = this.getRaidBoss();
        if (boss == null) {
            return true;
        }
        int maxClears = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).maxClears();
        return maxClears != -1 && this.clears >= maxClears;
    }

    public boolean isFull() {
        RaidBoss boss = this.getRaidBoss();
        if (boss == null) {
            return true;
        }
        int maxPlayers = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).maxPlayers();
        return maxPlayers != -1 && this.getPlayerCount() >= maxPlayers;
    }

    public void setRaidBucket(ResourceLocation bucket) {
        this.raidBucket = bucket;
    }

    public void syncAspects(ServerPlayer player) {
        if (this.aspectSync == null) {
            return;
        }
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS).execute(() -> this.aspectSync.accept(player));
    }

    public void setAspectSync(Consumer<ServerPlayer> sync) {
        this.aspectSync = sync;
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        if (compoundTag.contains("raid_host_uuid")) {
            this.raidHost = UUID.fromString(compoundTag.getString("raid_host_uuid"));
        }
        this.clears = compoundTag.getInt("raid_cleared");
        this.lastReset = compoundTag.getLong("last_reset");
        this.inactiveTicks = compoundTag.getInt("raid_inactive_for");
        this.uuid = compoundTag.contains("uuid") ? UUID.fromString(compoundTag.getString("uuid")) : UUID.randomUUID();
        if (compoundTag.contains("raid_bucket")) {
            this.raidBucket = ResourceLocation.parse((String)compoundTag.getString("raid_bucket"));
        }
        if (compoundTag.contains("raid_boss")) {
            this.raidBoss = ResourceLocation.parse((String)compoundTag.getString("raid_boss"));
        }
        if (compoundTag.contains("is_open")) {
            this.isOpen = true;
        }
        if (compoundTag.contains("aspects")) {
            HashSet<String> aspects = new HashSet<String>();
            for (Tag tag : compoundTag.getList("aspects", 8)) {
                aspects.add(tag.getAsString());
            }
            this.aspects = aspects;
        }
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        if (this.raidHost != null) {
            compoundTag.putString("raid_host_uuid", this.raidHost.toString());
        }
        compoundTag.putInt("raid_cleared", this.clears);
        compoundTag.putLong("last_reset", this.lastReset);
        compoundTag.putInt("raid_inactive_for", this.inactiveTicks);
        if (this.uuid != null) {
            compoundTag.putString("uuid", this.uuid.toString());
        }
        if (this.raidBucket != null) {
            compoundTag.putString("raid_bucket", this.raidBucket.toString());
        }
        if (this.raidBoss != null) {
            compoundTag.putString("raid_boss", this.raidBoss.toString());
        }
        if (this.isOpen) {
            compoundTag.putBoolean("is_open", true);
        }
        if (this.aspects != null) {
            ListTag tag = new ListTag();
            this.aspects.forEach(aspect -> tag.add((Object)StringTag.valueOf((String)aspect)));
            compoundTag.put("aspects", (Tag)tag);
        }
    }

    public void setRaidBoss(ResourceLocation raidBoss, long gameTime) {
        RaidHelper.resetClearedRaids(this.getUuid());
        this.resetClears();
        this.inactiveTicks = 0;
        this.lastReset = gameTime;
        this.raidBoss = raidBoss;
        this.aspects = null;
        this.setChanged();
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        if (this.raidBoss != null) {
            tag.putString("raid_boss", this.raidBoss.toString());
        }
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

