/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.block;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.data.adapters.UniqueKeyAdapter;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidCycleMode;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.data.raid.RaidType;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RaidJoinEvent;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.util.ComponentUtils;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RaidCrystalBlock
extends BaseEntityBlock {
    public static final EnumProperty<RaidType> RAID_TYPE = EnumProperty.create((String)"raid_type", RaidType.class);
    public static final EnumProperty<RaidTier> RAID_TIER = EnumProperty.create((String)"raid_tier", RaidTier.class);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"is_active");
    public static final BooleanProperty CAN_RESET = BooleanProperty.create((String)"can_reset");
    public static final EnumProperty<RaidCycleMode> CYCLE_MODE = EnumProperty.create((String)"cycle_mode", RaidCycleMode.class);

    public RaidCrystalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue(RAID_TYPE, (Comparable)((Object)RaidType.NONE))).setValue(RAID_TIER, (Comparable)((Object)RaidTier.TIER_ONE))).setValue((Property)CAN_RESET, (Comparable)Boolean.valueOf(false))).setValue(CYCLE_MODE, (Comparable)((Object)RaidCycleMode.NONE)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return InteractionResult.FAIL;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        boolean success = this.startOrJoinRaid(player, blockState, raidCrystal, null);
        return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack itemStack, @NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        if (raidCrystal.getRaidBoss() == null) {
            return ItemInteractionResult.FAIL;
        }
        if (RaidRegionHelper.getRegion(raidCrystal.getUuid()) != null && raidCrystal.isPlayerParticipating(player)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (raidCrystal.getRaidBoss().getKey().isEmpty() && !CobblemonRaidDens.TIER_CONFIG.get(blockState.getValue(RAID_TIER)).requiresKey()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.handleKey(player, raidCrystal, itemStack)) {
            return ItemInteractionResult.FAIL;
        }
        boolean success = this.startOrJoinRaid(player, blockState, raidCrystal, itemStack);
        if (success) {
            itemStack.consume(1, (LivingEntity)player);
        }
        return success ? ItemInteractionResult.CONSUME : ItemInteractionResult.FAIL;
    }

    private boolean startOrJoinRaid(Player player, BlockState blockState, RaidCrystalBlockEntity blockEntity, @Nullable ItemStack key) {
        if (player.getServer() == null) {
            return false;
        }
        if (!blockEntity.isActive(blockState) || blockEntity.isAtMaxClears()) {
            player.displayClientMessage(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.is_not_active"), true);
            return false;
        }
        if (RaidHelper.hasClearedRaid(blockEntity.getUuid(), player)) {
            player.displayClientMessage(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.player_cleared"), true);
            return false;
        }
        RaidRegion region = RaidRegionHelper.getRegion(blockEntity.getUuid());
        if (region != null && blockEntity.isPlayerParticipating(player)) {
            RaidDenNetworkMessages.JOIN_RAID.accept((ServerPlayer)player, true);
            RaidUtils.teleportPlayerToRaid((ServerPlayer)player, player.getServer(), region);
            blockEntity.syncAspects((ServerPlayer)player);
            return true;
        }
        if (RaidJoinHelper.isParticipatingOrInQueue(player, true)) {
            return false;
        }
        if (blockEntity.canSetRaidHost()) {
            boolean success = this.startRaid(player, blockEntity);
            if (!success) {
                blockEntity.clearRaidHost();
            }
            return success;
        }
        if (blockEntity.isFull()) {
            player.displayClientMessage(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.lobby_is_full"), true);
            return false;
        }
        return this.requestJoinRaid(player, blockEntity, key);
    }

    private boolean requestJoinRaid(Player player, RaidCrystalBlockEntity blockEntity, @Nullable ItemStack key) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return false;
        }
        ServerPlayer raidHost = server.getPlayerList().getPlayer(blockEntity.getRaidHost());
        if (raidHost == null) {
            player.displayClientMessage(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.no_host"), true);
            return false;
        }
        RaidJoinHelper.addToQueue(player, key);
        RaidHelper.addRequest(raidHost, player);
        RaidDenNetworkMessages.REQUEST_PACKET.accept(raidHost, player.getName().getString());
        return true;
    }

    private boolean startRaid(Player player, RaidCrystalBlockEntity blockEntity) {
        if (player.getServer() == null) {
            return false;
        }
        blockEntity.setRaidHost(player);
        boolean success = RaidEvents.RAID_JOIN.postWithResult(new RaidJoinEvent((ServerPlayer)player, true, blockEntity.getRaidBoss()));
        if (!success) {
            return false;
        }
        ResourceLocation structure = blockEntity.getRaidBoss().getRandomDen(player.level().getRandom());
        RaidRegion region = RaidRegionHelper.createRegion(blockEntity.getUuid(), structure);
        if (region == null || !blockEntity.spawnRaidBoss()) {
            blockEntity.closeRaid();
            player.displayClientMessage(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.boss_spawn_failed"), true);
            return false;
        }
        if (!RaidJoinHelper.addParticipant(player, blockEntity.getUuid(), true, true)) {
            return false;
        }
        RaidHelper.initRequest((ServerPlayer)player, blockEntity);
        RaidHelper.ACTIVE_RAIDS.get(blockEntity.getUuid()).addPlayer((ServerPlayer)player);
        RaidUtils.teleportPlayerToRaid((ServerPlayer)player, player.getServer(), region);
        blockEntity.syncAspects((ServerPlayer)player);
        return true;
    }

    private boolean handleKey(Player player, RaidCrystalBlockEntity blockEntity, ItemStack itemStack) {
        RaidBoss boss = blockEntity.getRaidBoss();
        UniqueKeyAdapter key = boss.getKey();
        if (!key.isEmpty()) {
            if (blockEntity.isOpen()) {
                return true;
            }
            if (!key.matches(itemStack)) {
                player.displayClientMessage(ComponentUtils.getSystemMessage(Component.translatable((String)"message.cobblemonraiddens.raid.no_unique_key", (Object[])new Object[]{key.item().split(":")[1]})), true);
                return false;
            }
            if (!CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).allRequireUniqueKey()) {
                blockEntity.setOpen();
            }
        } else if (CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).requiresKey() && !RaidUtils.isRaidDenKey(itemStack)) {
            player.displayClientMessage(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.no_key"), true);
            return false;
        }
        return true;
    }

    protected void onRemove(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState2, boolean bl) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(blockPos)) instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity blockEntity2 = (RaidCrystalBlockEntity)blockEntity;
            blockEntity2.closeRaid();
            RaidHelper.resetClearedRaids(blockEntity2.getUuid());
            RaidInstance raid = RaidHelper.ACTIVE_RAIDS.get(blockEntity2.getUuid());
            if (raid != null) {
                raid.closeRaid(level.getServer(), true);
            }
        }
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RAID_TYPE});
        builder.add(new Property[]{RAID_TIER});
        builder.add(new Property[]{ACTIVE});
        builder.add(new Property[]{CAN_RESET});
        builder.add(new Property[]{CYCLE_MODE});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return null;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected boolean isPathfindable(@NotNull BlockState blockState, @NotNull PathComputationType pathComputationType) {
        return false;
    }
}

