/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.advancements.RaidDenCriteriaTriggers;
import com.necro.raid.dens.common.data.raid.RaidTier;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class RaidTierTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, RaidTier tier) {
        this.trigger(serverPlayer, triggerInstance -> triggerInstance.matches(tier));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<RaidTier> tier) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)RaidTier.codec().optionalFieldOf("tier").forGetter(TriggerInstance::tier)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(RaidTier raidTier) {
            return this.tier.isPresent() && this.tier.get() == raidTier;
        }

        public static Criterion<TriggerInstance> tier(RaidTier tier) {
            return ((RaidTierTrigger)((Object)RaidDenCriteriaTriggers.RAID_TIER.value())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(tier)));
        }
    }
}

