/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle;

import alexthw.starbunclemania.common.data.DirectionData;
import alexthw.starbunclemania.common.item.DirectionScroll;
import alexthw.starbunclemania.common.item.FluidScroll;
import alexthw.starbunclemania.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;

public class StarHelper {
    public static Direction checkItemFramesForSide(BlockPos pos, Level level, Direction side) {
        for (ItemFrame i : level.getEntitiesOfClass(ItemFrame.class, new AABB(pos).inflate(1.0))) {
            ItemStack stackInFrame;
            BlockEntity adjTile = level.getBlockEntity(i.blockPosition().relative(i.getDirection().getOpposite()));
            BlockEntity be = level.getBlockEntity(pos);
            if (adjTile == null || !adjTile.equals(be) || i.getItem().isEmpty() || !((stackInFrame = i.getItem()).getItem() instanceof DirectionScroll) || stackInFrame.isComponentsPatchEmpty()) continue;
            side = ((DirectionData)stackInFrame.get(ModRegistry.DIRECTION)).direction();
            break;
        }
        return side;
    }

    public static boolean checkItemFramesForFluid(BlockPos pos, Level level, boolean scrollCheck, FluidStack fluid) {
        BlockEntity be = level.getBlockEntity(pos);
        for (ItemFrame i : level.getEntitiesOfClass(ItemFrame.class, new AABB(pos).inflate(1.0))) {
            ItemStack stackInFrame;
            Item item;
            BlockEntity adjTile = level.getBlockEntity(i.blockPosition().relative(i.getDirection().getOpposite()));
            if (adjTile == null || !adjTile.equals(be) || i.getItem().isEmpty() || !((item = (stackInFrame = i.getItem()).getItem()) instanceof FluidScroll)) continue;
            FluidScroll scroll = (FluidScroll)item;
            if (!stackInFrame.has(ModRegistry.FLUID_SCROLL)) continue;
            scrollCheck = scrollCheck || scroll.isDenied(stackInFrame, fluid);
            break;
        }
        return scrollCheck;
    }
}

