/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.wixie_stations;

import alexthw.starbunclemania.common.DualFluidTank;
import alexthw.starbunclemania.mixin.WixieCauldronTileAccessor;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.wixie.WaterMilkRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MixerWixieCauldronTile
extends WixieCauldronTile {
    public DualFluidTank tank = new DualFluidTank(10000, 10000, fs -> fs.getFluid() == Fluids.WATER, fs -> fs.getFluid() == NeoForgeMod.MILK.get()){

        @Override
        public void contentsChangedCallback() {
            MixerWixieCauldronTile.this.setChanged();
            MixerWixieCauldronTile.this.updateBlock();
        }
    };
    boolean hasMilk;
    boolean hasWater;
    static FluidStack milkTester = new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000);
    static FluidStack waterTester = new FluidStack((Fluid)Fluids.WATER, 1000);

    public MixerWixieCauldronTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.MIXER_WIXIE_CAULDRON_TILE.get();
    }

    public MultiRecipeWrapper getRecipesForStack(ItemStack stack) {
        this.hasMilk = this.tank.drain(milkTester, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 1000;
        this.hasWater = this.tank.drain(waterTester, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 1000;
        return WaterMilkRecipeWrapper.fromStack(stack, this.level, this.hasMilk, this.hasWater);
    }

    public void onCraftingComplete() {
        super.onCraftingComplete();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        ItemStack stack = ((WixieCauldronTileAccessor)((Object)this)).getStackBeingCrafted();
        MultiRecipeWrapper multiRecipeWrapper = this.getRecipesForStack(stack);
        if (multiRecipeWrapper instanceof WaterMilkRecipeWrapper) {
            WaterMilkRecipeWrapper wrapper = (WaterMilkRecipeWrapper)multiRecipeWrapper;
            if (wrapper.needWater) {
                this.tank.drain(waterTester, IFluidHandler.FluidAction.EXECUTE);
            }
            if (wrapper.needMilk) {
                this.tank.drain(milkTester, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (!this.tank.isEmpty()) {
            this.tank.writeToNBT(pRegistries, tag);
        }
    }

    public void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.tank.readFromNBT(pRegistries, pTag);
    }

    public boolean bucketInteract(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank);
    }
}

