/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.core.network;

import dev.satherov.crystalix.Crystalix;
import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.common.block.CrystalixGlassTile;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSBooleanProperty;
import dev.satherov.crystalix.common.properties.CSEnumProperty;
import dev.satherov.crystalix.common.properties.CSIntegerProperty;
import dev.satherov.crystalix.common.properties.CSProperties;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SwapPropertiesPayload(BlockPos pos) implements CustomPacketPayload
{
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwapPropertiesPayload.class);
    public static final StreamCodec<RegistryFriendlyByteBuf, SwapPropertiesPayload> STREAM_CODEC = CustomPacketPayload.codec(SwapPropertiesPayload::encode, SwapPropertiesPayload::new);
    public static final CustomPacketPayload.Type<SwapPropertiesPayload> TYPE = new CustomPacketPayload.Type(Crystalix.rl("swap_properties"));

    private SwapPropertiesPayload(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    public static void handle(SwapPropertiesPayload message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp;
            if (ctx.flow().isServerbound() && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ServerLevel level = player.serverLevel();
                ItemStack wand = CrystalixWand.find((Player)player);
                if (wand.isEmpty()) {
                    return;
                }
                BlockPos pos = message.pos();
                BlockState state = level.getBlockState(pos);
                if (!(state.getBlock() instanceof CrystalixGlass)) {
                    return;
                }
                BlockEntity entity = level.getBlockEntity(pos);
                CSProperties properties = CSProperties.of(wand);
                ((CSBooleanProperty)properties.properties().get(CSProperties.WATERLOGGABLE)).set((Boolean)state.getValue((Property)CrystalixGlass.WATERLOGGABLE));
                ((CSBooleanProperty)properties.properties().get(CSProperties.SHADELESS)).set((Boolean)state.getValue((Property)CrystalixGlass.SHADELESS));
                ((CSBooleanProperty)properties.properties().get(CSProperties.INVISIBLE)).set((Boolean)state.getValue((Property)CrystalixGlass.INVISIBLE));
                ((CSBooleanProperty)properties.properties().get(CSProperties.CLEAR)).set((Boolean)state.getValue((Property)CrystalixGlass.TRANSPARENT));
                ((CSBooleanProperty)properties.properties().get(CSProperties.REDSTONE)).set((Boolean)state.getValue((Property)CrystalixGlass.REDSTONE));
                ((CSEnumProperty)properties.properties().get(CSProperties.LIGHT)).set((CSProperties.Light)((Object)state.getValue(CrystalixGlass.LIGHT)));
                ((CSEnumProperty)properties.properties().get(CSProperties.GHOST)).set((CSProperties.Ghost)((Object)state.getValue(CrystalixGlass.GHOST)));
                if (entity instanceof CrystalixGlassTile) {
                    CrystalixGlassTile tile = (CrystalixGlassTile)entity;
                    ((CSBooleanProperty)properties.properties().get(CSProperties.CONDUCTOR)).set(tile.isConductor());
                    ((CSBooleanProperty)properties.properties().get(CSProperties.REINFORCED)).set(tile.isReinforced());
                    ((CSIntegerProperty)properties.properties().get(CSProperties.COLOR)).set(tile.getColor());
                }
                player.getInventory().setChanged();
            }
        }).exceptionally(e -> {
            log.error("Failed to pick wand properties from BlockState", e);
            return null;
        });
    }
}

