/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;

public class BlockStateStatsCommand
implements Command<CommandSourceStack> {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"blockstate_stats").requires(cs -> cs.hasPermission(4))).executes((Command)new BlockStateStatsCommand());
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DefaultedRegistry registry = BuiltInRegistries.BLOCK;
        HashMap<String, Integer> modBlockCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> modBlockStateCounts = new HashMap<String, Integer>();
        ArrayList<Block> blocksList = new ArrayList<Block>();
        int totalBlocks = 0;
        int totalBlockStates = 0;
        for (Block block2 : registry) {
            ++totalBlocks;
            blocksList.add(block2);
            String modId = block2.builtInRegistryHolder().key().location().getNamespace();
            modBlockCounts.put(modId, modBlockCounts.getOrDefault(modId, 0) + 1);
            int blockStateCount = block2.getStateDefinition().getPossibleStates().size();
            totalBlockStates += blockStateCount;
            modBlockStateCounts.put(modId, modBlockStateCounts.getOrDefault(modId, 0) + blockStateCount);
        }
        double averageBlockStates = (double)totalBlockStates / (double)totalBlocks;
        Path outputPath = PlatHelper.getGamePath().resolve("blockstate_stats.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
            writer.write("=== Minecraft Blockstate Statistics ===\n");
            writer.write(String.format("Total blocks: %d%n", totalBlocks));
            writer.write(String.format("Total blockstates: %d%n", totalBlockStates));
            writer.write(String.format("Average blockstates per block: %.2f%n%n", averageBlockStates));
            writer.write("--- Blocks per Mod ---\n");
            modBlockCounts.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).forEach(entry -> {
                try {
                    String mod = (String)entry.getKey();
                    writer.write(String.format("%s: %d blocks, %d blockstates%n", mod, modBlockCounts.get(mod), modBlockStateCounts.get(mod)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            writer.write("\n");
            writer.write("--- Blocks with More Than Average Blockstates ---\n");
            blocksList.stream().map(block -> new AbstractMap.SimpleEntry<Block, Integer>((Block)block, block.getStateDefinition().getPossibleStates().size())).filter(entry -> (double)((Integer)entry.getValue()).intValue() > averageBlockStates).sorted((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue())).forEach(entry -> {
                try {
                    String blockId = BuiltInRegistries.BLOCK.getKey((Object)((Block)entry.getKey())).toString();
                    int stateCount = (Integer)entry.getValue();
                    writer.write(String.format("%s: %d blockstates%n", blockId, stateCount));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String totalBlockStateString = "" + totalBlockStates;
        String totalBlocksString = "" + totalBlocks;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
            MutableComponent clickablePath = Component.literal((String)(" [" + outputPath.toString() + "]")).withStyle(style -> style.withColor(ChatFormatting.AQUA));
            if (PlatHelper.isIntegratedServer()) {
                clickablePath.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, outputPath.toString())));
            }
            MutableComponent message = Component.translatable((String)"commands.moonlight.blockstate_stats", (Object[])new Object[]{totalBlocksString, totalBlockStateString, clickablePath});
            return message.append((Component)clickablePath);
        }, false);
        return 0;
    }
}

