/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.assets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

public class LangBuilder {
    private final Map<String, String> entries = new LinkedHashMap<String, String>();

    public void addGenericEntry(String key, String translation) {
        this.entries.put(key, translation);
    }

    public void addEntry(Block block, String translation) {
        this.entries.put(block.getDescriptionId(), translation);
    }

    public <T> void addEntry(Registry<T> reg, T entry, String translation) {
        this.entries.put(Util.makeDescriptionId((String)reg.key().location().getPath(), (ResourceLocation)reg.getKey(entry)), translation);
    }

    public <T> void addSimpleEntry(Registry<T> reg, T entry) {
        this.entries.put(Util.makeDescriptionId((String)reg.key().location().getPath(), (ResourceLocation)reg.getKey(entry)), LangBuilder.getReadableName(reg.getKey(entry).getPath()));
    }

    public void addEntry(Item item, String translation) {
        this.entries.put(item.getDescriptionId(), translation);
    }

    public void addEntry(EntityType<?> entityType, String translation) {
        this.entries.put(entityType.getDescriptionId(), translation);
    }

    public JsonElement build() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, String> e : this.entries.entrySet()) {
            json.addProperty(e.getKey(), e.getValue());
        }
        return json;
    }

    public Map<String, String> entries() {
        return this.entries;
    }

    public static String getReadableName(String name) {
        return Arrays.stream(name.replace(":", "_").split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static Component getReadableComponent(String key, String ... arguments) {
        MutableComponent translated = Component.translatable((String)key, (Object[])arguments);
        if (translated.getString().equals(key)) {
            StringBuilder aa = new StringBuilder();
            for (String s : arguments) {
                aa.append("_").append(s);
            }
            return Component.literal((String)LangBuilder.getReadableName(key + String.valueOf(aa)));
        }
        return translated;
    }

    public static void addDynamicEntry(AfterLanguageLoadEvent lang, String key, BlockType type, Item item) {
        String base = lang.getEntry(key);
        if (base != null) {
            String typeName = lang.getEntry(type.getTranslationKey());
            if (typeName != null) {
                lang.addEntry(item.getDescriptionId(), String.format(base, typeName));
            } else {
                Moonlight.LOGGER.error("Could not find translation line {}", (Object)type.getTranslationKey());
            }
        } else {
            Moonlight.LOGGER.error("Could not find translation line {}", (Object)key);
        }
    }

    public static void addDynamicEntry(AfterLanguageLoadEvent lang, String key, BlockType type, Block block) {
        String typeName;
        String base = lang.getEntry(key);
        if (base != null && (typeName = lang.getEntry(type.getTranslationKey())) != null) {
            lang.addEntry(block.getDescriptionId(), String.format(base, typeName));
        }
    }

    public static void addDynamicEntry(AfterLanguageLoadEvent lang, String key, BlockType type, EntityType<?> entityType) {
        String typeName;
        String base = lang.getEntry(key);
        if (base != null && (typeName = lang.getEntry(type.getTranslationKey())) != null) {
            lang.addEntry(entityType.getDescriptionId(), String.format(base, typeName));
        }
    }
}

