/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.StorageInMotionTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;

public class StorageMinecart
extends MinecartChest
implements IMovingStorageEntity {
    static final EntityDataAccessor<ItemStack> DATA_STORAGE_ITEM = SynchedEntityData.defineId(StorageMinecart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final EntityStorageHolder<StorageMinecart> entityStorageHolder = new EntityStorageHolder<StorageMinecart>(this);

    public StorageMinecart(EntityType<StorageMinecart> entityType, Level level) {
        super(entityType, level);
    }

    public StorageMinecart(Level level) {
        this(ModEntities.STORAGE_MINECART.get(), level);
    }

    public StorageMinecart(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STORAGE_ITEM, (Object)ItemStack.EMPTY);
    }

    @Override
    public ItemStack getStorageItem() {
        return (ItemStack)this.entityData.get(DATA_STORAGE_ITEM);
    }

    @Override
    public void setStorageItem(ItemStack storageItem) {
        this.entityData.set(DATA_STORAGE_ITEM, (Object)storageItem.copy());
    }

    @Override
    public EntityStorageHolder<?> getStorageHolder() {
        return this.entityStorageHolder;
    }

    public boolean hurt(DamageSource source, float amount) {
        return this.getStorageHolder().hurt(source, amount, (x$0, x$1) -> super.hurt(x$0, x$1));
    }

    public void destroy(DamageSource source) {
        this.kill();
        this.getStorageHolder().onDestroy();
    }

    @Override
    public ItemStack getDropStack(ItemStack storageItem) {
        ItemStack drop = new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get());
        drop.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItem));
        return drop;
    }

    public ItemStack getPickResult() {
        ItemStack result = new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get());
        ItemStack storageItemCopy = this.getStorageItem().copy();
        storageItemCopy.remove(ModCoreDataComponents.STORAGE_UUID);
        result.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItemCopy));
        return result;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("storageHolder", (Tag)this.entityStorageHolder.saveData((HolderLookup.Provider)this.level().registryAccess()));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityStorageHolder.readData((HolderLookup.Provider)this.level().registryAccess(), tag.getCompound("storageHolder"));
    }

    public void tick() {
        super.tick();
        this.entityStorageHolder.tick((Entity)this);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == DATA_STORAGE_ITEM && this.level().isClientSide()) {
            this.entityStorageHolder.onStorageItemSynced();
        }
    }

    protected Component getTypeName() {
        return Component.translatable((String)StorageInMotionTranslationHelper.INSTANCE.translEntity("storage_minecart"), (Object[])new Object[]{this.getStorageItem().getHoverName()});
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.getStorageHolder().openContainerMenu((Player)serverPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return this.getStorageHolder().createMenu(id, playerInventory.player);
    }

    public void remove(Entity.RemovalReason pReason) {
        this.setRemoved(pReason);
    }

    public int getContainerSize() {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().getSlots();
    }

    public NonNullList<ItemStack> getItemStacks() {
        return NonNullList.create();
    }

    public void addChestVehicleSaveData(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        if (this.getLootTable() != null) {
            tag.putString("LootTable", this.getLootTable().location().toString());
            if (this.getLootTableSeed() != 0L) {
                tag.putLong("LootTableSeed", this.getLootTableSeed());
            }
        }
    }

    public void readChestVehicleSaveData(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        this.clearItemStacks();
        if (tag.contains("LootTable", 8)) {
            this.setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("LootTable"))));
            this.setLootTableSeed(tag.getLong("LootTableSeed"));
        }
    }

    public void chestVehicleDestroyed(DamageSource damageSource, Level level, Entity p_entity) {
    }

    public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        InventoryHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryHandler();
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            inventoryHandler.setStackInSlot(slot, ItemStack.EMPTY);
        }
    }

    public ItemStack removeChestVehicleItemNoUpdate(int slot) {
        ITrackedContentsItemHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput();
        return inventoryHandler.extractItem(slot, inventoryHandler.getStackInSlot(slot).getCount(), false);
    }

    public ItemStack getChestVehicleItem(int slot) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().getStackInSlot(slot);
    }

    public ItemStack removeChestVehicleItem(int slot, int amount) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().extractItem(slot, amount, false);
    }

    public void setChestVehicleItem(int slot, ItemStack stack) {
        this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().setStackInSlot(slot, stack);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().isItemValid(slot, stack);
    }

    public SlotAccess getChestVehicleSlot(int index) {
        return SlotAccess.NULL;
    }
}

