/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.VirtualFrame;
import com.cobblemon.mod.relocations.oracle.truffle.api.instrumentation.Tag;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ArrayLiteralNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GetTemplateObjectNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Boundaries;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSAttributes;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObjectUtil;
import java.util.Set;

public abstract class GetTemplateObjectNode
extends JavaScriptNode {
    protected final JSContext context;
    @Node.Child
    private ArrayLiteralNode rawStrings;
    @Node.Child
    private ArrayLiteralNode cookedStrings;
    private final Object identity;

    protected GetTemplateObjectNode(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings) {
        this.context = context;
        this.rawStrings = rawStrings;
        this.cookedStrings = cookedStrings;
        this.identity = this;
    }

    protected GetTemplateObjectNode(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings, Object identity) {
        this.context = context;
        this.rawStrings = rawStrings;
        this.cookedStrings = cookedStrings;
        this.identity = identity;
    }

    public static GetTemplateObjectNode create(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings) {
        return GetTemplateObjectNodeGen.create(context, rawStrings, cookedStrings);
    }

    @Specialization(guards={"!context.isMultiContext()"}, assumptions={"context.getSingleRealmAssumption()"})
    protected JSDynamicObject doCached(VirtualFrame frame, @Cached(value="doUncached(frame)") JSDynamicObject cachedTemplate) {
        return cachedTemplate;
    }

    @Specialization(replaces={"doCached"})
    protected JSDynamicObject doUncached(VirtualFrame frame) {
        JSDynamicObject cached = Boundaries.mapGet(this.getRealm().getTemplateRegistry(), this.identity);
        if (cached != null) {
            return cached;
        }
        cached = this.buildTemplateObject(frame);
        Boundaries.mapPut(this.getRealm().getTemplateRegistry(), this.identity, cached);
        return cached;
    }

    private JSDynamicObject buildTemplateObject(VirtualFrame frame) {
        JSArrayObject template = this.cookedStrings.execute(frame);
        JSArrayObject rawObj = this.rawStrings.execute(frame);
        JSObject.setIntegrityLevel(rawObj, true);
        JSObjectUtil.putDataProperty(this.context, template, Strings.RAW, rawObj, JSAttributes.notConfigurableNotEnumerableNotWritable());
        JSObject.setIntegrityLevel(template, true);
        return template;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GetTemplateObjectNodeGen.create(this.context, GetTemplateObjectNode.cloneUninitialized(this.rawStrings, materializedTags), GetTemplateObjectNode.cloneUninitialized(this.cookedStrings, materializedTags), this.identity);
    }
}

