/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerAsserts;
import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.cobblemon.mod.relocations.oracle.truffle.api.instrumentation.StandardTags;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.NodeUtil;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.RootNode;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.SlowPathException;
import com.cobblemon.mod.relocations.oracle.truffle.api.source.SourceSection;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSTargetableWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.VarWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.GeneratorWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.instrumentation.JSInputGeneratingNodeWrapper;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.DebugCounter;

public final class JSNodeUtil {
    static final DebugCounter NODE_CREATE_COUNT = DebugCounter.create("NodeCreateCount");
    static final DebugCounter NODE_REPLACE_COUNT = DebugCounter.create("NodeReplaceCount");
    private static final SlowPathException SLOW_PATH_EXCEPTION = new SlowPathException();

    private JSNodeUtil() {
    }

    public static SlowPathException slowPathException() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLOW_PATH_EXCEPTION;
    }

    static String formatTags(JavaScriptNode node) {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder sb = new StringBuilder(4);
        if (node.hasTag(StandardTags.StatementTag.class)) {
            sb.append('S');
        }
        if (node.hasTag(StandardTags.CallTag.class)) {
            sb.append('C');
        }
        if (node.hasTag(StandardTags.RootTag.class)) {
            sb.append('R');
        }
        if (node.hasTag(StandardTags.RootBodyTag.class)) {
            sb.append('B');
        }
        if (node.hasTag(StandardTags.ExpressionTag.class)) {
            sb.append('E');
        }
        return sb.toString();
    }

    public static boolean hasImportantTag(JavaScriptNode node) {
        return node.hasImportantTag();
    }

    public static String resolveName(RootNode root) {
        if (root instanceof FunctionRootNode) {
            return ((FunctionRootNode)root).getName();
        }
        return "unknown";
    }

    public static String formatSourceSection(Node node) {
        CompilerAsserts.neverPartOfCompilation();
        if (node == null) {
            return "<unknown>";
        }
        SourceSection section = node.getSourceSection();
        boolean estimated = false;
        if (section == null) {
            section = node.getEncapsulatingSourceSection();
            estimated = true;
        }
        if (section == null || !section.isAvailable()) {
            return "<unknown source>";
        }
        String sourceName = section.getSource().getName();
        int startLine = section.getStartLine();
        return String.format("%s:%d%s", sourceName, startLine, estimated ? "~" : "");
    }

    public static boolean hasExactlyOneRootBodyTag(JavaScriptNode body) {
        CompilerAsserts.neverPartOfCompilation();
        return NodeUtil.countNodes(body, node -> !(node instanceof GeneratorWrapperNode) && node instanceof JavaScriptNode && ((JavaScriptNode)node).hasTag(StandardTags.RootBodyTag.class)) == 1;
    }

    public static boolean isWrapperNode(JavaScriptNode node) {
        return node instanceof InstrumentableNode.WrapperNode || node instanceof VarWrapperNode || node instanceof JSInputGeneratingNodeWrapper || node instanceof JSTaggedExecutionNode || node instanceof JSTargetableWrapperNode;
    }

    public static JavaScriptNode getWrappedNode(JavaScriptNode node) {
        InstrumentableNode.WrapperNode wrapper;
        JavaScriptNode unwrapped = node;
        if (node instanceof InstrumentableNode.WrapperNode) {
            wrapper = (InstrumentableNode.WrapperNode)((Object)node);
            unwrapped = (JavaScriptNode)wrapper.getDelegateNode();
        }
        if (unwrapped instanceof JSInputGeneratingNodeWrapper) {
            unwrapped = ((JSInputGeneratingNodeWrapper)unwrapped).getDelegateNode();
        }
        if (unwrapped instanceof JSTaggedExecutionNode) {
            unwrapped = ((JSTaggedExecutionNode)unwrapped).getDelegateNode();
        }
        if (unwrapped instanceof VarWrapperNode) {
            unwrapped = ((VarWrapperNode)unwrapped).getDelegateNode();
        }
        if (unwrapped instanceof JSTargetableWrapperNode) {
            unwrapped = ((JSTargetableWrapperNode)unwrapped).getDelegate();
        }
        if (unwrapped instanceof InstrumentableNode.WrapperNode) {
            wrapper = (InstrumentableNode.WrapperNode)((Object)unwrapped);
            unwrapped = (JavaScriptNode)wrapper.getDelegateNode();
        }
        assert (!JSNodeUtil.isWrapperNode(unwrapped));
        return unwrapped;
    }

    public static boolean isTaggedNode(Node node) {
        return node instanceof JSTaggedExecutionNode || node instanceof InstrumentableNode.WrapperNode && ((InstrumentableNode.WrapperNode)((Object)node)).getDelegateNode() instanceof JSTaggedExecutionNode;
    }

    public static boolean isInputGeneratingNode(Node node) {
        return node instanceof JSInputGeneratingNodeWrapper || node instanceof InstrumentableNode.WrapperNode && ((InstrumentableNode.WrapperNode)((Object)node)).getDelegateNode() instanceof JSInputGeneratingNodeWrapper;
    }
}

