/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.builtins.intl;

import com.cobblemon.mod.relocations.ibm.icu.text.BreakIterator;
import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.VirtualFrame;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.cobblemon.mod.relocations.oracle.truffle.js.builtins.intl.SegmentIteratorPrototypeBuiltinsFactory;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSBuiltin;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.intl.CreateSegmentDataObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.intl.JSSegmentIteratorObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.intl.JSSegmenter;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.Undefined;

public final class SegmentIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SegmentIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SegmentIteratorPrototypeBuiltins();

    protected SegmentIteratorPrototypeBuiltins() {
        super(JSSegmenter.ITERATOR_PROTOTYPE_NAME, SegmentIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SegmentIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return SegmentIteratorPrototypeBuiltinsFactory.SegmentIteratorNextNodeGen.create(context, builtin, SegmentIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class SegmentIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        protected CreateIterResultObjectNode createIterResultObjectNode;

        public SegmentIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        }

        @Specialization
        protected JSDynamicObject doSegmentIterator(VirtualFrame frame, JSSegmentIteratorObject iteratorObj, @Cached(value="create(getContext())") CreateSegmentDataObjectNode createNextValueNode) {
            JSSegmenter.IteratorState iterator = iteratorObj.getIteratorState();
            TruffleString iteratedString = iterator.getIteratedString();
            BreakIterator icuIterator = iterator.getBreakIterator();
            JSSegmenter.Granularity segmenterGranularity = iterator.getSegmenterGranularity();
            int startIndex = SegmentIteratorNextNode.findBoundaryCurrent(icuIterator);
            int endIndex = SegmentIteratorNextNode.findBoundaryNext(icuIterator);
            boolean done = endIndex == -1;
            JSDynamicObject nextValue = done ? Undefined.instance : createNextValueNode.execute(icuIterator, segmenterGranularity, iteratedString, startIndex, endIndex);
            return this.createIterResultObjectNode.execute(frame, nextValue, done);
        }

        @Specialization(guards={"!isJSSegmentIterator(iterator)"})
        protected JSDynamicObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeErrorTypeXExpected(JSSegmenter.ITERATOR_CLASS_NAME);
        }

        @CompilerDirectives.TruffleBoundary
        private static int findBoundaryCurrent(BreakIterator breakIterator) {
            return breakIterator.current();
        }

        @CompilerDirectives.TruffleBoundary
        private static int findBoundaryNext(BreakIterator breakIterator) {
            return breakIterator.next();
        }
    }

    public static enum SegmentIteratorPrototype implements BuiltinEnum<SegmentIteratorPrototype>
    {
        next(0);

        private final int length;

        private SegmentIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

