/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.graalvm.polyglot.proxy;

import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.cobblemon.mod.relocations.graalvm.polyglot.proxy.DefaultProxyArrayIterator;
import com.cobblemon.mod.relocations.graalvm.polyglot.proxy.ProxyIterable;
import com.cobblemon.mod.relocations.graalvm.polyglot.proxy.ProxyIterator;
import java.util.List;

public interface ProxyArray
extends ProxyIterable {
    public Object get(long var1);

    public void set(long var1, Value var3);

    default public boolean remove(long index) {
        throw new UnsupportedOperationException("remove() not supported.");
    }

    public long getSize();

    @Override
    default public Object getIterator() {
        return new DefaultProxyArrayIterator(this);
    }

    public static ProxyArray fromArray(final Object ... values) {
        return new ProxyArray(){

            @Override
            public Object get(long index) {
                this.checkIndex(index);
                return values[(int)index];
            }

            @Override
            public void set(long index, Value value) {
                this.checkIndex(index);
                values[(int)index] = value.isHostObject() ? value.asHostObject() : value;
            }

            private void checkIndex(long index) {
                if (index > Integer.MAX_VALUE || index < 0L) {
                    throw new ArrayIndexOutOfBoundsException("invalid index.");
                }
            }

            @Override
            public long getSize() {
                return values.length;
            }
        };
    }

    public static ProxyArray fromList(final List<Object> values) {
        return new ProxyArray(){

            @Override
            public Object get(long index) {
                this.checkIndex(index);
                return values.get((int)index);
            }

            @Override
            public void set(long index, Value value) {
                this.checkIndex(index);
                values.set((int)index, value.isHostObject() ? value.asHostObject() : value);
            }

            @Override
            public boolean remove(long index) {
                this.checkIndex(index);
                values.remove((int)index);
                return true;
            }

            private void checkIndex(long index) {
                if (index > Integer.MAX_VALUE || index < 0L) {
                    throw new ArrayIndexOutOfBoundsException("invalid index.");
                }
            }

            @Override
            public long getSize() {
                return values.size();
            }

            @Override
            public Object getIterator() {
                return ProxyIterator.from(values.iterator());
            }
        };
    }
}

