/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.world.feature;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.tags.CobblemonBiomeTags;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J?\u0010$\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%JE\u0010&\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b&\u0010'J5\u0010(\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002\u00a2\u0006\u0004\b(\u0010)J'\u0010,\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/world/feature/SaccharineTreeFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/BlockStateConfiguration;", "<init>", "()V", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "context", "", "place", "(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z", "Lnet/minecraft/world/level/WorldGenLevel;", "worldGenLevel", "", "Lnet/minecraft/core/BlockPos;", "locationsToCheck", "filterBeeNestPositions", "(Lnet/minecraft/world/level/WorldGenLevel;Ljava/util/List;)Ljava/util/List;", "origin", "isFlowerNearby", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;)Z", "", "potentialBeeNestPositions", "", "placeBeeNest", "(Lnet/minecraft/world/level/WorldGenLevel;Ljava/util/List;)V", "pos", "populateBeeNest", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "logBlock", "leafBlock", "placeBigLeafPattern", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V", "specialBlock", "Lnet/minecraft/util/RandomSource;", "random", "placeSmallLeafPattern", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/util/RandomSource;)V", "placeLeafStartPattern", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;Ljava/util/List;Lnet/minecraft/util/RandomSource;)V", "placeTopTrunkPattern", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Ljava/util/List;)V", "blockPos", "blockState", "setBlockIfClear", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "common"})
public final class SaccharineTreeFeature
extends Feature<BlockStateConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String POKEMON_ARGS = "combee";
    @NotNull
    private static final IntRange LEVEL_RANGE = new IntRange(5, 15);

    public SaccharineTreeFeature() {
        super(BlockStateConfiguration.CODEC);
    }

    public boolean place(@NotNull FeaturePlaceContext<BlockStateConfiguration> context) {
        boolean isGenerating;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        WorldGenLevel worldGenLevel = context.level();
        Intrinsics.checkNotNullExpressionValue((Object)worldGenLevel, (String)"level(...)");
        WorldGenLevel worldGenLevel2 = worldGenLevel;
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        boolean bl = isGenerating = !Intrinsics.areEqual((Object)worldGenLevel2.getChunk(origin).getPersistedStatus(), (Object)ChunkStatus.FULL);
        if (isGenerating) {
            float f;
            Holder biome = worldGenLevel2.getBiome(origin);
            if (!biome.is(CobblemonBiomeTags.ALLOWED_BIOMES_SACCHARINE_TREE)) {
                return false;
            }
            if (biome.is(CobblemonBiomeTags.HAS_APRICORNS_SPARSE)) {
                f = 0.1f;
            } else if (biome.is(CobblemonBiomeTags.HAS_APRICORNS_DENSE)) {
                f = 10.0f;
            } else if (biome.is(CobblemonBiomeTags.HAS_APRICORNS_NORMAL)) {
                f = 1.0f;
            } else {
                return false;
            }
            float multiplier = f;
            if (random.nextFloat() > multiplier * Cobblemon.INSTANCE.getConfig().getBaseApricornTreeGenerationChance()) {
                return false;
            }
        }
        if (!worldGenLevel2.getBlockState(origin.below()).is(BlockTags.DIRT)) {
            return false;
        }
        int trunkHeight = random.nextBoolean() ? 1 : 2;
        int actualHeight = trunkHeight + 5;
        for (int y = 0; y < actualHeight; ++y) {
            BlockPos pos = origin.relative(Direction.UP, y);
            if (TreeFeature.isAirOrLeaves((LevelSimulatedReader)((LevelSimulatedReader)worldGenLevel2), (BlockPos)pos)) continue;
            return false;
        }
        List potentialBeeNestPositions = new ArrayList();
        BlockState logState = CobblemonBlocks.SACCHARINE_LOG.defaultBlockState();
        for (int y = 0; y < trunkHeight; ++y) {
            BlockPos logPos = origin.relative(Direction.UP, y);
            worldGenLevel2.setBlock(logPos, logState, 2);
        }
        int currentHeight = trunkHeight;
        BlockPos blockPos = origin.relative(Direction.UP, currentHeight);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        Intrinsics.checkNotNull((Object)logState);
        this.placeTopTrunkPattern(worldGenLevel2, blockPos, logState, potentialBeeNestPositions);
        BlockPos blockPos2 = origin.relative(Direction.UP, ++currentHeight);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"relative(...)");
        BlockState blockState = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        Intrinsics.checkNotNull((Object)random);
        this.placeLeafStartPattern(worldGenLevel2, blockPos2, logState, blockState, potentialBeeNestPositions, random);
        BlockPos blockPos3 = origin.relative(Direction.UP, ++currentHeight);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"relative(...)");
        BlockState blockState2 = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        this.placeBigLeafPattern(worldGenLevel2, blockPos3, logState, blockState2);
        BlockPos blockPos4 = origin.relative(Direction.UP, ++currentHeight);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"relative(...)");
        BlockState blockState3 = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"defaultBlockState(...)");
        BlockState blockState4 = Blocks.AIR.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState4, (String)"defaultBlockState(...)");
        this.placeSmallLeafPattern(worldGenLevel2, blockPos4, logState, blockState3, blockState4, random);
        BlockPos blockPos5 = origin.relative(Direction.UP, ++currentHeight);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"relative(...)");
        BlockState blockState5 = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState5, (String)"defaultBlockState(...)");
        this.placeBigLeafPattern(worldGenLevel2, blockPos5, logState, blockState5);
        ++currentHeight;
        if (random.nextBoolean()) {
            BlockPos blockPos6 = origin.relative(Direction.UP, currentHeight);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos6, (String)"relative(...)");
            Object object = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            BlockState blockState6 = (BlockState)object;
            BlockState blockState7 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState7, (String)"defaultBlockState(...)");
            BlockState blockState8 = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState8, (String)"defaultBlockState(...)");
            this.placeSmallLeafPattern(worldGenLevel2, blockPos6, blockState6, blockState7, blockState8, random);
        } else {
            BlockPos blockPos7 = origin.relative(Direction.UP, currentHeight);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos7, (String)"relative(...)");
            BlockState blockState9 = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState9, (String)"defaultBlockState(...)");
            BlockState blockState10 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState10, (String)"defaultBlockState(...)");
            this.placeSmallLeafPattern(worldGenLevel2, blockPos7, logState, blockState9, blockState10, random);
            BlockPos blockPos8 = origin.relative(Direction.UP, ++currentHeight);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos8, (String)"relative(...)");
            BlockState blockState11 = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState11, (String)"defaultBlockState(...)");
            this.placeBigLeafPattern(worldGenLevel2, blockPos8, logState, blockState11);
            BlockPos blockPos9 = origin.relative(Direction.UP, ++currentHeight);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos9, (String)"relative(...)");
            Object object = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            BlockState blockState12 = (BlockState)object;
            BlockState blockState13 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState13, (String)"defaultBlockState(...)");
            BlockState blockState14 = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState14, (String)"defaultBlockState(...)");
            this.placeSmallLeafPattern(worldGenLevel2, blockPos9, blockState12, blockState13, blockState14, random);
        }
        if (isGenerating) {
            if (worldGenLevel2.getRandom().nextInt(2) == 0) {
                this.placeBeeNest(worldGenLevel2, potentialBeeNestPositions);
            }
        } else {
            Intrinsics.checkNotNull((Object)origin);
            if (this.isFlowerNearby(worldGenLevel2, origin) && worldGenLevel2.getRandom().nextInt(10) == 0) {
                this.placeBeeNest(worldGenLevel2, potentialBeeNestPositions);
            }
        }
        return true;
    }

    private final List<BlockPos> filterBeeNestPositions(WorldGenLevel worldGenLevel, List<? extends BlockPos> locationsToCheck) {
        List viableBeeNestPositions = new ArrayList();
        for (BlockPos blockPos : locationsToCheck) {
            BlockPos southBlock;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos.offset(0, 0, 1), (String)"offset(...)");
            if (!worldGenLevel.isEmptyBlock(southBlock)) continue;
            viableBeeNestPositions.add(blockPos);
        }
        return viableBeeNestPositions;
    }

    private final boolean isFlowerNearby(WorldGenLevel worldGenLevel, BlockPos origin) {
        for (int dx = -2; dx < 3; ++dx) {
            for (int dy = -2; dy < 3; ++dy) {
                for (int dz = -2; dz < 3; ++dz) {
                    BlockPos pos = origin.offset(dx, dy, dz);
                    if (!worldGenLevel.getBlockState(pos).is(BlockTags.FLOWERS)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final void placeBeeNest(WorldGenLevel worldGenLevel, List<BlockPos> potentialBeeNestPositions) {
        List<BlockPos> viableBeeNestPositions = this.filterBeeNestPositions(worldGenLevel, potentialBeeNestPositions);
        BlockPos nestPos = (BlockPos)CollectionsKt.randomOrNull((Collection)viableBeeNestPositions, (Random)((Random)Random.Default));
        if (nestPos != null && worldGenLevel.isEmptyBlock(nestPos)) {
            BlockState southFacingBeeNest = (BlockState)Blocks.BEE_NEST.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH);
            Intrinsics.checkNotNull((Object)southFacingBeeNest);
            this.setBlockIfClear(worldGenLevel, nestPos, southFacingBeeNest);
            this.populateBeeNest(worldGenLevel, nestPos);
        }
    }

    private final void populateBeeNest(WorldGenLevel worldGenLevel, BlockPos pos) {
        worldGenLevel.getBlockEntity(pos, BlockEntityType.BEEHIVE).ifPresent(arg_0 -> SaccharineTreeFeature.populateBeeNest$lambda$0(worldGenLevel, arg_0));
    }

    private final void placeBigLeafPattern(WorldGenLevel worldGenLevel, BlockPos origin, BlockState logBlock, BlockState leafBlock) {
        BlockPos[] blockPosArray = new BlockPos[]{origin.offset(-2, 0, 0), origin.offset(2, 0, 0), origin.offset(0, 0, -2), origin.offset(0, 0, 2), origin.offset(-1, 0, -2), origin.offset(1, 0, -2), origin.offset(-1, 0, 2), origin.offset(1, 0, 2), origin.offset(-2, 0, -1), origin.offset(-2, 0, 1), origin.offset(2, 0, -1), origin.offset(2, 0, 1), origin.offset(-1, 0, -1), origin.offset(1, 0, 1), origin.offset(-1, 0, 1), origin.offset(1, 0, -1), origin.offset(0, 0, 0), origin.offset(1, 0, 0), origin.offset(-1, 0, 0), origin.offset(0, 0, 1), origin.offset(0, 0, -1), origin.offset(0, 0, 0)};
        List positions = CollectionsKt.listOf((Object[])blockPosArray);
        for (BlockPos pos : positions) {
            Intrinsics.checkNotNull((Object)pos);
            Object object = leafBlock.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            this.setBlockIfClear(worldGenLevel, pos, (BlockState)object);
        }
        worldGenLevel.setBlock(origin, logBlock, 2);
    }

    private final void placeSmallLeafPattern(WorldGenLevel worldGenLevel, BlockPos origin, BlockState logBlock, BlockState leafBlock, BlockState specialBlock, RandomSource random) {
        BlockPos[] blockPosArray = new BlockPos[]{origin.offset(-1, 0, 0), origin.offset(1, 0, 0), origin.offset(0, 0, -1), origin.offset(0, 0, 1)};
        List positions = CollectionsKt.listOf((Object[])blockPosArray);
        for (BlockPos pos : positions) {
            Intrinsics.checkNotNull((Object)pos);
            Object object = CobblemonBlocks.SACCHARINE_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            this.setBlockIfClear(worldGenLevel, pos, (BlockState)object);
        }
        BlockPos[] blockPosArray2 = new BlockPos[]{origin.offset(-1, 0, -1), origin.offset(1, 0, 1), origin.offset(-1, 0, 1), origin.offset(1, 0, -1)};
        List specialPositions = CollectionsKt.listOf((Object[])blockPosArray2);
        for (BlockPos pos : specialPositions) {
            if (random.nextFloat() < 0.25f) {
                Intrinsics.checkNotNull((Object)pos);
                this.setBlockIfClear(worldGenLevel, pos, specialBlock);
                continue;
            }
            if (Intrinsics.areEqual((Object)leafBlock.getBlock(), (Object)Blocks.AIR)) continue;
            Intrinsics.checkNotNull((Object)pos);
            Object object = leafBlock.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            this.setBlockIfClear(worldGenLevel, pos, (BlockState)object);
        }
        worldGenLevel.setBlock(origin, logBlock, 2);
    }

    private final void placeLeafStartPattern(WorldGenLevel worldGenLevel, BlockPos origin, BlockState logBlock, BlockState leafBlock, List<BlockPos> potentialBeeNestPositions, RandomSource random) {
        BlockPos[] blockPosArray = new BlockPos[]{origin.offset(-1, 0, 0), origin.offset(1, 0, 0), origin.offset(0, 0, -1), origin.offset(0, 0, 1), origin.offset(-1, 0, -1), origin.offset(1, 0, 1), origin.offset(-1, 0, 1), origin.offset(1, 0, -1)};
        List positions = CollectionsKt.listOf((Object[])blockPosArray);
        for (BlockPos pos : positions) {
            if (random.nextFloat() < 0.25f) {
                Intrinsics.checkNotNull((Object)pos);
                potentialBeeNestPositions.add(pos);
                continue;
            }
            Intrinsics.checkNotNull((Object)pos);
            Object object = leafBlock.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            this.setBlockIfClear(worldGenLevel, pos, (BlockState)object);
        }
        worldGenLevel.setBlock(origin, logBlock, 2);
    }

    private final void placeTopTrunkPattern(WorldGenLevel worldGenLevel, BlockPos origin, BlockState logBlock, List<BlockPos> potentialBeeNestPositions) {
        Object[] objectArray = new BlockPos[]{origin.offset(-1, 0, 0), origin.offset(1, 0, 0), origin.offset(0, 0, -1), origin.offset(0, 0, 1)};
        List positions = CollectionsKt.listOf((Object[])objectArray);
        potentialBeeNestPositions.addAll(positions);
        worldGenLevel.setBlock(origin, logBlock, 2);
    }

    private final void setBlockIfClear(WorldGenLevel worldGenLevel, BlockPos blockPos, BlockState blockState) {
        if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)((LevelSimulatedReader)worldGenLevel), (BlockPos)blockPos)) {
            return;
        }
        worldGenLevel.setBlock(blockPos, blockState, 3);
    }

    private static final void populateBeeNest$lambda$0(WorldGenLevel $worldGenLevel, BeehiveBlockEntity beehiveBlockEntity) {
        RandomSource randomSource = $worldGenLevel.getRandom();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
        RandomSource randomSource2 = randomSource;
        int isCombee = randomSource2.nextInt(2);
        int i = 2 + randomSource2.nextInt(2);
        for (int j = 0; j < i; ++j) {
            if (isCombee > 0) {
                BeehiveBlockEntity beehiveBlockEntity2 = beehiveBlockEntity;
                Intrinsics.checkNotNull((Object)beehiveBlockEntity2);
                beehiveBlockEntity2.storeBee(BeehiveBlockEntity.Occupant.create((int)randomSource2.nextInt(599)));
                continue;
            }
            String properties = POKEMON_ARGS + " lvl=" + RangesKt.random((IntRange)LEVEL_RANGE, (Random)((Random)Random.Default));
            PokemonProperties pokemon = PokemonProperties.Companion.parse$default(PokemonProperties.Companion, properties, null, null, 6, null);
            ServerLevel serverLevel = $worldGenLevel.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
            PokemonEntity entity = PokemonProperties.createEntity$default(pokemon, (Level)serverLevel, null, 2, null);
            BeehiveBlockEntity beehiveBlockEntity3 = beehiveBlockEntity;
            Intrinsics.checkNotNull((Object)beehiveBlockEntity3);
            beehiveBlockEntity3.addOccupant((Entity)entity);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/world/feature/SaccharineTreeFeature$Companion;", "", "<init>", "()V", "", "POKEMON_ARGS", "Ljava/lang/String;", "getPOKEMON_ARGS", "()Ljava/lang/String;", "Lkotlin/ranges/IntRange;", "LEVEL_RANGE", "Lkotlin/ranges/IntRange;", "getLEVEL_RANGE", "()Lkotlin/ranges/IntRange;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPOKEMON_ARGS() {
            return POKEMON_ARGS;
        }

        @NotNull
        public final IntRange getLEVEL_RANGE() {
            return LEVEL_RANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

