/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.world.feature;

import com.cobblemon.mod.common.block.MintBlock;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/world/feature/MintBlockFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/BlockStateConfiguration;", "<init>", "()V", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "context", "", "place", "(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z", "Lnet/minecraft/world/level/WorldGenLevel;", "world", "Lnet/minecraft/core/BlockPos;", "origin", "", "getValidPositions", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;)Ljava/util/List;", "common"})
@SourceDebugExtension(value={"SMAP\nMintBlockFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MintBlockFeature.kt\ncom/cobblemon/mod/common/world/feature/MintBlockFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1869#2,2:65\n*S KotlinDebug\n*F\n+ 1 MintBlockFeature.kt\ncom/cobblemon/mod/common/world/feature/MintBlockFeature\n*L\n39#1:65,2\n*E\n"})
public final class MintBlockFeature
extends Feature<BlockStateConfiguration> {
    public MintBlockFeature() {
        super(BlockStateConfiguration.CODEC);
    }

    public boolean place(@NotNull FeaturePlaceContext<BlockStateConfiguration> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        WorldGenLevel world = context.level();
        BlockPos blockPos = context.origin();
        BlockState blockState = ((BlockStateConfiguration)context.config()).state;
        BlockPos floor = blockPos.below();
        if (!world.getBlockState(floor).is(BlockTags.DIRT)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)world);
        Intrinsics.checkNotNull((Object)blockPos);
        List<BlockPos> validPlacements = this.getValidPositions(world, blockPos);
        if (validPlacements.isEmpty()) {
            return false;
        }
        int minAge = 5;
        int maxAge = 7;
        world.setBlock(blockPos, (BlockState)blockState.setValue((Property)MintBlock.Companion.getAGE(), (Comparable)Integer.valueOf(context.random().nextIntBetweenInclusive(minAge, maxAge))), 2);
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)validPlacements), (int)2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos position = (BlockPos)element$iv;
            boolean bl = false;
            world.setBlock(position, (BlockState)blockState.setValue((Property)MintBlock.Companion.getAGE(), (Comparable)Integer.valueOf(context.random().nextIntBetweenInclusive(minAge, maxAge))), 2);
        }
        return true;
    }

    private final List<BlockPos> getValidPositions(WorldGenLevel world, BlockPos origin) {
        List validPositions = new ArrayList();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0) continue;
                    BlockPos offsetPos = origin.offset(x, y, z);
                    BlockState floorBlockState = world.getBlockState(offsetPos.below());
                    if (!world.isEmptyBlock(offsetPos) || !floorBlockState.is(BlockTags.DIRT)) continue;
                    Intrinsics.checkNotNull((Object)offsetPos);
                    validPositions.add(offsetPos);
                }
            }
        }
        return validPositions;
    }
}

