/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.PlayerSpawnerAccessor;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.dialogue.ActiveDialogue;
import com.cobblemon.mod.common.api.dialogue.Dialogue;
import com.cobblemon.mod.common.api.dialogue.DialogueManager;
import com.cobblemon.mod.common.api.pokedex.PokedexManager;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.storage.player.PlayerDataExtension;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.TeamManager;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.PokedexItem;
import com.cobblemon.mod.common.net.messages.client.storage.pc.wallpaper.RequestPCBoxWallpapersPacket;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerPlayerEvent;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.EntityTraceResult;
import com.cobblemon.mod.common.util.TraceResult;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0005\u001a\u00020\u0004*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0011\u0010\b\u001a\u00020\u0007*\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0011\u0010\u000b\u001a\u00020\n*\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000f\u001a\u00020\n*\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0019\u0010\u000f\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000f\u0010\u0013\u001a\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u0016*\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0019\u0010\u001b\u001a\u00020\u001a*\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u0000*\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u0011\u0010 \u001a\u00020\n*\u00020\u0000\u00a2\u0006\u0004\b \u0010\f\u001a\u001f\u0010#\u001a\u00020\n*\u00020\u00002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0!\u00a2\u0006\u0004\b#\u0010$\u001a\u0011\u0010%\u001a\u00020\u001a*\u00020\u0000\u00a2\u0006\u0004\b%\u0010&\u001a\u0011\u0010'\u001a\u00020\u001a*\u00020\u0000\u00a2\u0006\u0004\b'\u0010&\u001a\u001f\u0010+\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0018\u00010(*\u00020\u0000\u00a2\u0006\u0004\b+\u0010,\u001a\u0013\u0010.\u001a\u0004\u0018\u00010-*\u00020\u0000\u00a2\u0006\u0004\b.\u0010/\u001a\u0011\u00100\u001a\u00020\u001a*\u00020\u0000\u00a2\u0006\u0004\b0\u0010&\u001a!\u00105\u001a\u00020\u001a*\u00020\u00002\u0006\u00102\u001a\u0002012\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\b5\u00106\u001a-\u0010:\u001a\u00020\u001a*\u0002072\u0006\u00108\u001a\u0002072\b\b\u0002\u00104\u001a\u0002032\b\b\u0002\u00109\u001a\u000203\u00a2\u0006\u0004\b:\u0010;\u001aW\u0010B\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010<*\u000207*\u0002012\b\b\u0002\u00104\u001a\u0002032\b\b\u0002\u00109\u001a\u0002032\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000=2\n\b\u0002\u0010?\u001a\u0004\u0018\u00018\u00002\n\b\u0002\u0010A\u001a\u0004\u0018\u00010@\u00a2\u0006\u0004\bB\u0010C\u001a[\u0010E\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010D\"\b\b\u0000\u0010<*\u000207*\u0002012\b\b\u0002\u00104\u001a\u0002032\b\b\u0002\u00109\u001a\u0002032\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000=2\n\b\u0002\u0010?\u001a\u0004\u0018\u00018\u00002\b\u0010A\u001a\u0004\u0018\u00010@\u00a2\u0006\u0004\bE\u0010F\u001ac\u0010E\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010D\"\b\b\u0000\u0010<*\u000207*\u0002012\b\b\u0002\u00104\u001a\u0002032\b\b\u0002\u00109\u001a\u0002032\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000=2\n\b\u0002\u0010?\u001a\u0004\u0018\u00018\u00002\b\u0010A\u001a\u0004\u0018\u00010@2\u0006\u0010H\u001a\u00020G\u00a2\u0006\u0004\bE\u0010I\u001a=\u0010O\u001a\u0004\u0018\u00010N*\u00020J2\b\b\u0002\u00104\u001a\u0002032\b\b\u0002\u00109\u001a\u0002032\u0014\b\u0002\u0010M\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u001a0K\u00a2\u0006\u0004\bO\u0010P\u001a%\u0010V\u001a\u00020U2\u0006\u0010Q\u001a\u00020G2\u0006\u0010R\u001a\u00020G2\u0006\u0010T\u001a\u00020S\u00a2\u0006\u0004\bV\u0010W\u001a#\u0010Z\u001a\u00020Y*\u00020\u00002\u0006\u00104\u001a\u0002032\b\u0010X\u001a\u0004\u0018\u00010@\u00a2\u0006\u0004\bZ\u0010[\u001a5\u0010`\u001a\u0004\u0018\u00010G*\u00020\u00002\u0006\u0010]\u001a\u00020\\2\u0006\u00104\u001a\u00020^2\u0006\u0010_\u001a\u00020^2\b\u0010X\u001a\u0004\u0018\u00010@\u00a2\u0006\u0004\b`\u0010a\u001a\u001f\u0010f\u001a\u0010\u0012\f\u0012\n e*\u0004\u0018\u00010d0d0c*\u00020b\u00a2\u0006\u0004\bf\u0010g\u001a#\u0010j\u001a\u00020\n*\u00020J2\u0006\u0010h\u001a\u00020d2\b\b\u0002\u0010i\u001a\u00020\u001a\u00a2\u0006\u0004\bj\u0010k\u001a\u0019\u0010m\u001a\u00020l*\u00020J2\u0006\u0010h\u001a\u00020d\u00a2\u0006\u0004\bm\u0010n\u001a\u0019\u0010o\u001a\n e*\u0004\u0018\u00010\u00190\u0019*\u00020\u0000\u00a2\u0006\u0004\bo\u0010p\u001a\u0011\u0010q\u001a\u00020\u001a*\u00020J\u00a2\u0006\u0004\bq\u0010r\u001a\u0011\u0010s\u001a\u00020\u001a*\u00020J\u00a2\u0006\u0004\bs\u0010r\u001a\u0019\u0010t\u001a\u00020\n*\u00020\u00002\u0006\u0010]\u001a\u00020\\\u00a2\u0006\u0004\bt\u0010u\"\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bv\u0010w\"\u0015\u0010x\u001a\u00020\u001a*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bx\u0010&\"(\u0010\u007f\u001a\u00020y*\u00020\u00002\u0006\u0010z\u001a\u00020y8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b{\u0010|\"\u0004\b}\u0010~\u00a8\u0006\u0080\u0001"}, d2={"Lnet/minecraft/server/level/ServerPlayer;", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "party", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "pc", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/api/pokedex/PokedexManager;", "pokedex", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/api/pokedex/PokedexManager;", "", "closeDialogue", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lcom/cobblemon/mod/common/api/dialogue/Dialogue;", "dialogue", "openDialogue", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/dialogue/Dialogue;)V", "Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "activeDialogue", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;)V", "", "key", "Lcom/cobblemon/mod/common/api/storage/player/PlayerDataExtension;", "extraData", "(Lnet/minecraft/server/level/ServerPlayer;Ljava/lang/String;)Lcom/cobblemon/mod/common/api/storage/player/PlayerDataExtension;", "Lnet/minecraft/resources/ResourceLocation;", "", "hasKeyItem", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/resources/ResourceLocation;)Z", "Ljava/util/UUID;", "getPlayer", "(Ljava/util/UUID;)Lnet/minecraft/server/level/ServerPlayer;", "requestWallpapers", "Lkotlin/Function0;", "handler", "onLogout", "(Lnet/minecraft/server/level/ServerPlayer;Lkotlin/jvm/functions/Function0;)V", "didSleep", "(Lnet/minecraft/server/level/ServerPlayer;)Z", "isInBattle", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "getBattleState", "(Lnet/minecraft/server/level/ServerPlayer;)Lkotlin/Pair;", "Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "getBattleTeam", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/battles/TeamManager$MultiBattleTeam;", "isTrading", "Lnet/minecraft/world/entity/LivingEntity;", "target", "", "maxDistance", "canInteractWith", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/LivingEntity;F)Z", "Lnet/minecraft/world/entity/Entity;", "other", "stepDistance", "isLookingAt", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;FF)Z", "T", "Ljava/lang/Class;", "entityClass", "ignoreEntity", "Lnet/minecraft/world/level/ClipContext$Fluid;", "collideBlock", "traceFirstEntityCollision", "(Lnet/minecraft/world/entity/LivingEntity;FFLjava/lang/Class;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Fluid;)Lnet/minecraft/world/entity/Entity;", "Lcom/cobblemon/mod/common/util/EntityTraceResult;", "traceEntityCollision", "(Lnet/minecraft/world/entity/LivingEntity;FFLjava/lang/Class;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Fluid;)Lcom/cobblemon/mod/common/util/EntityTraceResult;", "Lnet/minecraft/world/phys/Vec3;", "direction", "(Lnet/minecraft/world/entity/LivingEntity;FFLjava/lang/Class;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Fluid;Lnet/minecraft/world/phys/Vec3;)Lcom/cobblemon/mod/common/util/EntityTraceResult;", "Lnet/minecraft/world/entity/player/Player;", "Lkotlin/Function1;", "Lnet/minecraft/world/level/block/state/BlockState;", "blockFilter", "Lcom/cobblemon/mod/common/util/TraceResult;", "traceBlockCollision", "(Lnet/minecraft/world/entity/player/Player;FFLkotlin/jvm/functions/Function1;)Lcom/cobblemon/mod/common/util/TraceResult;", "p0", "p1", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/core/Direction;", "findDirectionForIntercept", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Direction;", "fluidHandling", "Lnet/minecraft/world/phys/BlockHitResult;", "raycast", "(Lnet/minecraft/server/level/ServerPlayer;FLnet/minecraft/world/level/ClipContext$Fluid;)Lnet/minecraft/world/phys/BlockHitResult;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "dropHeight", "raycastSafeSendout", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;DDLnet/minecraft/world/level/ClipContext$Fluid;)Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/world/entity/player/Inventory;", "", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "usableItems", "(Lnet/minecraft/world/entity/player/Inventory;)Ljava/util/List;", "stack", "playSound", "giveOrDropItemStack", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;Z)V", "Lnet/minecraft/world/entity/item/ItemEntity;", "dropFakeItem", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;", "getBattleTheme", "(Lnet/minecraft/server/level/ServerPlayer;)Lnet/minecraft/resources/ResourceLocation;", "isPartyBusy", "(Lnet/minecraft/world/entity/player/Player;)Z", "isUsingPokedex", "updateShoulderNbt", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "getActiveDialogue", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/api/dialogue/ActiveDialogue;", "isInDialogue", "Lcom/cobblemon/mod/common/api/spawning/spawner/PlayerSpawner;", "value", "getSpawner", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/api/spawning/spawner/PlayerSpawner;", "setSpawner", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/spawning/spawner/PlayerSpawner;)V", "spawner", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerExtensions.kt\ncom/cobblemon/mod/common/util/PlayerExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,493:1\n1#2:494\n2423#3,14:495\n774#3:509\n865#3,2:510\n1563#3:512\n1634#3,3:513\n*S KotlinDebug\n*F\n+ 1 PlayerExtensions.kt\ncom/cobblemon/mod/common/util/PlayerExtensionsKt\n*L\n169#1:495,14\n212#1:509\n212#1:510,2\n490#1:512\n490#1:513,3\n*E\n"})
public final class PlayerExtensionsKt {
    @NotNull
    public static final PlayerPartyStore party(@NotNull ServerPlayer $this$party) {
        Intrinsics.checkNotNullParameter((Object)$this$party, (String)"<this>");
        return Cobblemon.INSTANCE.getStorage().getParty($this$party);
    }

    @NotNull
    public static final PCStore pc(@NotNull ServerPlayer $this$pc) {
        Intrinsics.checkNotNullParameter((Object)$this$pc, (String)"<this>");
        return Cobblemon.INSTANCE.getStorage().getPC($this$pc);
    }

    @NotNull
    public static final PokedexManager pokedex(@NotNull ServerPlayer $this$pokedex) {
        Intrinsics.checkNotNullParameter((Object)$this$pokedex, (String)"<this>");
        return Cobblemon.INSTANCE.getPlayerDataManager().getPokedexData($this$pokedex);
    }

    @Nullable
    public static final ActiveDialogue getActiveDialogue(@NotNull ServerPlayer $this$activeDialogue) {
        Intrinsics.checkNotNullParameter((Object)$this$activeDialogue, (String)"<this>");
        return DialogueManager.INSTANCE.getActiveDialogues().get($this$activeDialogue.getUUID());
    }

    public static final boolean isInDialogue(@NotNull ServerPlayer $this$isInDialogue) {
        Intrinsics.checkNotNullParameter((Object)$this$isInDialogue, (String)"<this>");
        return DialogueManager.INSTANCE.getActiveDialogues().containsKey($this$isInDialogue.getUUID());
    }

    public static final void closeDialogue(@NotNull ServerPlayer $this$closeDialogue) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$closeDialogue, (String)"<this>");
            ActiveDialogue activeDialogue = PlayerExtensionsKt.getActiveDialogue($this$closeDialogue);
            if (activeDialogue == null) break block0;
            activeDialogue.close();
        }
    }

    public static final void openDialogue(@NotNull ServerPlayer $this$openDialogue, @NotNull Dialogue dialogue) {
        Intrinsics.checkNotNullParameter((Object)$this$openDialogue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dialogue, (String)"dialogue");
        DialogueManager.startDialogue($this$openDialogue, dialogue);
    }

    public static final void openDialogue(@NotNull ServerPlayer $this$openDialogue, @NotNull ActiveDialogue activeDialogue) {
        Intrinsics.checkNotNullParameter((Object)$this$openDialogue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)activeDialogue, (String)"activeDialogue");
        DialogueManager.startDialogue(activeDialogue);
    }

    @Nullable
    public static final PlayerDataExtension extraData(@NotNull ServerPlayer $this$extraData, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$extraData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Cobblemon.INSTANCE.getPlayerDataManager().getGenericData($this$extraData).getExtraData().get(key);
    }

    public static final boolean hasKeyItem(@NotNull ServerPlayer $this$hasKeyItem, @NotNull ResourceLocation key) {
        Intrinsics.checkNotNullParameter((Object)$this$hasKeyItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Cobblemon.INSTANCE.getPlayerDataManager().getGenericData($this$hasKeyItem).getKeyItems().contains(key);
    }

    @Nullable
    public static final ServerPlayer getPlayer(@NotNull UUID $this$getPlayer) {
        Intrinsics.checkNotNullParameter((Object)$this$getPlayer, (String)"<this>");
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        return minecraftServer != null && (minecraftServer = minecraftServer.getPlayerList()) != null ? minecraftServer.getPlayer($this$getPlayer) : null;
    }

    public static final void requestWallpapers(@NotNull ServerPlayer $this$requestWallpapers) {
        Intrinsics.checkNotNullParameter((Object)$this$requestWallpapers, (String)"<this>");
        new RequestPCBoxWallpapersPacket().sendToPlayer($this$requestWallpapers);
    }

    public static final void onLogout(@NotNull ServerPlayer $this$onLogout, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)$this$onLogout, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Observable.subscribe$default(PlatformEvents.SERVER_PLAYER_LOGOUT.pipe(Observable.Companion.filter(arg_0 -> PlayerExtensionsKt.onLogout$lambda$0($this$onLogout, arg_0)), Observable.Companion.takeFirst$default(Observable.Companion, 0, 1, null)), null, arg_0 -> PlayerExtensionsKt.onLogout$lambda$1(handler, arg_0), 1, null);
    }

    public static final boolean didSleep(@NotNull ServerPlayer $this$didSleep) {
        Intrinsics.checkNotNullParameter((Object)$this$didSleep, (String)"<this>");
        if ($this$didSleep.getSleepTimer() != 100 || (int)$this$didSleep.level().getDayTime() % 24000 != 0 || PlayerExtensionsKt.isInBattle($this$didSleep)) {
            return false;
        }
        PlayerExtensionsKt.party($this$didSleep).didSleep();
        return true;
    }

    public static final boolean isInBattle(@NotNull ServerPlayer $this$isInBattle) {
        Intrinsics.checkNotNullParameter((Object)$this$isInBattle, (String)"<this>");
        return BattleRegistry.getBattleByParticipatingPlayer($this$isInBattle) != null;
    }

    @NotNull
    public static final PlayerSpawner getSpawner(@NotNull ServerPlayer $this$spawner) {
        Intrinsics.checkNotNullParameter((Object)$this$spawner, (String)"<this>");
        PlayerSpawner playerSpawner = ((PlayerSpawnerAccessor)$this$spawner).getPlayerSpawner();
        Intrinsics.checkNotNullExpressionValue((Object)playerSpawner, (String)"getPlayerSpawner(...)");
        return playerSpawner;
    }

    public static final void setSpawner(@NotNull ServerPlayer $this$spawner, @NotNull PlayerSpawner value) {
        Intrinsics.checkNotNullParameter((Object)$this$spawner, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((PlayerSpawnerAccessor)$this$spawner).setPlayerSpawner(value);
    }

    @Nullable
    public static final Pair<PokemonBattle, BattleActor> getBattleState(@NotNull ServerPlayer $this$getBattleState) {
        BattleActor actor;
        Intrinsics.checkNotNullParameter((Object)$this$getBattleState, (String)"<this>");
        PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer($this$getBattleState);
        if (battle != null && (actor = battle.getActor($this$getBattleState)) != null) {
            return TuplesKt.to((Object)battle, (Object)actor);
        }
        return null;
    }

    @Nullable
    public static final TeamManager.MultiBattleTeam getBattleTeam(@NotNull ServerPlayer $this$getBattleTeam) {
        Intrinsics.checkNotNullParameter((Object)$this$getBattleTeam, (String)"<this>");
        return TeamManager.INSTANCE.getTeam($this$getBattleTeam);
    }

    public static final boolean isTrading(@NotNull ServerPlayer $this$isTrading) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrading, (String)"<this>");
        UUID uUID = $this$isTrading.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return TradeManager.INSTANCE.getActiveTrade(uUID) != null;
    }

    public static final boolean canInteractWith(@NotNull ServerPlayer $this$canInteractWith, @NotNull LivingEntity target, float maxDistance) {
        ClipContext.Fluid fluid;
        Class<LivingEntity> clazz;
        Intrinsics.checkNotNullParameter((Object)$this$canInteractWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return !Intrinsics.areEqual((Object)target, (Object)$this$canInteractWith) && !$this$canInteractWith.isSpectator() && !target.isSpectator() && Intrinsics.areEqual((Object)PlayerExtensionsKt.traceFirstEntityCollision$default((LivingEntity)$this$canInteractWith, maxDistance, 0.0f, clazz = LivingEntity.class, (Entity)$this$canInteractWith, fluid = ClipContext.Fluid.NONE, 2, null), (Object)target);
    }

    public static final boolean isLookingAt(@NotNull Entity $this$isLookingAt, @NotNull Entity other, float maxDistance, float stepDistance) {
        Intrinsics.checkNotNullParameter((Object)$this$isLookingAt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Vec3 startPos = $this$isLookingAt.getEyePosition();
        Vec3 direction = $this$isLookingAt.getLookAngle();
        for (float step = stepDistance; step <= maxDistance; step += stepDistance) {
            Vec3 location = startPos.add(direction.scale((double)step));
            if (!other.getBoundingBox().contains(location)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean isLookingAt$default(Entity entity, Entity entity2, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 10.0f;
        }
        if ((n & 4) != 0) {
            f2 = 0.01f;
        }
        return PlayerExtensionsKt.isLookingAt(entity, entity2, f, f2);
    }

    @Nullable
    public static final <T extends Entity> T traceFirstEntityCollision(@NotNull LivingEntity $this$traceFirstEntityCollision, float maxDistance, float stepDistance, @NotNull Class<T> entityClass, @Nullable T ignoreEntity, @Nullable ClipContext.Fluid collideBlock) {
        Entity entity;
        Intrinsics.checkNotNullParameter((Object)$this$traceFirstEntityCollision, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityTraceResult<T> entityTraceResult = PlayerExtensionsKt.traceEntityCollision($this$traceFirstEntityCollision, maxDistance, stepDistance, entityClass, ignoreEntity, collideBlock);
        if (entityTraceResult != null) {
            Object v0;
            EntityTraceResult<T> it = entityTraceResult;
            boolean bl = false;
            Iterable<T> $this$minByOrNull$iv = it.getEntities();
            boolean $i$f$minByOrNull = false;
            Iterator<T> iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                T minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    Entity it2 = (Entity)minElem$iv;
                    boolean bl2 = false;
                    float minValue$iv = it2.distanceTo((Entity)$this$traceFirstEntityCollision);
                    do {
                        T e$iv = iterator$iv.next();
                        Entity it3 = (Entity)e$iv;
                        $i$a$-minByOrNull-PlayerExtensionsKt$traceFirstEntityCollision$1$1 = false;
                        float v$iv = it3.distanceTo((Entity)$this$traceFirstEntityCollision);
                        if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            entity = v0;
        } else {
            entity = null;
        }
        return (T)entity;
    }

    public static /* synthetic */ Entity traceFirstEntityCollision$default(LivingEntity livingEntity, float f, float f2, Class clazz, Entity entity, ClipContext.Fluid fluid, int n, Object object) {
        if ((n & 1) != 0) {
            f = 10.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.05f;
        }
        if ((n & 8) != 0) {
            entity = null;
        }
        if ((n & 0x10) != 0) {
            fluid = null;
        }
        return PlayerExtensionsKt.traceFirstEntityCollision(livingEntity, f, f2, clazz, entity, fluid);
    }

    @Nullable
    public static final <T extends Entity> EntityTraceResult<T> traceEntityCollision(@NotNull LivingEntity $this$traceEntityCollision, float maxDistance, float stepDistance, @NotNull Class<T> entityClass, @Nullable T ignoreEntity, @Nullable ClipContext.Fluid collideBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$traceEntityCollision, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Vec3 direction = $this$traceEntityCollision.getLookAngle();
        Intrinsics.checkNotNull((Object)direction);
        return PlayerExtensionsKt.traceEntityCollision($this$traceEntityCollision, maxDistance, stepDistance, entityClass, ignoreEntity, collideBlock, direction);
    }

    public static /* synthetic */ EntityTraceResult traceEntityCollision$default(LivingEntity livingEntity, float f, float f2, Class clazz, Entity entity, ClipContext.Fluid fluid, int n, Object object) {
        if ((n & 1) != 0) {
            f = 10.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.05f;
        }
        if ((n & 8) != 0) {
            entity = null;
        }
        return PlayerExtensionsKt.traceEntityCollision(livingEntity, f, f2, clazz, entity, fluid);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T extends Entity> EntityTraceResult<T> traceEntityCollision(@NotNull LivingEntity $this$traceEntityCollision, float maxDistance, float stepDistance, @NotNull Class<T> entityClass, @Nullable T ignoreEntity, @Nullable ClipContext.Fluid collideBlock, @NotNull Vec3 direction) {
        Intrinsics.checkNotNullParameter((Object)$this$traceEntityCollision, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        float step = stepDistance;
        Vec3 startPos = $this$traceEntityCollision.getEyePosition();
        Vec3 maxDistanceVector = new Vec3(1.0, 1.0, 1.0).scale((double)maxDistance);
        List entities = $this$traceEntityCollision.level().getEntities(null, new AABB(startPos.subtract(maxDistanceVector), startPos.add(maxDistanceVector)), arg_0 -> PlayerExtensionsKt.traceEntityCollision$lambda$1(arg_0 -> PlayerExtensionsKt.traceEntityCollision$lambda$0(entityClass, arg_0), arg_0));
        while (step <= maxDistance) {
            void $this$filterTo$iv$iv;
            Vec3 location = startPos.add(direction.scale((double)step));
            step += stepDistance;
            Intrinsics.checkNotNull((Object)entities);
            Iterable $this$filter$iv = entities;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entity it = (Entity)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(ignoreEntity, (Object)it) && it.getBoundingBox().contains(location) && entityClass.isAssignableFrom(it.getClass()) && !it.isSpectator())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List collided = (List)destination$iv$iv;
            if (!(!((Collection)collided).isEmpty())) continue;
            if (collideBlock != null && $this$traceEntityCollision.level().clip(new ClipContext(startPos, location, ClipContext.Block.COLLIDER, collideBlock, (Entity)$this$traceEntityCollision)).getType() == HitResult.Type.BLOCK) {
                return null;
            }
            Intrinsics.checkNotNull((Object)location);
            return new EntityTraceResult(location, CollectionsKt.filterIsInstance((Iterable)collided, entityClass));
        }
        return null;
    }

    public static /* synthetic */ EntityTraceResult traceEntityCollision$default(LivingEntity livingEntity, float f, float f2, Class clazz, Entity entity, ClipContext.Fluid fluid, Vec3 vec3, int n, Object object) {
        if ((n & 1) != 0) {
            f = 10.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.05f;
        }
        if ((n & 8) != 0) {
            entity = null;
        }
        return PlayerExtensionsKt.traceEntityCollision(livingEntity, f, f2, clazz, entity, fluid, vec3);
    }

    @Nullable
    public static final TraceResult traceBlockCollision(@NotNull Player $this$traceBlockCollision, float maxDistance, float stepDistance, @NotNull Function1<? super BlockState, Boolean> blockFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$traceBlockCollision, (String)"<this>");
        Intrinsics.checkNotNullParameter(blockFilter, (String)"blockFilter");
        Vec3 startPos = $this$traceBlockCollision.getEyePosition();
        Vec3 direction = $this$traceBlockCollision.getLookAngle();
        Intrinsics.checkNotNull((Object)startPos);
        BlockPos lastBlockPos = Vec3ExtensionsKt.toBlockPos(startPos);
        for (float step = stepDistance; step <= maxDistance; step += stepDistance) {
            Vec3 location = startPos.add(direction.scale((double)step));
            Intrinsics.checkNotNull((Object)location);
            BlockPos blockPos = Vec3ExtensionsKt.toBlockPos(location);
            if (Intrinsics.areEqual((Object)blockPos, (Object)lastBlockPos)) continue;
            lastBlockPos = blockPos;
            BlockState block = $this$traceBlockCollision.level().getBlockState(blockPos);
            Intrinsics.checkNotNull((Object)block);
            if (!((Boolean)blockFilter.invoke((Object)block)).booleanValue()) continue;
            Direction dir = PlayerExtensionsKt.findDirectionForIntercept(startPos, location, blockPos);
            return new TraceResult(location, blockPos, dir);
        }
        return null;
    }

    public static /* synthetic */ TraceResult traceBlockCollision$default(Player player, float f, float f2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = 10.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.05f;
        }
        if ((n & 4) != 0) {
            function1 = PlayerExtensionsKt::traceBlockCollision$lambda$0;
        }
        return PlayerExtensionsKt.traceBlockCollision(player, f, f2, (Function1<? super BlockState, Boolean>)function1);
    }

    @NotNull
    public static final Direction findDirectionForIntercept(@NotNull Vec3 p0, @NotNull Vec3 p1, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Function1 xFunc = arg_0 -> PlayerExtensionsKt.findDirectionForIntercept$lambda$0(p0, p1, arg_0);
        Function1 yFunc = arg_0 -> PlayerExtensionsKt.findDirectionForIntercept$lambda$1(p0, p1, arg_0);
        Function1 zFunc = arg_0 -> PlayerExtensionsKt.findDirectionForIntercept$lambda$2(p0, p1, arg_0);
        Function1 tForX = arg_0 -> PlayerExtensionsKt.findDirectionForIntercept$lambda$3(p0, p1, arg_0);
        Function1 tForY = arg_0 -> PlayerExtensionsKt.findDirectionForIntercept$lambda$4(p0, p1, arg_0);
        Function1 tForZ = arg_0 -> PlayerExtensionsKt.findDirectionForIntercept$lambda$5(p0, p1, arg_0);
        ClosedFloatingPointRange xRange = RangesKt.rangeTo((double)blockPos.getX(), (double)((double)blockPos.getX() + 1.0));
        ClosedFloatingPointRange yRange = RangesKt.rangeTo((double)blockPos.getY(), (double)((double)blockPos.getY() + 1.0));
        ClosedFloatingPointRange zRange = RangesKt.rangeTo((double)blockPos.getZ(), (double)((double)blockPos.getZ() + 1.0));
        double tAtNorth = ((Number)tForZ.invoke((Object)blockPos.getZ())).doubleValue();
        double tAtSouth = ((Number)tForZ.invoke((Object)((double)blockPos.getZ() + 1.0))).doubleValue();
        double tAtEast = ((Number)tForX.invoke((Object)((double)blockPos.getX() + 1.0))).doubleValue();
        double tAtWest = ((Number)tForX.invoke((Object)blockPos.getX())).doubleValue();
        double tAtUp = ((Number)tForY.invoke((Object)((double)blockPos.getY() + 1.0))).doubleValue();
        double tAtDown = ((Number)tForY.invoke((Object)blockPos.getY())).doubleValue();
        boolean northCollision = yRange.contains((Comparable)yFunc.invoke((Object)tAtNorth)) && xRange.contains((Comparable)xFunc.invoke((Object)tAtNorth));
        boolean southCollision = yRange.contains((Comparable)yFunc.invoke((Object)tAtSouth)) && xRange.contains((Comparable)xFunc.invoke((Object)tAtSouth));
        boolean eastCollision = yRange.contains((Comparable)yFunc.invoke((Object)tAtEast)) && zRange.contains((Comparable)zFunc.invoke((Object)tAtEast));
        boolean westCollision = yRange.contains((Comparable)yFunc.invoke((Object)tAtWest)) && zRange.contains((Comparable)zFunc.invoke((Object)tAtWest));
        boolean upCollision = zRange.contains((Comparable)zFunc.invoke((Object)tAtUp)) && xRange.contains((Comparable)xFunc.invoke((Object)tAtUp));
        boolean downCollision = zRange.contains((Comparable)zFunc.invoke((Object)tAtDown)) && xRange.contains((Comparable)xFunc.invoke((Object)tAtDown));
        Direction minDirection = Direction.UP;
        double minTime = Double.MAX_VALUE;
        if (northCollision && tAtNorth < minTime) {
            minDirection = Direction.NORTH;
            minTime = tAtNorth;
        }
        if (southCollision && tAtSouth < minTime) {
            minDirection = Direction.SOUTH;
            minTime = tAtSouth;
        }
        if (eastCollision && tAtEast < minTime) {
            minDirection = Direction.EAST;
            minTime = tAtEast;
        }
        if (westCollision && tAtWest < minTime) {
            minDirection = Direction.WEST;
            minTime = tAtWest;
        }
        if (upCollision && tAtUp < minTime) {
            minDirection = Direction.UP;
            minTime = tAtUp;
        }
        if (downCollision && tAtDown < minTime) {
            return Direction.DOWN;
        }
        return minDirection;
    }

    @NotNull
    public static final BlockHitResult raycast(@NotNull ServerPlayer $this$raycast, float maxDistance, @Nullable ClipContext.Fluid fluidHandling) {
        Intrinsics.checkNotNullParameter((Object)$this$raycast, (String)"<this>");
        float f = $this$raycast.getXRot();
        float g = $this$raycast.getYRot();
        Vec3 vec3d = $this$raycast.getEyePosition();
        float h = Mth.cos((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.sin((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        Vec3 vec3d2 = vec3d.add((double)l * (double)maxDistance, (double)k * (double)maxDistance, (double)n * (double)maxDistance);
        BlockHitResult blockHitResult = $this$raycast.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, fluidHandling, (Entity)$this$raycast));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
        return blockHitResult;
    }

    @Nullable
    public static final Vec3 raycastSafeSendout(@NotNull ServerPlayer $this$raycastSafeSendout, @NotNull Pokemon pokemon, double maxDistance, double dropHeight, @Nullable ClipContext.Fluid fluidHandling) {
        Intrinsics.checkNotNullParameter((Object)$this$raycastSafeSendout, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        float f = $this$raycastSafeSendout.getXRot();
        float g = $this$raycastSafeSendout.getYRot();
        Vec3 vec3d = $this$raycastSafeSendout.getEyePosition();
        float h = Mth.cos((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.sin((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        Vec3 vec3d2 = vec3d.add((double)l * maxDistance, (double)k * maxDistance, (double)n * maxDistance);
        BlockHitResult result = $this$raycastSafeSendout.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, fluidHandling, (Entity)$this$raycastSafeSendout));
        if ($this$raycastSafeSendout.level().getBlockState(result.getBlockPos()).isAir()) {
            TraceResult traceDown = null;
            double minDrop = Math.min(2.5, maxDistance);
            double stepDistance = 0.05;
            double stepDrop = minDrop;
            Vec3 stepPos = null;
            double traceHeight = 0.0;
            double smallestHeight = dropHeight;
            TraceResult fallLoc = null;
            for (double step = minDrop; step <= maxDistance; step += stepDistance) {
                Intrinsics.checkNotNullExpressionValue((Object)vec3d.add((double)l * step, (double)k * step, (double)n * step), (String)"add(...)");
                if (!(minDrop == maxDistance)) {
                    stepDrop = (step - minDrop) / (maxDistance - minDrop) * dropHeight;
                }
                Level level = $this$raycastSafeSendout.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                traceDown = WorldExtensionsKt.traceDownwards$default(stepPos, level, (float)stepDrop, 0.0f, 4, null);
                if (traceDown == null) continue;
                Level level2 = $this$raycastSafeSendout.level();
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
                if (!pokemon.isPositionSafe(level2, traceDown.getBlockPos()) || !((traceHeight = stepPos.y - traceDown.getLocation().y) < smallestHeight)) continue;
                smallestHeight = traceHeight;
                fallLoc = traceDown;
            }
            TraceResult traceResult = fallLoc;
            return traceResult != null && (traceResult = traceResult.getBlockPos()) != null && (traceResult = traceResult.above()) != null ? traceResult.getCenter() : null;
        }
        if (result.getDirection() != Direction.UP) {
            double offset = result.getDirection() == Direction.DOWN ? 0.125 + (double)(pokemon.getForm().getHitbox().height() * pokemon.getForm().getBaseScale()) * 0.5 : 0.125 + (double)(pokemon.getForm().getHitbox().width() * pokemon.getForm().getBaseScale()) * 0.5;
            Vec3 posOffset = result.getLocation().relative(result.getDirection(), offset);
            Intrinsics.checkNotNull((Object)posOffset);
            Level level = $this$raycastSafeSendout.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            TraceResult traceDown = WorldExtensionsKt.traceDownwards$default(posOffset, level, (float)dropHeight, 0.0f, 4, null);
            if (traceDown != null) {
                Level level3 = $this$raycastSafeSendout.level();
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"level(...)");
                if (pokemon.isPositionSafe(level3, traceDown.getBlockPos())) {
                    double d = traceDown.getLocation().x;
                    BlockPos blockPos = traceDown.getBlockPos().above();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
                    return new Vec3(d, BlockPosExtensionsKt.toVec3d((BlockPos)blockPos).y, traceDown.getLocation().z);
                }
            }
            return null;
        }
        if (!$this$raycastSafeSendout.level().getBlockState(result.getBlockPos().above()).isSolid()) {
            Level level = $this$raycastSafeSendout.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            BlockPos blockPos = result.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            if (pokemon.isPositionSafe(level, blockPos)) {
                double d = result.getLocation().x;
                BlockPos blockPos2 = result.getBlockPos().above();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"above(...)");
                return new Vec3(d, BlockPosExtensionsKt.toVec3d((BlockPos)blockPos2).y, result.getLocation().z);
            }
        }
        return null;
    }

    @NotNull
    public static final List<ItemStack> usableItems(@NotNull Inventory $this$usableItems) {
        Intrinsics.checkNotNullParameter((Object)$this$usableItems, (String)"<this>");
        NonNullList nonNullList = $this$usableItems.offhand;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"offhand");
        Collection collection = (Collection)nonNullList;
        NonNullList nonNullList2 = $this$usableItems.items;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"items");
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)nonNullList2));
    }

    public static final void giveOrDropItemStack(@NotNull Player $this$giveOrDropItemStack, @NotNull ItemStack stack, boolean playSound) {
        block2: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$giveOrDropItemStack, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                boolean inserted = $this$giveOrDropItemStack.getInventory().add(stack);
                if (!inserted || !stack.isEmpty()) break block1;
                stack.setCount(1);
                PlayerExtensionsKt.dropFakeItem($this$giveOrDropItemStack, stack);
                if (playSound) {
                    $this$giveOrDropItemStack.level().playSound(null, $this$giveOrDropItemStack.getX(), $this$giveOrDropItemStack.getY(), $this$giveOrDropItemStack.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (($this$giveOrDropItemStack.getRandom().nextFloat() - $this$giveOrDropItemStack.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                $this$giveOrDropItemStack.containerMenu.broadcastChanges();
                break block2;
            }
            ItemEntity itemEntity = $this$giveOrDropItemStack.drop(stack, false);
            if (itemEntity == null) break block2;
            ItemEntity itemEntity2 = itemEntity;
            boolean bl = false;
            itemEntity2.setNoPickUpDelay();
            itemEntity2.setTarget($this$giveOrDropItemStack.getUUID());
        }
    }

    public static /* synthetic */ void giveOrDropItemStack$default(Player player, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        PlayerExtensionsKt.giveOrDropItemStack(player, itemStack, bl);
    }

    @NotNull
    public static final ItemEntity dropFakeItem(@NotNull Player $this$dropFakeItem, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)$this$dropFakeItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        double d = $this$dropFakeItem.getEyeY() - 0.3;
        ItemEntity itemEntity = new ItemEntity($this$dropFakeItem.level(), $this$dropFakeItem.getX(), d, $this$dropFakeItem.getZ(), stack);
        float f = 0.3f;
        float g = (float)Math.sin((double)$this$dropFakeItem.getXRot() * (Math.PI / 180));
        float h = (float)Math.cos((double)$this$dropFakeItem.getXRot() * (Math.PI / 180));
        float i = (float)Math.sin((double)$this$dropFakeItem.getYRot() * (Math.PI / 180));
        float j = (float)Math.cos((double)$this$dropFakeItem.getYRot() * (Math.PI / 180));
        double k = (double)$this$dropFakeItem.getRandom().nextFloat() * (Math.PI * 2);
        float l = 0.02f * $this$dropFakeItem.getRandom().nextFloat();
        itemEntity.setDeltaMovement(new Vec3((double)(-i * h * f) + Math.cos(k) * (double)l, (double)(-g * f + 0.1f + ($this$dropFakeItem.getRandom().nextFloat() - $this$dropFakeItem.getRandom().nextFloat()) * 0.1f), (double)(j * h * f) + Math.sin(k) * (double)l));
        itemEntity.makeFakeItem();
        return itemEntity;
    }

    public static final ResourceLocation getBattleTheme(@NotNull ServerPlayer $this$getBattleTheme) {
        Intrinsics.checkNotNullParameter((Object)$this$getBattleTheme, (String)"<this>");
        ResourceLocation resourceLocation = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData($this$getBattleTheme).getBattleTheme();
        if (resourceLocation == null) {
            resourceLocation = CobblemonSounds.PVP_BATTLE.getLocation();
        }
        return resourceLocation;
    }

    public static final boolean isPartyBusy(@NotNull Player $this$isPartyBusy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPartyBusy, (String)"<this>");
        if ($this$isPartyBusy.level().isClientSide) {
            Object v2;
            block4: {
                Iterable iterable = CobblemonClient.INSTANCE.getStorage().getParty();
                for (Object t : iterable) {
                    Pokemon it = (Pokemon)t;
                    boolean bl2 = false;
                    Object object = it;
                    boolean bl3 = object != null && (object = ((Pokemon)object).getEntity()) != null ? ((PokemonEntity)object).isBusy() : false;
                    if (!bl3) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            bl = v2 != null;
        } else {
            Object v9;
            block5: {
                PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
                UUID uUID = $this$isPartyBusy.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                RegistryAccess registryAccess = $this$isPartyBusy.registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
                Iterable iterable = pokemonStoreManager.getParty(uUID, registryAccess);
                for (Object t : iterable) {
                    Pokemon it = (Pokemon)t;
                    boolean bl4 = false;
                    Object object = it;
                    boolean bl5 = object != null && (object = ((Pokemon)object).getEntity()) != null ? ((PokemonEntity)object).isBusy() : false;
                    if (!bl5) continue;
                    v9 = t;
                    break block5;
                }
                v9 = null;
            }
            bl = v9 != null;
        }
        return bl;
    }

    public static final boolean isUsingPokedex(@NotNull Player $this$isUsingPokedex) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsingPokedex, (String)"<this>");
        return $this$isUsingPokedex.isUsingItem() && ($this$isUsingPokedex.getMainHandItem().getItem() instanceof PokedexItem && $this$isUsingPokedex.getUsedItemHand() == InteractionHand.MAIN_HAND || $this$isUsingPokedex.getOffhandItem().getItem() instanceof PokedexItem && $this$isUsingPokedex.getUsedItemHand() == InteractionHand.OFF_HAND);
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateShoulderNbt(@NotNull ServerPlayer $this$updateShoulderNbt, @NotNull Pokemon pokemon) {
        Collection<StringTag> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$updateShoulderNbt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        PokemonState pokemonState = pokemon.getState();
        Intrinsics.checkNotNull((Object)pokemonState, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.pokemon.activestate.ShoulderedState");
        CompoundTag nbt = ((ShoulderedState)pokemonState).isLeftShoulder() ? $this$updateShoulderNbt.getShoulderEntityLeft().copy() : $this$updateShoulderNbt.getShoulderEntityRight().copy();
        nbt.putUUID("shoulder_uuid", $this$updateShoulderNbt.getUUID());
        nbt.putString("shoulder_species", pokemon.getSpecies().getResourceIdentifier().toString());
        nbt.putString("shoulder_form", pokemon.getForm().getName());
        Iterable iterable = pokemon.getAspects();
        String string = "shoulder_aspects";
        CompoundTag compoundTag = nbt;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringTag.valueOf((String)p0));
        }
        collection = (List)destination$iv$iv;
        compoundTag.put(string, (Tag)CollectionUtilsKt.toNbtList((Collection<? extends Tag>)collection));
        nbt.putFloat("shoulder_scale", pokemon.getScaleModifier());
        PokemonState pokemonState2 = pokemon.getState();
        Intrinsics.checkNotNull((Object)pokemonState2, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.pokemon.activestate.ShoulderedState");
        if (((ShoulderedState)pokemonState2).isLeftShoulder()) {
            $this$updateShoulderNbt.setShoulderEntityLeft(nbt);
        } else {
            $this$updateShoulderNbt.setShoulderEntityRight(nbt);
        }
    }

    private static final boolean onLogout$lambda$0(ServerPlayer $this_onLogout, ServerPlayerEvent.Logout it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getPlayer().getUUID(), (Object)$this_onLogout.getUUID());
    }

    private static final Unit onLogout$lambda$1(Function0 $handler, ServerPlayerEvent.Logout it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $handler.invoke();
        return Unit.INSTANCE;
    }

    private static final boolean traceEntityCollision$lambda$0(Class $entityClass, Entity it) {
        return $entityClass.isAssignableFrom(it.getClass());
    }

    private static final boolean traceEntityCollision$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean traceBlockCollision$lambda$0(BlockState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isSolid();
    }

    private static final double findDirectionForIntercept$lambda$0(Vec3 $p0, Vec3 $p1, double it) {
        return $p0.x + ($p1.x - $p0.x) * it;
    }

    private static final double findDirectionForIntercept$lambda$1(Vec3 $p0, Vec3 $p1, double it) {
        return $p0.y + ($p1.y - $p0.y) * it;
    }

    private static final double findDirectionForIntercept$lambda$2(Vec3 $p0, Vec3 $p1, double it) {
        return $p0.z + ($p1.z - $p0.z) * it;
    }

    private static final double findDirectionForIntercept$lambda$3(Vec3 $p0, Vec3 $p1, double it) {
        return !($p0.x == $p1.x) ? (it - $p0.x) / ($p1.x - $p0.x) : $p0.x;
    }

    private static final double findDirectionForIntercept$lambda$4(Vec3 $p0, Vec3 $p1, double it) {
        return !($p0.y == $p1.y) ? (it - $p0.y) / ($p1.y - $p0.y) : $p0.y;
    }

    private static final double findDirectionForIntercept$lambda$5(Vec3 $p0, Vec3 $p1, double it) {
        return !($p0.z == $p1.z) ? (it - $p0.z) / ($p1.z - $p0.z) : $p0.z;
    }
}

