/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util;

import com.cobblemon.mod.common.Cobblemon;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/util/FileUtils;", "", "<init>", "()V", "", "internal", "Ljava/io/InputStream;", "getResourceStream", "(Ljava/lang/String;)Ljava/io/InputStream;", "Ljava/nio/file/Path;", "external", "", "copyInternalToExternal", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "source", "target", "unzipFile", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "Ljava/util/zip/ZipEntry;", "zipEntry", "targetDir", "checkPath", "(Ljava/util/zip/ZipEntry;Ljava/nio/file/Path;)Ljava/nio/file/Path;", "common"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    private final InputStream getResourceStream(String internal) {
        InputStream inputStream = Cobblemon.class.getResourceAsStream(internal);
        if (inputStream == null) {
            throw new Exception("Could not read " + internal);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyInternalToExternal(@NotNull String internal, @NotNull Path external) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        Intrinsics.checkNotNullParameter((Object)external, (String)"external");
        Closeable closeable = this.getResourceStream(internal);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(stream, external, copyOptionArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unzipFile(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Closeable closeable = new ZipInputStream(new FileInputStream(source.toFile()));
        Throwable throwable = null;
        try {
            ZipInputStream zis = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path newPath = INSTANCE.checkPath(zipEntry, target);
                if (!zipEntry.isDirectory()) {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    v0 = Long.valueOf(Files.copy(zis, newPath, copyOptionArray));
                } else {
                    v0 = Files.createDirectories(newPath, new FileAttribute[0]);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Path checkPath(ZipEntry zipEntry, Path targetDir) {
        Path targetDirPath;
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize().toAbsolutePath();
        if (!normalizePath.startsWith(targetDirPath = targetDir.normalize().toAbsolutePath())) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        Intrinsics.checkNotNull((Object)normalizePath);
        return normalizePath;
    }
}

