/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util;

import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.StringExtensionsKt;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0007\u001a\n \u0003*\u0004\u0018\u00010\u00060\u0006*\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0019\u0010\r\u001a\u00020\f*\u00020\t2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000e\u001a#\u0010\r\u001a\u00020\f*\u00020\t2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f\u00a2\u0006\u0004\b\r\u0010\u0012\u001a\u0019\u0010\u0015\u001a\u00020\f*\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0019\u0010\u001a\u001a\u00020\u0019*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0019\u0010\u001d\u001a\u00020\f*\u00020\t2\u0006\u0010\u001c\u001a\u00020\n\u00a2\u0006\u0004\b\u001d\u0010\u000e\u001a\u001f\u0010\u001d\u001a\u00020\f*\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f\u00a2\u0006\u0004\b\u001d\u0010\u0012\u001a\u0019\u0010 \u001a\u00020\f*\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0013\u00a2\u0006\u0004\b \u0010\u0016\u001a/\u0010)\u001a\u00020(2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b)\u0010*\u001a1\u0010-\u001a\u00020&2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010'\u001a\u00020+2\u0006\u0010\"\u001a\u00020!2\b\b\u0002\u0010,\u001a\u00020(H\u0002\u00a2\u0006\u0004\b-\u0010.\u001a\u0019\u0010/\u001a\u00020\f*\u00020\u00002\u0006\u0010'\u001a\u00020+\u00a2\u0006\u0004\b/\u00100\u001a\u0011\u00101\u001a\u00020\f*\u00020\u0000\u00a2\u0006\u0004\b1\u00102\u001a)\u00106\u001a\u00020\f*\u00020\u00002\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0013032\b\b\u0002\u00105\u001a\u00020(\u00a2\u0006\u0004\b6\u00107\u001a\u0019\u00109\u001a\u000208*\u00020\u00002\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b9\u0010:\u001a7\u0010?\u001a\u0004\u0018\u00010&*\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020&0;2\u0014\b\u0002\u0010>\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\f0=\u00a2\u0006\u0004\b?\u0010@\u001a\u0011\u0010A\u001a\u00020\f*\u00020\u0000\u00a2\u0006\u0004\bA\u00102\u001a9\u0010G\u001a\u00020\u0019\"\u0004\b\u0000\u0010B*\u00020C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000D2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000=\u00a2\u0006\u0004\bG\u0010H\u00a8\u0006I"}, d2={"Lnet/minecraft/world/entity/Entity;", "Lcom/mojang/serialization/Dynamic;", "Lnet/minecraft/nbt/Tag;", "kotlin.jvm.PlatformType", "makeEmptyBrainDynamic", "(Lnet/minecraft/world/entity/Entity;)Lcom/mojang/serialization/Dynamic;", "Lnet/minecraft/network/chat/Component;", "effectiveName", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/network/chat/Component;", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/resources/ResourceLocation;", "memoryIdentifier", "", "hasMemory", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/resources/ResourceLocation;)Z", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "tagKey", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/tags/TagKey;)Z", "", "memory", "hasMemoryFromString", "(Lnet/minecraft/world/entity/LivingEntity;Ljava/lang/String;)Z", "Lnet/minecraft/world/entity/item/ItemEntity;", "itemEntity", "", "jitterDropItem", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/item/ItemEntity;)V", "activityIdentifier", "isDoingActivity", "Lnet/minecraft/world/entity/schedule/Activity;", "activity", "isDoingActivityFromString", "Lnet/minecraft/world/level/Level;", "level", "entity", "Lnet/minecraft/world/phys/AABB;", "box", "Lnet/minecraft/core/BlockPos;", "pos", "", "getPosScore", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/world/phys/Vec3;", "maxRadius", "findBestBlockPosBFS", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;I)Lnet/minecraft/core/BlockPos;", "setPositionSafely", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;)Z", "isDusk", "(Lnet/minecraft/world/entity/Entity;)Z", "", "blocks", "depth", "isStandingOn", "(Lnet/minecraft/world/entity/Entity;Ljava/util/Set;I)Z", "", "distanceTo", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;)D", "", "positions", "Lkotlin/Function1;", "filter", "closestPosition", "(Lnet/minecraft/world/entity/Entity;Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Lnet/minecraft/core/BlockPos;", "getIsSubmerged", "T", "Lnet/minecraft/network/syncher/SynchedEntityData;", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "data", "mutator", "update", "(Lnet/minecraft/network/syncher/SynchedEntityData;Lnet/minecraft/network/syncher/EntityDataAccessor;Lkotlin/jvm/functions/Function1;)V", "common"})
@SourceDebugExtension(value={"SMAP\nEntityExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityExtensions.kt\ncom/cobblemon/mod/common/util/EntityExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1761#2,3:289\n1761#2,3:292\n1869#2,2:295\n*S KotlinDebug\n*F\n+ 1 EntityExtensions.kt\ncom/cobblemon/mod/common/util/EntityExtensionsKt\n*L\n59#1:289,3\n87#1:292,3\n244#1:295,2\n*E\n"})
public final class EntityExtensionsKt {
    @NotNull
    public static final Dynamic<Tag> makeEmptyBrainDynamic(@NotNull Entity $this$makeEmptyBrainDynamic) {
        Intrinsics.checkNotNullParameter((Object)$this$makeEmptyBrainDynamic, (String)"<this>");
        DynamicOps dynamicOps = (DynamicOps)NbtOps.INSTANCE;
        Tag tag = NbtOps.INSTANCE.createString("memories");
        Object object = NbtOps.INSTANCE.emptyMap();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.nbt.Tag");
        Object object2 = NbtOps.INSTANCE.createMap((Map)ImmutableMap.of((Object)tag, (Object)((Tag)object)));
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type net.minecraft.nbt.Tag");
        return new Dynamic(dynamicOps, (Object)((Tag)object2));
    }

    public static final Component effectiveName(@NotNull Entity $this$effectiveName) {
        Intrinsics.checkNotNullParameter((Object)$this$effectiveName, (String)"<this>");
        Component component = $this$effectiveName.getDisplayName();
        if (component == null) {
            component = $this$effectiveName.getName();
        }
        return component;
    }

    public static final boolean hasMemory(@NotNull LivingEntity $this$hasMemory, @NotNull ResourceLocation memoryIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMemory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)memoryIdentifier, (String)"memoryIdentifier");
        DefaultedRegistry registry = BuiltInRegistries.MEMORY_MODULE_TYPE;
        Object object = registry.get(memoryIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        MemoryModuleType memoryType = (MemoryModuleType)object;
        return $this$hasMemory.getBrain().checkMemory(memoryType, MemoryStatus.VALUE_PRESENT);
    }

    public static final boolean hasMemory(@NotNull LivingEntity $this$hasMemory, @NotNull TagKey<MemoryModuleType<?>> tagKey) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$hasMemory, (String)"<this>");
            Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
            DefaultedRegistry registry = BuiltInRegistries.MEMORY_MODULE_TYPE;
            HolderSet.Named named = registry.getTag(tagKey).orElse(null);
            if (named == null) {
                return false;
            }
            HolderSet.Named memoryTypesInTag = named;
            Iterable $this$any$iv = (Iterable)memoryTypesInTag;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Holder it = (Holder)element$iv;
                    boolean bl2 = false;
                    if (!$this$hasMemory.getBrain().checkMemory((MemoryModuleType)it.value(), MemoryStatus.VALUE_PRESENT)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasMemoryFromString(@NotNull LivingEntity $this$hasMemoryFromString, @NotNull String memory) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMemoryFromString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        ResourceKey resourceKey = Registries.MEMORY_MODULE_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"MEMORY_MODULE_TYPE");
        Either key = StringExtensionsKt.asIdentifierOrTag(memory, resourceKey);
        Object object = key.map(arg_0 -> EntityExtensionsKt.hasMemoryFromString$lambda$1(arg_0 -> EntityExtensionsKt.hasMemoryFromString$lambda$0($this$hasMemoryFromString, arg_0), arg_0), arg_0 -> EntityExtensionsKt.hasMemoryFromString$lambda$3(arg_0 -> EntityExtensionsKt.hasMemoryFromString$lambda$2($this$hasMemoryFromString, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map(...)");
        return (Boolean)object;
    }

    public static final void jitterDropItem(@NotNull LivingEntity $this$jitterDropItem, @NotNull ItemEntity itemEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$jitterDropItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
        itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)(($this$jitterDropItem.getRandom().nextFloat() - $this$jitterDropItem.getRandom().nextFloat()) * 0.1f), (double)($this$jitterDropItem.getRandom().nextFloat() * 0.05f), (double)(($this$jitterDropItem.getRandom().nextFloat() - $this$jitterDropItem.getRandom().nextFloat()) * 0.1f)));
    }

    public static final boolean isDoingActivity(@NotNull LivingEntity $this$isDoingActivity, @NotNull ResourceLocation activityIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$isDoingActivity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)activityIdentifier, (String)"activityIdentifier");
        Registry registry = BuiltInRegistries.ACTIVITY;
        Activity activity = (Activity)registry.get(activityIdentifier);
        if (activity == null) {
            return false;
        }
        Activity activity2 = activity;
        return $this$isDoingActivity.getBrain().isActive(activity2);
    }

    public static final boolean isDoingActivity(@NotNull LivingEntity $this$isDoingActivity, @NotNull TagKey<Activity> tagKey) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isDoingActivity, (String)"<this>");
            Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
            Registry registry = BuiltInRegistries.ACTIVITY;
            HolderSet.Named named = registry.getTag(tagKey).orElse(null);
            if (named == null) {
                return false;
            }
            HolderSet.Named activitiesInTag = named;
            Iterable $this$any$iv = (Iterable)activitiesInTag;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Holder it = (Holder)element$iv;
                    boolean bl2 = false;
                    if (!$this$isDoingActivity.getBrain().isActive((Activity)it.value())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isDoingActivityFromString(@NotNull LivingEntity $this$isDoingActivityFromString, @NotNull String activity) {
        Intrinsics.checkNotNullParameter((Object)$this$isDoingActivityFromString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ResourceKey resourceKey = Registries.ACTIVITY;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"ACTIVITY");
        Either key = StringExtensionsKt.asIdentifierOrTag(activity, resourceKey);
        Object object = key.map(arg_0 -> EntityExtensionsKt.isDoingActivityFromString$lambda$1(arg_0 -> EntityExtensionsKt.isDoingActivityFromString$lambda$0($this$isDoingActivityFromString, arg_0), arg_0), arg_0 -> EntityExtensionsKt.isDoingActivityFromString$lambda$3(arg_0 -> EntityExtensionsKt.isDoingActivityFromString$lambda$2($this$isDoingActivityFromString, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map(...)");
        return (Boolean)object;
    }

    private static final int getPosScore(Level level, Entity entity, AABB box, BlockPos pos) {
        AABB movedBox = box.move(new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5).subtract(box.getBottomCenter()));
        Iterable iterable = level.getBlockCollisions(entity, movedBox);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getBlockCollisions(...)");
        return CollectionsKt.count((Iterable)iterable);
    }

    private static final BlockPos findBestBlockPosBFS(Entity entity, Vec3 pos, Level level, int maxRadius) {
        Object[] objectArray = new BlockPos[]{new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)};
        List directions = CollectionsKt.listOf((Object[])objectArray);
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        Set visited = new LinkedHashSet();
        BlockPos centerPos = new BlockPos(pos.x > 0.0 ? (int)pos.x : (int)Math.floor(pos.x), pos.y > 0.0 ? (int)pos.y : (int)Math.floor(pos.y), pos.z > 0.0 ? (int)pos.z : (int)Math.floor(pos.z));
        queue.add(centerPos);
        int bestScore = Integer.MAX_VALUE;
        BlockPos bestPos = centerPos;
        AABB deflatedBox = entity.getBoundingBox();
        int maxHeight = 3;
        int maxWidth = 3;
        if (entity.getBbWidth() > (float)maxWidth) {
            deflatedBox = deflatedBox.deflate((double)(entity.getBbWidth() - (float)maxWidth) / 2.0, 0.0, (double)(entity.getBbWidth() - (float)maxWidth) / 2.0);
        }
        if (entity.getBbHeight() > (float)maxHeight) {
            deflatedBox = deflatedBox.deflate(0.0, (double)(entity.getBbWidth() - (float)maxHeight) / 2.0, 0.0);
        }
        while (!((Collection)queue).isEmpty()) {
            int score;
            boolean blockPosHasCollision;
            BlockPos currentPos = (BlockPos)queue.removeFirst();
            if (visited.contains(currentPos)) continue;
            Intrinsics.checkNotNull((Object)currentPos);
            visited.add(currentPos);
            boolean bl = blockPosHasCollision = !level.getBlockState(currentPos).getCollisionShape((BlockGetter)level, currentPos, CollisionContext.empty()).isEmpty();
            if (blockPosHasCollision) {
                v1 = Integer.MAX_VALUE;
            } else {
                AABB aABB = deflatedBox;
                Intrinsics.checkNotNull((Object)aABB);
                v1 = score = EntityExtensionsKt.getPosScore(level, entity, aABB, currentPos);
            }
            if (score == 0) {
                return currentPos;
            }
            if (bestScore > score) {
                bestPos = currentPos;
                bestScore = score;
            }
            for (BlockPos dir : directions) {
                BlockPos neighbor = currentPos.offset((Vec3i)dir);
                if (neighbor.distManhattan((Vec3i)centerPos) > maxRadius || !blockPosHasCollision && !level.getBlockState(neighbor).getCollisionShape((BlockGetter)level, neighbor, CollisionContext.empty()).isEmpty()) continue;
                queue.add(neighbor);
            }
        }
        return bestPos;
    }

    static /* synthetic */ BlockPos findBestBlockPosBFS$default(Entity entity, Vec3 vec3, Level level, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 4;
        }
        return EntityExtensionsKt.findBestBlockPosBFS(entity, vec3, level, n);
    }

    public static final boolean setPositionSafely(@NotNull Entity $this$setPositionSafely, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)$this$setPositionSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        AABB box = $this$setPositionSafely.getBoundingBox().move(pos.subtract($this$setPositionSafely.getBoundingBox().getBottomCenter()));
        if ($this$setPositionSafely.level().noBlockCollision($this$setPositionSafely, box)) {
            $this$setPositionSafely.setPos(pos);
            return true;
        }
        BlockPos bestBlockPosition = null;
        Vec3 result = null;
        int searchRadius = Math.min((int)Math.ceil($this$setPositionSafely.getBbWidth() * (float)2), 4);
        Level level = $this$setPositionSafely.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        bestBlockPosition = EntityExtensionsKt.findBestBlockPosBFS($this$setPositionSafely, pos, level, searchRadius);
        result = new Vec3((double)bestBlockPosition.getX() + 0.5, (double)bestBlockPosition.getY(), (double)bestBlockPosition.getZ() + 0.5);
        $this$setPositionSafely.setPos(result);
        Vec3 resultEyes = result.with(Direction.Axis.Y, result.y + (double)$this$setPositionSafely.getEyeHeight());
        AABB resultEyeBox = AABB.ofSize((Vec3)resultEyes, (double)$this$setPositionSafely.getBbWidth(), (double)1.0E-6, (double)$this$setPositionSafely.getBbWidth());
        boolean collides = false;
        Iterator iterator = BlockPos.betweenClosedStream((AABB)resultEyeBox).iterator();
        while (iterator.hasNext()) {
            BlockPos target = (BlockPos)iterator.next();
            BlockState blockState = $this$setPositionSafely.level().getBlockState(target);
            collides = !blockState.isAir() && blockState.isSuffocating((BlockGetter)$this$setPositionSafely.level(), target) && Shapes.joinIsNotEmpty((VoxelShape)blockState.getCollisionShape((BlockGetter)$this$setPositionSafely.level(), target).move((double)target.getX(), (double)target.getY(), (double)target.getZ()), (VoxelShape)Shapes.create((AABB)resultEyeBox), (BooleanOp)BooleanOp.AND);
            if (!collides) continue;
        }
        $this$setPositionSafely.setPos(result);
        return !collides;
    }

    public static final boolean isDusk(@NotNull Entity $this$isDusk) {
        Intrinsics.checkNotNullParameter((Object)$this$isDusk, (String)"<this>");
        long time = $this$isDusk.level().getDayTime() % (long)24000;
        return 12000L <= time ? time < 13001L : false;
    }

    public static final boolean isStandingOn(@NotNull Entity $this$isStandingOn, @NotNull Set<String> blocks, int depth) {
        Intrinsics.checkNotNullParameter((Object)$this$isStandingOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        int currentDepth = 1;
        if (currentDepth <= depth) {
            while (true) {
                BlockPos bellowBlockPos = $this$isStandingOn.blockPosition().below(currentDepth);
                BlockState blockState = $this$isStandingOn.level().getBlockState(bellowBlockPos);
                if (!blockState.isAir() && blockState.isCollisionShapeFullBlock((BlockGetter)$this$isStandingOn.level(), bellowBlockPos)) {
                    List elementOrTags = (List)((Pair)ExtraCodecs.TAG_OR_ELEMENT_ID.listOf().decode((DynamicOps)JavaOps.INSTANCE, (Object)CollectionsKt.toList((Iterable)blocks)).result().get()).getFirst();
                    Intrinsics.checkNotNull((Object)elementOrTags);
                    Iterable $this$forEach$iv = elementOrTags;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ExtraCodecs.TagOrElementLocation it = (ExtraCodecs.TagOrElementLocation)element$iv;
                        boolean bl = false;
                        if (!(it.tag() ? blockState.getBlockHolder().is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)it.id())) : blockState.getBlockHolder().is(it.id()))) continue;
                        return true;
                    }
                }
                if (currentDepth == depth) break;
                ++currentDepth;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean isStandingOn$default(Entity entity, Set set, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return EntityExtensionsKt.isStandingOn(entity, set, n);
    }

    public static final double distanceTo(@NotNull Entity $this$distanceTo, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)$this$distanceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Vec3 difference = BlockPosExtensionsKt.toVec3d(pos).subtract($this$distanceTo.position());
        return difference.length();
    }

    @Nullable
    public static final BlockPos closestPosition(@NotNull Entity $this$closestPosition, @NotNull Iterable<? extends BlockPos> positions, @NotNull Function1<? super BlockPos, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)$this$closestPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        BlockPos closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos blockPos : positions) {
            double distance;
            if (!((Boolean)filter.invoke((Object)blockPos)).booleanValue() || !((distance = EntityExtensionsKt.distanceTo($this$closestPosition, blockPos)) < closestDistance)) continue;
            closest = new BlockPos((Vec3i)blockPos);
            closestDistance = distance;
        }
        return closest;
    }

    public static /* synthetic */ BlockPos closestPosition$default(Entity entity, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = EntityExtensionsKt::closestPosition$lambda$0;
        }
        return EntityExtensionsKt.closestPosition(entity, iterable, (Function1<? super BlockPos, Boolean>)function1);
    }

    public static final boolean getIsSubmerged(@NotNull Entity $this$getIsSubmerged) {
        Intrinsics.checkNotNullParameter((Object)$this$getIsSubmerged, (String)"<this>");
        return $this$getIsSubmerged.isInLava() || $this$getIsSubmerged.isUnderWater();
    }

    public static final <T> void update(@NotNull SynchedEntityData $this$update, @NotNull EntityDataAccessor<T> data, @NotNull Function1<? super T, ? extends T> mutator) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"<this>");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        Object value = $this$update.get(data);
        Object newValue = mutator.invoke(value);
        if (!Intrinsics.areEqual((Object)value, (Object)newValue)) {
            $this$update.set(data, newValue);
        }
    }

    private static final Boolean hasMemoryFromString$lambda$0(LivingEntity $this_hasMemoryFromString, ResourceLocation it) {
        Intrinsics.checkNotNull((Object)it);
        return EntityExtensionsKt.hasMemory($this_hasMemoryFromString, it);
    }

    private static final Boolean hasMemoryFromString$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean hasMemoryFromString$lambda$2(LivingEntity $this_hasMemoryFromString, TagKey it) {
        Intrinsics.checkNotNull((Object)it);
        return EntityExtensionsKt.hasMemory($this_hasMemoryFromString, it);
    }

    private static final Boolean hasMemoryFromString$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isDoingActivityFromString$lambda$0(LivingEntity $this_isDoingActivityFromString, ResourceLocation it) {
        Intrinsics.checkNotNull((Object)it);
        return EntityExtensionsKt.isDoingActivity($this_isDoingActivityFromString, it);
    }

    private static final Boolean isDoingActivityFromString$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isDoingActivityFromString$lambda$2(LivingEntity $this_isDoingActivityFromString, TagKey it) {
        Intrinsics.checkNotNull((Object)it);
        return EntityExtensionsKt.isDoingActivity($this_isDoingActivityFromString, (TagKey<Activity>)it);
    }

    private static final Boolean isDoingActivityFromString$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean closestPosition$lambda$0(BlockPos it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

