/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.helditem;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.components.HeldItemEffectComponent;
import com.cobblemon.mod.common.pokemon.helditem.BaseCobblemonHeldItemManager;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0010\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0019\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\n\u0010\u000eJ'\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0015\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u001cJ#\u0010\u001f\u001a\u00020\u00042\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\t0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R(\u0010,\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001d0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/pokemon/helditem/CobblemonHeldItemManager;", "Lcom/cobblemon/mod/common/pokemon/helditem/BaseCobblemonHeldItemManager;", "<init>", "()V", "", "load$common", "load", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "pokemon", "", "showdownId", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)Ljava/lang/String;", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "(Lnet/minecraft/world/item/ItemStack;)Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "battleMessage", "handleStartInstruction", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "handleEndInstruction", "", "shouldConsumeItem", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Ljava/lang/String;)Z", "Lnet/minecraft/world/item/Item;", "item", "registerRemap", "(Lnet/minecraft/world/item/Item;Ljava/lang/String;)V", "Ljava/util/function/Function;", "remap", "registerStackRemap", "(Ljava/util/function/Function;)V", "Lnet/minecraft/network/chat/Component;", "nameOf", "(Ljava/lang/String;)Lnet/minecraft/network/chat/Component;", "", "giveItemEffect", "Ljava/util/Set;", "takeItemEffect", "", "remaps", "Ljava/util/Map;", "", "stackRemaps", "Ljava/util/List;", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonHeldItemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonHeldItemManager.kt\ncom/cobblemon/mod/common/pokemon/helditem/CobblemonHeldItemManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class CobblemonHeldItemManager
extends BaseCobblemonHeldItemManager {
    @NotNull
    public static final CobblemonHeldItemManager INSTANCE = new CobblemonHeldItemManager();
    @NotNull
    private static final Set<String> giveItemEffect;
    @NotNull
    private static final Set<String> takeItemEffect;
    @NotNull
    private static final Map<Item, String> remaps;
    @NotNull
    private static final List<Function<ItemStack, String>> stackRemaps;

    private CobblemonHeldItemManager() {
    }

    @Override
    public void load$common() {
        super.load$common();
        Cobblemon.LOGGER.info("Imported {} held item IDs from showdown", (Object)this.loadedItemCount());
        Item item = Items.BONE;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"BONE");
        this.registerRemap(item, "thickclub");
        Item item2 = Items.SNOWBALL;
        Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"SNOWBALL");
        this.registerRemap(item2, "snowball");
        Item item3 = Items.GOLD_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)item3, (String)"GOLD_BLOCK");
        this.registerRemap(item3, "bignugget");
    }

    @Override
    @Nullable
    public String showdownId(@NotNull BattlePokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        ItemStack itemStack = pokemon.getEffectedPokemon().heldItemNoCopy$common();
        if (itemStack.has(CobblemonItemComponents.HELD_ITEM_EFFECT)) {
            Object object = itemStack.get(CobblemonItemComponents.HELD_ITEM_EFFECT);
            Intrinsics.checkNotNull((Object)object);
            return ((HeldItemEffectComponent)object).getShowdownId();
        }
        if (remaps.containsKey(itemStack.getItem())) {
            return remaps.get(itemStack.getItem());
        }
        for (Function<ItemStack, String> remap : stackRemaps) {
            String id = remap.apply(itemStack);
            if (id == null) continue;
            return id;
        }
        String original = super.showdownId(pokemon);
        if (original == null && pokemon.getEffectedPokemon().heldItemNoCopy$common().isEmpty()) {
            return "";
        }
        return original;
    }

    @Nullable
    public final String showdownId(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (itemStack.has(CobblemonItemComponents.HELD_ITEM_EFFECT)) {
            HeldItemEffectComponent heldItemEffectComponent = (HeldItemEffectComponent)itemStack.get(CobblemonItemComponents.HELD_ITEM_EFFECT);
            return heldItemEffectComponent != null ? heldItemEffectComponent.getShowdownId() : null;
        }
        if (remaps.containsKey(itemStack.getItem())) {
            return remaps.get(itemStack.getItem());
        }
        for (Function<ItemStack, String> remap : stackRemaps) {
            String id = remap.apply(itemStack);
            if (id == null) continue;
            return id;
        }
        Item item = itemStack.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        return this.showdownIdOf(item);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleStartInstruction(@NotNull BattlePokemon pokemon, @NotNull PokemonBattle battle, @NotNull BattleMessage battleMessage) {
        block28: {
            block27: {
                block26: {
                    Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
                    Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                    Intrinsics.checkNotNullParameter((Object)battleMessage, (String)"battleMessage");
                    v0 = battleMessage.effectAt(1);
                    if (v0 == null || (v0 = v0.getId()) == null) {
                        return;
                    }
                    itemID = v0;
                    consumeHeldItems = this.shouldConsumeItem(pokemon, battle, (String)itemID);
                    if (battleMessage.hasOptionalArgument("silent")) {
                        if (consumeHeldItems) {
                            this.take(pokemon, (String)itemID);
                        }
                        return;
                    }
                    effect = BattleMessage.effect$default(battleMessage, null, 1, null);
                    battlerName = pokemon.getName();
                    itemName = this.nameOf((String)itemID);
                    if (effect == null) {
                        var10_9 = new Object[]{battlerName, itemName};
                        v1 = LocalizationUtilsKt.battleLang("item." + (String)itemID, var10_9);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"battleLang(...)");
                        battle.broadcastChatMessage((Component)v1);
                        return;
                    }
                    v2 = BattleMessage.battlePokemonFromOptional$default(battleMessage, battle, null, 2, null);
                    if (v2 == null || (v2 = v2.getName()) == null) {
                        v2 = Component.literal((String)"UNKNOWN");
                    }
                    sourceName = v2;
                    var12_12 = effectId = effect.getId();
                    switch (var12_12.hashCode()) {
                        case 110330838: {
                            if (!var12_12.equals("thief")) {
                                ** break;
                            }
                            ** GOTO lbl56
                        }
                        case -346775423: {
                            if (!var12_12.equals("switcheroo")) {
                                ** break;
                            }
                            break block26;
                        }
                        case 1082880659: {
                            if (var12_12.equals("recycle")) break;
                            ** break;
                        }
                        case -988476804: {
                            if (var12_12.equals("pickup")) break;
                            ** break;
                        }
                        case 110628691: {
                            if (!var12_12.equals("trick")) {
                                ** break;
                            }
                            break block26;
                        }
                        case -69865079: {
                            if (!var12_12.equals("magician")) {
                                ** break;
                            }
                            ** GOTO lbl56
                        }
                        case -1108625161: {
                            if (!var12_12.equals("pickpocket")) {
                                ** break;
                            }
                            ** GOTO lbl56
                        }
                        case 94852025: {
                            if (!var12_12.equals("covet")) ** break;
lbl56:
                            // 4 sources

                            var13_13 = new Object[3];
                            var13_13[0] = battlerName;
                            var13_13[1] = itemName;
                            Intrinsics.checkNotNull((Object)sourceName);
                            var13_13[2] = sourceName;
                            v3 = LocalizationUtilsKt.battleLang("item.thief", var13_13);
                            break block27;
                        }
                    }
                    var13_13 = new Object[]{battlerName, itemName};
                    v3 = LocalizationUtilsKt.battleLang("item.recycle", var13_13);
                    break block27;
                }
                var13_13 = new Object[]{battlerName, itemName};
                v3 = LocalizationUtilsKt.battleLang("item.trick", var13_13);
                break block27;
lbl70:
                // 9 sources

                v4 = "item." + effectId;
                var13_13 = new Object[3];
                var13_13[0] = battlerName;
                var13_13[1] = itemName;
                Intrinsics.checkNotNull((Object)sourceName);
                var13_13[2] = sourceName;
                v3 = LocalizationUtilsKt.battleLang(v4, var13_13);
            }
            text = v3;
            Intrinsics.checkNotNull((Object)text);
            battle.broadcastChatMessage((Component)text);
            if (CobblemonHeldItemManager.takeItemEffect.contains(effectId) && CobblemonHeldItemManager.giveItemEffect.contains(effectId) && !consumeHeldItems) {
                return;
            }
            if (CobblemonHeldItemManager.takeItemEffect.contains(effectId) || CobblemonHeldItemManager.giveItemEffect.contains(effectId)) {
                return;
            }
            if (battle.isPvP() && !consumeHeldItems) {
                return;
            }
            if (battle.isPvN()) {
                return;
            }
            if (CobblemonHeldItemManager.giveItemEffect.contains(effectId) && (pokemon.getActor() instanceof PlayerBattleActor || consumeHeldItems)) {
                this.give(pokemon, (String)itemID);
            }
            if (!CobblemonHeldItemManager.takeItemEffect.contains(effectId) || pokemon.getActor() instanceof PlayerBattleActor && !consumeHeldItems) break block28;
            v5 = BattleMessage.actorAndActivePokemonFromOptional$default(battleMessage, battle, null, 2, null);
            if (v5 != null && (v5 = (ActiveBattlePokemon)v5.getSecond()) != null && (v5 = v5.getBattlePokemon()) != null) {
                it = v5;
                $i$a$-let-CobblemonHeldItemManager$handleStartInstruction$1 = false;
                CobblemonHeldItemManager.INSTANCE.take((BattlePokemon)it, (String)itemID);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleEndInstruction(@NotNull BattlePokemon pokemon, @NotNull PokemonBattle battle, @NotNull BattleMessage battleMessage) {
        block27: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)battleMessage, (String)"battleMessage");
                v0 = battleMessage.effectAt(1);
                if (v0 == null || (v0 = v0.getId()) == null) {
                    return;
                }
                itemID = v0;
                consumeHeldItems = this.shouldConsumeItem(pokemon, battle, (String)itemID);
                if (battleMessage.hasOptionalArgument("silent")) {
                    if (consumeHeldItems) {
                        this.take(pokemon, (String)itemID);
                    }
                    return;
                }
                battlerName = pokemon.getName();
                itemName = this.nameOf((String)itemID);
                if (battleMessage.hasOptionalArgument("eat")) {
                    var9_8 = new Object[]{battlerName, itemName};
                    v1 = LocalizationUtilsKt.battleLang("item.eat", var9_8);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"battleLang(...)");
                    battle.broadcastChatMessage((Component)v1);
                    if (consumeHeldItems) {
                        this.take(pokemon, (String)itemID);
                    }
                    return;
                }
                v2 = BattleMessage.battlePokemonFromOptional$default(battleMessage, battle, null, 2, null);
                if (v2 == null || (v2 = v2.getName()) == null) {
                    v2 = Component.literal((String)"UNKNOWN");
                }
                sourceName = v2;
                effect = BattleMessage.effect$default(battleMessage, null, 1, null);
                v3 = effect;
                if ((v3 != null ? v3.getId() : null) == null) break block26;
                v4 = "enditem." + effect.getId();
                var11_11 = new Object[3];
                var11_11[0] = battlerName;
                var11_11[1] = itemName;
                Intrinsics.checkNotNull((Object)sourceName);
                var11_11[2] = sourceName;
                v5 = LocalizationUtilsKt.battleLang(v4, var11_11);
                break block27;
            }
            var11_11 = itemID;
            switch (var11_11.hashCode()) {
                case 1473685510: {
                    if (!var11_11.equals("psychicseed")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case 1287412621: {
                    if (!var11_11.equals("mistyseed")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case -415204415: {
                    if (!var11_11.equals("weaknesspolicy")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case 987810420: {
                    if (!var11_11.equals("grassyseed")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case -877353088: {
                    if (!var11_11.equals("blunderpolicy")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case 1548556824: {
                    if (!var11_11.equals("boosterenergy")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case 880781690: {
                    if (!var11_11.equals("roomservice")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case -362369778: {
                    if (!var11_11.equals("electricseed")) {
                        break;
                    }
                    ** GOTO lbl76
                }
                case -1273168970: {
                    if (!var11_11.equals("absorbbulb")) break;
lbl76:
                    // 9 sources

                    var12_12 = new Object[]{battlerName, itemName};
                    v5 = LocalizationUtilsKt.battleLang("enditem.generic", var12_12);
                    break block27;
                }
            }
            var12_12 = new Object[]{battlerName};
            v5 = text = LocalizationUtilsKt.battleLang("enditem." + (String)itemID, var12_12);
        }
        if (consumeHeldItems) {
            this.take(pokemon, (String)itemID);
        }
        Intrinsics.checkNotNull((Object)text);
        battle.broadcastChatMessage((Component)text);
    }

    @Override
    public boolean shouldConsumeItem(@NotNull BattlePokemon pokemon, @NotNull PokemonBattle battle, @NotNull String showdownId) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)showdownId, (String)"showdownId");
        ItemStack itemStack = pokemon.getEffectedPokemon().heldItem();
        if (itemStack.has(CobblemonItemComponents.HELD_ITEM_EFFECT)) {
            Object object = itemStack.get(CobblemonItemComponents.HELD_ITEM_EFFECT);
            Intrinsics.checkNotNull((Object)object);
            return ((HeldItemEffectComponent)object).getConsumed();
        }
        TagKey<Item> tag = battle.isPvP() ? CobblemonItemTags.CONSUMED_IN_PVP_BATTLE : (battle.isPvN() ? CobblemonItemTags.CONSUMED_IN_NPC_BATTLE : CobblemonItemTags.CONSUMED_IN_WILD_BATTLE);
        return itemStack.is(tag);
    }

    public final void registerRemap(@NotNull Item item, @NotNull String showdownId) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)showdownId, (String)"showdownId");
        remaps.put(item, showdownId);
    }

    public final void registerStackRemap(@NotNull Function<ItemStack, String> remap) {
        Intrinsics.checkNotNullParameter(remap, (String)"remap");
        stackRemaps.add(remap);
    }

    @Override
    @NotNull
    public Component nameOf(@NotNull String showdownId) {
        Intrinsics.checkNotNullParameter((Object)showdownId, (String)"showdownId");
        for (Map.Entry<Item, String> remap : remaps.entrySet()) {
            if (!Intrinsics.areEqual((Object)remap.getValue(), (Object)showdownId)) continue;
            Component component = remap.getKey().getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getDescription(...)");
            return component;
        }
        return super.nameOf(showdownId);
    }

    static {
        Object[] objectArray = new String[]{"pickup", "recycle", "magician", "pickpocket", "thief", "covet", "harvest", "bestow", "switcheroo", "trick"};
        giveItemEffect = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"magician", "pickpocket", "covet", "bestow"};
        takeItemEffect = SetsKt.setOf((Object[])objectArray);
        remaps = new LinkedHashMap();
        stackRemaps = new ArrayList();
    }
}

