/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.evolution.adapters;

import com.cobblemon.mod.common.util.adapters.CodecBackedAdapter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.advancements.critereon.ItemCustomDataPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019R\"\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00020\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/pokemon/evolution/adapters/LegacyItemConditionWrapperAdapter;", "Lcom/google/gson/JsonDeserializer;", "Lnet/minecraft/advancements/critereon/ItemPredicate;", "Lcom/google/gson/JsonSerializer;", "<init>", "()V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/advancements/critereon/ItemPredicate;", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "serialize", "(Lnet/minecraft/advancements/critereon/ItemPredicate;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;", "", "raw", "Lnet/minecraft/advancements/critereon/ItemPredicate$Builder;", "createBuilderForItem", "(Ljava/lang/String;)Lnet/minecraft/advancements/critereon/ItemPredicate$Builder;", "TAG_PREFIX", "Ljava/lang/String;", "LEGACY_ITEM", "LEGACY_NBT", "Lcom/cobblemon/mod/common/util/adapters/CodecBackedAdapter;", "kotlin.jvm.PlatformType", "codecAdapter", "Lcom/cobblemon/mod/common/util/adapters/CodecBackedAdapter;", "common"})
public final class LegacyItemConditionWrapperAdapter
implements JsonDeserializer<ItemPredicate>,
JsonSerializer<ItemPredicate> {
    @NotNull
    public static final LegacyItemConditionWrapperAdapter INSTANCE = new LegacyItemConditionWrapperAdapter();
    @NotNull
    private static final String TAG_PREFIX = "#";
    @NotNull
    private static final String LEGACY_ITEM = "item";
    @NotNull
    private static final String LEGACY_NBT = "nbt";
    @NotNull
    private static final CodecBackedAdapter<ItemPredicate> codecAdapter;

    private LegacyItemConditionWrapperAdapter() {
    }

    @NotNull
    public ItemPredicate deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        JsonObject jObject;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (json.isJsonPrimitive()) {
            String string = json.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            ItemPredicate itemPredicate = this.createBuilderForItem(string).build();
            Intrinsics.checkNotNullExpressionValue((Object)itemPredicate, (String)"build(...)");
            return itemPredicate;
        }
        if (json.isJsonObject() && (jObject = json.getAsJsonObject()).size() == 2 && jObject.has(LEGACY_ITEM) && jObject.has(LEGACY_NBT)) {
            String string = jObject.get(LEGACY_ITEM).getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            ItemPredicate.Builder builder = this.createBuilderForItem(string);
            NbtPredicate nbtPredicate = (NbtPredicate)((Pair)NbtPredicate.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jObject.get(LEGACY_NBT)).result().get()).getFirst();
            ItemCustomDataPredicate itemCustomDataPredicate = new ItemCustomDataPredicate(nbtPredicate);
            ItemPredicate itemPredicate = builder.withSubPredicate(ItemSubPredicates.CUSTOM_DATA, (ItemSubPredicate)itemCustomDataPredicate).build();
            Intrinsics.checkNotNullExpressionValue((Object)itemPredicate, (String)"build(...)");
            return itemPredicate;
        }
        ItemPredicate itemPredicate = codecAdapter.deserialize(json, typeOfT, context);
        Intrinsics.checkNotNullExpressionValue((Object)itemPredicate, (String)"deserialize(...)");
        return itemPredicate;
    }

    @NotNull
    public JsonElement serialize(@NotNull ItemPredicate src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return codecAdapter.serialize(src, typeOfSrc, context);
    }

    private final ItemPredicate.Builder createBuilderForItem(String raw) {
        String string;
        boolean isTag = StringsKt.startsWith$default((String)raw, (String)TAG_PREFIX, (boolean)false, (int)2, null);
        ItemPredicate.Builder builder = ItemPredicate.Builder.item();
        if (isTag) {
            String string2 = raw.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = raw;
        }
        Object object = ResourceLocation.read((String)string).mapOrElse(arg_0 -> LegacyItemConditionWrapperAdapter.createBuilderForItem$lambda$1(arg_0 -> LegacyItemConditionWrapperAdapter.createBuilderForItem$lambda$0(isTag, builder, arg_0), arg_0), arg_0 -> LegacyItemConditionWrapperAdapter.createBuilderForItem$lambda$3(arg_0 -> LegacyItemConditionWrapperAdapter.createBuilderForItem$lambda$2(builder, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapOrElse(...)");
        return (ItemPredicate.Builder)object;
    }

    private static final ItemPredicate.Builder createBuilderForItem$lambda$0(boolean $isTag, ItemPredicate.Builder $builder, ResourceLocation id) {
        ItemPredicate.Builder builder;
        if ($isTag) {
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
            builder = $builder.of(tag);
        } else {
            builder = BuiltInRegistries.ITEM.getOptional(id).map(arg_0 -> LegacyItemConditionWrapperAdapter.createBuilderForItem$lambda$0$1(arg_0 -> LegacyItemConditionWrapperAdapter.createBuilderForItem$lambda$0$0($builder, arg_0), arg_0)).orElseGet(() -> LegacyItemConditionWrapperAdapter.createBuilderForItem$lambda$0$2($builder));
        }
        return builder;
    }

    private static final ItemPredicate.Builder createBuilderForItem$lambda$0$0(ItemPredicate.Builder $builder, Item it) {
        ItemLike[] itemLikeArray = new ItemLike[]{it};
        return $builder.of(itemLikeArray);
    }

    private static final ItemPredicate.Builder createBuilderForItem$lambda$0$1(Function1 $tmp0, Object p0) {
        return (ItemPredicate.Builder)$tmp0.invoke(p0);
    }

    private static final ItemPredicate.Builder createBuilderForItem$lambda$0$2(ItemPredicate.Builder $builder) {
        return $builder;
    }

    private static final ItemPredicate.Builder createBuilderForItem$lambda$1(Function1 $tmp0, Object p0) {
        return (ItemPredicate.Builder)$tmp0.invoke(p0);
    }

    private static final ItemPredicate.Builder createBuilderForItem$lambda$2(ItemPredicate.Builder $builder, DataResult.Error it) {
        return $builder;
    }

    private static final ItemPredicate.Builder createBuilderForItem$lambda$3(Function1 $tmp0, Object p0) {
        return (ItemPredicate.Builder)$tmp0.invoke(p0);
    }

    static {
        Codec codec = ItemPredicate.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        codecAdapter = new CodecBackedAdapter(codec);
    }
}

