/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.effects;

import com.cobblemon.mod.common.api.pokemon.effect.ShoulderEffect;
import com.cobblemon.mod.common.mixin.accessor.StatusEffectInstanceAccessor;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0001#B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0014\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001e\u001a\u0004\b!\u0010 R\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001e\u001a\u0004\b\"\u0010 \u00a8\u0006$"}, d2={"Lcom/cobblemon/mod/common/pokemon/effects/PotionBaseEffect;", "Lcom/cobblemon/mod/common/api/pokemon/effect/ShoulderEffect;", "Lnet/minecraft/world/effect/MobEffect;", "effect", "", "amplifier", "", "ambient", "showParticles", "showIcon", "<init>", "(Lnet/minecraft/world/effect/MobEffect;IZZZ)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/server/level/ServerPlayer;", "player", "isLeft", "", "applyEffect", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/server/level/ServerPlayer;Z)V", "removeEffect", "Lcom/cobblemon/mod/common/pokemon/effects/PotionBaseEffect$ShoulderStatusEffectInstance;", "createStatus", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/pokemon/effects/PotionBaseEffect$ShoulderStatusEffectInstance;", "Lnet/minecraft/world/effect/MobEffect;", "getEffect", "()Lnet/minecraft/world/effect/MobEffect;", "I", "getAmplifier", "()I", "Z", "getAmbient", "()Z", "getShowParticles", "getShowIcon", "ShoulderStatusEffectInstance", "common"})
public final class PotionBaseEffect
implements ShoulderEffect {
    @NotNull
    private final MobEffect effect;
    private final int amplifier;
    private final boolean ambient;
    private final boolean showParticles;
    private final boolean showIcon;

    public PotionBaseEffect(@NotNull MobEffect effect, int amplifier, boolean ambient, boolean showParticles, boolean showIcon) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        this.effect = effect;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.showParticles = showParticles;
        this.showIcon = showIcon;
    }

    @NotNull
    public final MobEffect getEffect() {
        return this.effect;
    }

    public final int getAmplifier() {
        return this.amplifier;
    }

    public final boolean getAmbient() {
        return this.ambient;
    }

    public final boolean getShowParticles() {
        return this.showParticles;
    }

    public final boolean getShowIcon() {
        return this.showIcon;
    }

    @Override
    public void applyEffect(@NotNull Pokemon pokemon, @NotNull ServerPlayer player, boolean isLeft) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MobEffectInstance effect = player.getEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this.effect));
        if (effect instanceof ShoulderStatusEffectInstance && ((ShoulderStatusEffectInstance)effect).getAmplifier() >= this.amplifier) {
            if (((ShoulderStatusEffectInstance)effect).getAmplifier() == this.amplifier) {
                Set<UUID> set = ((ShoulderStatusEffectInstance)effect).getShoulderSources$common();
                UUID uUID = pokemon.getUuid();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
                set.add(uUID);
            }
            return;
        }
        player.addEffect((MobEffectInstance)this.createStatus(pokemon));
    }

    @Override
    public void removeEffect(@NotNull Pokemon pokemon, @NotNull ServerPlayer player, boolean isLeft) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MobEffectInstance mobEffectInstance = player.getEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this.effect));
        ShoulderStatusEffectInstance shoulderStatusEffectInstance = mobEffectInstance instanceof ShoulderStatusEffectInstance ? (ShoulderStatusEffectInstance)mobEffectInstance : null;
        if (shoulderStatusEffectInstance == null) {
            return;
        }
        ShoulderStatusEffectInstance effect = shoulderStatusEffectInstance;
        if (effect.getAmplifier() == this.amplifier && effect.ambient == this.ambient && effect.isVisible() == this.showParticles && effect.showIcon() == this.showIcon) {
            effect.getShoulderSources$common().remove(pokemon.getUuid());
        }
    }

    private final ShoulderStatusEffectInstance createStatus(Pokemon pokemon) {
        return new ShoulderStatusEffectInstance(this.effect, this.amplifier, this.ambient, this.showParticles, this.showIcon, pokemon);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b!\u0010\"R \u0010%\u001a\b\u0012\u0004\u0012\u00020$0#8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/pokemon/effects/PotionBaseEffect$ShoulderStatusEffectInstance;", "Lnet/minecraft/world/effect/MobEffectInstance;", "Lnet/minecraft/world/effect/MobEffect;", "effect", "", "amplifier", "", "ambient", "showParticles", "showIcon", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "startingPokemon", "<init>", "(Lnet/minecraft/world/effect/MobEffect;IZZZLcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "save", "(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "isInfiniteDuration", "()Z", "that", "update", "(Lnet/minecraft/world/effect/MobEffectInstance;)Z", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Ljava/lang/Runnable;", "overwriteCallback", "tick", "(Lnet/minecraft/world/entity/LivingEntity;Ljava/lang/Runnable;)Z", "", "onEffectStarted", "(Lnet/minecraft/world/entity/LivingEntity;)V", "other", "upgradeFrom", "(Lcom/cobblemon/mod/common/pokemon/effects/PotionBaseEffect$ShoulderStatusEffectInstance;)V", "", "Ljava/util/UUID;", "shoulderSources", "Ljava/util/Set;", "getShoulderSources$common", "()Ljava/util/Set;", "upgrade", "Lnet/minecraft/world/effect/MobEffectInstance;", "common"})
    public static final class ShoulderStatusEffectInstance
    extends MobEffectInstance {
        @NotNull
        private final Set<UUID> shoulderSources;
        @Nullable
        private MobEffectInstance upgrade;

        public ShoulderStatusEffectInstance(@NotNull MobEffect effect, int amplifier, boolean ambient, boolean showParticles, boolean showIcon, @NotNull Pokemon startingPokemon) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)startingPokemon, (String)"startingPokemon");
            super(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), -1, amplifier, ambient, showParticles, showIcon);
            Object[] objectArray = new UUID[1];
            Intrinsics.checkNotNullExpressionValue((Object)startingPokemon.getUuid(), (String)"<get-uuid>(...)");
            this.shoulderSources = SetsKt.hashSetOf((Object[])objectArray);
        }

        @NotNull
        public final Set<UUID> getShoulderSources$common() {
            return this.shoulderSources;
        }

        @NotNull
        public final CompoundTag save(@NotNull CompoundTag nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            nbt.putInt("Id", -999);
            return nbt;
        }

        public boolean isInfiniteDuration() {
            return !((Collection)this.shoulderSources).isEmpty();
        }

        public boolean update(@NotNull MobEffectInstance that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            if (that.getAmplifier() > this.getAmplifier()) {
                if (that instanceof ShoulderStatusEffectInstance) {
                    this.upgradeFrom((ShoulderStatusEffectInstance)that);
                    return true;
                }
                this.upgrade = that;
                return true;
            }
            return false;
        }

        public boolean tick(@NotNull LivingEntity entity, @NotNull Runnable overwriteCallback) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Intrinsics.checkNotNullParameter((Object)overwriteCallback, (String)"overwriteCallback");
                if (((MobEffect)this.getEffect().value()).shouldApplyEffectTickThisTick(entity.tickCount, this.getAmplifier())) {
                    this.onEffectStarted(entity);
                }
                MobEffectInstance mobEffectInstance = this.upgrade;
                if (mobEffectInstance == null) break block2;
                MobEffectInstance it = mobEffectInstance;
                boolean bl = false;
                it.duration += -1;
                if (it.duration == 0) {
                    this.upgrade = null;
                    overwriteCallback.run();
                }
            }
            return !((Collection)this.shoulderSources).isEmpty();
        }

        public void onEffectStarted(@NotNull LivingEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            MobEffectInstance mobEffectInstance = this.upgrade;
            ((MobEffect)this.getEffect().value()).applyEffectTick(entity, mobEffectInstance != null ? mobEffectInstance.getAmplifier() : this.getAmplifier());
        }

        private final void upgradeFrom(ShoulderStatusEffectInstance other) {
            this.shoulderSources.clear();
            CollectionsKt.addAll((Collection)this.shoulderSources, (Iterable)other.shoulderSources);
            this.ambient = other.ambient;
            Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type com.cobblemon.mod.common.mixin.accessor.StatusEffectInstanceAccessor");
            StatusEffectInstanceAccessor accessor = (StatusEffectInstanceAccessor)((Object)this);
            accessor.setAmplifier(other.getAmplifier());
            accessor.setShowIcon(other.showIcon());
            accessor.setShowParticles(other.isVisible());
        }
    }
}

