/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.aspects;

import com.cobblemon.mod.common.CobblemonCosmeticItems;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.aspect.AspectProvider;
import com.cobblemon.mod.common.api.pokemon.aspect.SingleConditionalAspectProvider;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Characteristic;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.aspects.PokemonAspectsKt;
import com.cobblemon.mod.common.pokemon.cosmetic.CosmeticItemDefinition;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\"\u0017\u0010\u0001\u001a\u00020\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0001\u0010\u0002\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0007\u001a\u0004\b\u000b\u0010\t\"\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0007\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/api/pokemon/aspect/SingleConditionalAspectProvider;", "SHINY_ASPECT", "Lcom/cobblemon/mod/common/api/pokemon/aspect/SingleConditionalAspectProvider;", "getSHINY_ASPECT", "()Lcom/cobblemon/mod/common/api/pokemon/aspect/SingleConditionalAspectProvider;", "Lcom/cobblemon/mod/common/api/pokemon/aspect/AspectProvider;", "GENDER_ASPECT", "Lcom/cobblemon/mod/common/api/pokemon/aspect/AspectProvider;", "getGENDER_ASPECT", "()Lcom/cobblemon/mod/common/api/pokemon/aspect/AspectProvider;", "COSMETIC_SLOT_ASPECT", "getCOSMETIC_SLOT_ASPECT", "CHARACTERISTIC_RAINBOW_ASPECT", "getCHARACTERISTIC_RAINBOW_ASPECT", "common"})
public final class PokemonAspectsKt {
    @NotNull
    private static final SingleConditionalAspectProvider SHINY_ASPECT = new SingleConditionalAspectProvider(){
        private final String aspect;
        {
            this.aspect = "shiny";
        }

        public String getAspect() {
            return this.aspect;
        }

        public boolean meetsCondition(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return pokemon.getShiny();
        }

        public boolean meetsCondition(PokemonProperties pokemonProperties) {
            Intrinsics.checkNotNullParameter((Object)pokemonProperties, (String)"pokemonProperties");
            return Intrinsics.areEqual((Object)pokemonProperties.getShiny(), (Object)true);
        }
    };
    @NotNull
    private static final AspectProvider GENDER_ASPECT = new AspectProvider(){

        public final Set<String> getAspectsForGender(Gender gender) {
            Intrinsics.checkNotNullParameter((Object)((Object)gender), (String)"gender");
            return SetsKt.setOf((Object)(switch (GENDER_ASPECT.WhenMappings.$EnumSwitchMapping$0[gender.ordinal()]) {
                case 1 -> "male";
                case 2 -> "female";
                case 3 -> "genderless";
                default -> throw new NoWhenBranchMatchedException();
            }));
        }

        public Set<String> provide(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return this.getAspectsForGender(pokemon.getGender());
        }

        public Set<String> provide(PokemonProperties properties) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
                    object = properties.getGender();
                    if (object == null) break block2;
                    Gender it = object;
                    boolean bl = false;
                    Set<String> set = this.getAspectsForGender(it);
                    object = set;
                    if (set != null) break block3;
                }
                object = SetsKt.emptySet();
            }
            return object;
        }
    };
    @NotNull
    private static final AspectProvider COSMETIC_SLOT_ASPECT = new AspectProvider(){

        public Set<String> provide(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            if (minecraftServer == null) {
                return SetsKt.emptySet();
            }
            MinecraftServer server = minecraftServer;
            if (pokemon.getCosmeticItem().isEmpty()) {
                return SetsKt.emptySet();
            }
            RegistryAccess.Frozen frozen = server.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)frozen, (String)"registryAccess(...)");
            RegistryAccess registryAccess = (RegistryAccess)frozen;
            ItemStack itemStack = pokemon.getCosmeticItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"<get-cosmeticItem>(...)");
            CosmeticItemDefinition cosmeticItem = CobblemonCosmeticItems.findValidCosmeticForPokemonAndItem(registryAccess, pokemon, itemStack);
            Object object = cosmeticItem;
            if (object == null || (object = ((CosmeticItemDefinition)object).getAspects()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
                object = SetsKt.emptySet();
            }
            return object;
        }

        public Set<String> provide(PokemonProperties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            return SetsKt.emptySet();
        }
    };
    @NotNull
    private static final AspectProvider CHARACTERISTIC_RAINBOW_ASPECT = new AspectProvider(){

        public final String calculateColourAspect(Nature nature, Characteristic characteristic) {
            Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
            Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
            Pair pair = TuplesKt.to((Object)nature.getIncreasedStat(), (Object)characteristic.getRelevantStat());
            return Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.ATTACK, (Object)Stats.ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.ATTACK, (Object)Stats.HP)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)Stats.ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPEED, (Object)Stats.DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.DEFENCE, (Object)Stats.SPEED)) ? "rainbow-red" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.ATTACK, (Object)Stats.DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.DEFENCE, (Object)Stats.ATTACK)) ? "rainbow-orange" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.DEFENCE, (Object)Stats.DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.DEFENCE, (Object)Stats.HP)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)Stats.DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.ATTACK, (Object)Stats.SPECIAL_DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_DEFENCE, (Object)Stats.ATTACK)) ? "rainbow-yellow" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.DEFENCE, (Object)Stats.SPECIAL_DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_DEFENCE, (Object)Stats.DEFENCE)) ? "rainbow-lime" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_DEFENCE, (Object)Stats.SPECIAL_DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_DEFENCE, (Object)Stats.HP)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)Stats.SPECIAL_DEFENCE)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.DEFENCE, (Object)Stats.SPECIAL_ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_ATTACK, (Object)Stats.DEFENCE)) ? "rainbow-green" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_DEFENCE, (Object)Stats.SPECIAL_ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_ATTACK, (Object)Stats.SPECIAL_DEFENCE)) ? "rainbow-cyan" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_ATTACK, (Object)Stats.SPECIAL_ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_ATTACK, (Object)Stats.HP)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)Stats.SPECIAL_ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_DEFENCE, (Object)Stats.SPEED)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPEED, (Object)Stats.SPECIAL_DEFENCE)) ? "rainbow-blue" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_ATTACK, (Object)Stats.SPEED)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPEED, (Object)Stats.SPECIAL_ATTACK)) ? "rainbow-purple" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPEED, (Object)Stats.SPEED)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPEED, (Object)Stats.HP)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)Stats.SPEED)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPECIAL_ATTACK, (Object)Stats.ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.ATTACK, (Object)Stats.SPECIAL_ATTACK)) ? "rainbow-magenta" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.SPEED, (Object)Stats.ATTACK)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)Stats.ATTACK, (Object)Stats.SPEED)) ? "rainbow-pink" : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)Stats.HP)) ? "rainbow-light-blue" : null))))))))));
        }

        public Set<String> provide(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            if (!pokemon.getForm().getBehaviour().getCharacteristicRainbow()) {
                return SetsKt.emptySet();
            }
            Characteristic characteristic = pokemon.getCharacteristic();
            String string = this.calculateColourAspect(pokemon.getNature(), characteristic);
            if (string == null) {
                return SetsKt.emptySet();
            }
            return SetsKt.setOf((Object)string);
        }

        public Set<String> provide(PokemonProperties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            return SetsKt.emptySet();
        }
    };

    @NotNull
    public static final SingleConditionalAspectProvider getSHINY_ASPECT() {
        return SHINY_ASPECT;
    }

    @NotNull
    public static final AspectProvider getGENDER_ASPECT() {
        return GENDER_ASPECT;
    }

    @NotNull
    public static final AspectProvider getCOSMETIC_SLOT_ASPECT() {
        return COSMETIC_SLOT_ASPECT;
    }

    @NotNull
    public static final AspectProvider getCHARACTERISTIC_RAINBOW_ASPECT() {
        return CHARACTERISTIC_RAINBOW_ASPECT;
    }
}

