/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.ai;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.entity.OmniPathingEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.PokemonMoveControl;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u0088\u00012\u00020\u0001:\u0002\u0088\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0019\u0010\u0010\u001a\u00020\u000f*\u00020\f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f\u00a2\u0006\u0004\b\u001d\u0010 J\u0015\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\u001c\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b%\u0010&JM\u0010+\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u00122\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010!\u001a\u0004\u0018\u00010\u001cH\u0004\u00a2\u0006\u0004\b+\u0010,J)\u0010-\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b0\u00101J)\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b2\u0010.J3\u00103\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f2\b\u0010/\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b3\u00104J9\u00107\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001c2\u0006\u00106\u001a\u000205H\u0002\u00a2\u0006\u0004\b7\u00108JQ\u0010:\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010*\u001a\u00020)2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u000209H\u0002\u00a2\u0006\u0004\b:\u0010;J1\u0010<\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010@\u001a\u00020\"2\u0006\u0010?\u001a\u00020>H\u0002\u00a2\u0006\u0004\b@\u0010AJ+\u0010E\u001a\u00020\"2\u0006\u0010B\u001a\u00020\u00192\b\u0010C\u001a\u0004\u0018\u00010\u00192\b\u0010D\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010G\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0004\u00a2\u0006\u0004\bG\u0010HJ'\u0010K\u001a\u00020\u001f2\u000e\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190I2\u0006\u0010/\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\bK\u0010LJ\u001f\u0010O\u001a\u00020\"2\b\u0010M\u001a\u0004\u0018\u00010\u00192\u0006\u0010N\u001a\u00020\u0019\u00a2\u0006\u0004\bO\u0010PJ-\u0010R\u001a\u00020\"2\u0006\u0010N\u001a\u00020\u00192\u0016\u0010Q\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00190I\"\u0004\u0018\u00010\u0019\u00a2\u0006\u0004\bR\u0010SJ\u0015\u0010U\u001a\u00020\"2\u0006\u0010T\u001a\u00020\u001c\u00a2\u0006\u0004\bU\u0010$J)\u0010V\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\bV\u0010.J%\u0010W\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f\u00a2\u0006\u0004\bW\u0010XJ/\u0010Z\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\bZ\u0010[J7\u0010]\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010\\\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b]\u0010^J\u0081\u0001\u0010h\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010_\u001a\u00020\u001f2\u0006\u0010`\u001a\u00020\u001f2\u0006\u0010a\u001a\u00020\u001f2\u0006\u0010b\u001a\u00020\"2\u0006\u0010c\u001a\u00020\"2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u001c0d2\u0006\u0010T\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020\u001c0f\u00a2\u0006\u0004\bh\u0010iJ7\u0010j\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\f2\u0006\u0010b\u001a\u00020\"2\u0006\u0010c\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010T\u001a\u00020\u001cH\u0004\u00a2\u0006\u0004\bj\u0010kJ\r\u0010l\u001a\u00020\"\u00a2\u0006\u0004\bl\u0010mJ\r\u0010n\u001a\u00020\"\u00a2\u0006\u0004\bn\u0010mJ\r\u0010o\u001a\u00020\"\u00a2\u0006\u0004\bo\u0010mJ\u0015\u0010r\u001a\u00020\"2\u0006\u0010q\u001a\u00020p\u00a2\u0006\u0004\br\u0010sJ\r\u0010t\u001a\u00020\"\u00a2\u0006\u0004\bt\u0010mJ\r\u0010u\u001a\u00020\"\u00a2\u0006\u0004\bu\u0010mJ\r\u0010v\u001a\u00020\"\u00a2\u0006\u0004\bv\u0010mJ\r\u0010w\u001a\u00020\"\u00a2\u0006\u0004\bw\u0010mR\u001a\u0010y\u001a\b\u0012\u0004\u0012\u00020\u001c0x8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\by\u0010zR\u001a\u0010{\u001a\b\u0012\u0004\u0012\u00020\u000f0x8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b{\u0010zR#\u0010|\u001a\u00020\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0013\n\u0004\b|\u0010}\u001a\u0004\b~\u0010m\"\u0005\b\u007f\u0010\u0080\u0001R0\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u00020\u001c0\u0081\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0082\u0001\u0010\u0083\u0001\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001\"\u0006\b\u0086\u0001\u0010\u0087\u0001\u00a8\u0006\u0089\u0001"}, d2={"Lcom/cobblemon/mod/common/pokemon/ai/OmniPathNodeMaker;", "Lnet/minecraft/world/level/pathfinder/NodeEvaluator;", "<init>", "()V", "Lnet/minecraft/world/level/PathNavigationRegion;", "cachedWorld", "Lnet/minecraft/world/entity/Mob;", "entity", "", "prepare", "(Lnet/minecraft/world/level/PathNavigationRegion;Lnet/minecraft/world/entity/Mob;)V", "done", "Lnet/minecraft/world/level/pathfinder/PathfindingContext;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "getCachedBlockState", "(Lnet/minecraft/world/level/pathfinder/PathfindingContext;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "", "x", "y", "z", "Lnet/minecraft/world/level/pathfinder/Target;", "getTarget", "(DDD)Lnet/minecraft/world/level/pathfinder/Target;", "Lnet/minecraft/world/level/pathfinder/Node;", "getStart", "()Lnet/minecraft/world/level/pathfinder/Node;", "Lnet/minecraft/world/level/pathfinder/PathType;", "getNodeType", "(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/pathfinder/PathType;", "", "(Lnet/minecraft/world/entity/Mob;III)Lnet/minecraft/world/level/pathfinder/PathType;", "pathType", "", "doesBlockHavePartialCollision", "(Lnet/minecraft/world/level/pathfinder/PathType;)Z", "getMobJumpHeight", "()D", "verticalDeltaLimit", "nodeFloorLevel", "Lnet/minecraft/core/Direction;", "direction", "findAcceptedNodeWalk", "(IIIIDLnet/minecraft/core/Direction;Lnet/minecraft/world/level/pathfinder/PathType;)Lnet/minecraft/world/level/pathfinder/Node;", "getBlockedNode", "(III)Lnet/minecraft/world/level/pathfinder/Node;", "node", "canReachWithoutCollision", "(Lnet/minecraft/world/level/pathfinder/Node;)Z", "tryFindFirstGroundNodeBelow", "tryFindFirstNonWaterBelow", "(IIILnet/minecraft/world/level/pathfinder/Node;)Lnet/minecraft/world/level/pathfinder/Node;", "", "malus", "getNodeAndUpdateCostToMax", "(IIILnet/minecraft/world/level/pathfinder/PathType;F)Lnet/minecraft/world/level/pathfinder/Node;", "Lnet/minecraft/core/BlockPos$MutableBlockPos;", "tryJumpOn", "(IIIIDLnet/minecraft/core/Direction;Lnet/minecraft/world/level/pathfinder/PathType;Lnet/minecraft/core/BlockPos$MutableBlockPos;)Lnet/minecraft/world/level/pathfinder/Node;", "getClosedNode", "(IIILnet/minecraft/world/level/pathfinder/PathType;)Lnet/minecraft/world/level/pathfinder/Node;", "Lnet/minecraft/world/phys/AABB;", "boundingBox", "hasCollisions", "(Lnet/minecraft/world/phys/AABB;)Z", "root", "xNode", "zNode", "isDiagonalValidForNonPokemon", "(Lnet/minecraft/world/level/pathfinder/Node;Lnet/minecraft/world/level/pathfinder/Node;Lnet/minecraft/world/level/pathfinder/Node;)Z", "getFloorLevel", "(Lnet/minecraft/core/BlockPos;)D", "", "successors", "getNeighbors", "([Lnet/minecraft/world/level/pathfinder/Node;Lnet/minecraft/world/level/pathfinder/Node;)I", "neighborNode", "pathNode", "hasNotVisited", "(Lnet/minecraft/world/level/pathfinder/Node;Lnet/minecraft/world/level/pathfinder/Node;)Z", "borderNodes", "isAccessibleDiagonal", "(Lnet/minecraft/world/level/pathfinder/Node;[Lnet/minecraft/world/level/pathfinder/Node;)Z", "type", "isValidPathType", "getNode", "addNodePos", "(III)Lnet/minecraft/world/level/pathfinder/PathType;", "pfContext", "getPathType", "(Lnet/minecraft/world/level/pathfinder/PathfindingContext;III)Lnet/minecraft/world/level/pathfinder/PathType;", "mob", "getPathTypeOfMob", "(Lnet/minecraft/world/level/pathfinder/PathfindingContext;IIILnet/minecraft/world/entity/Mob;)Lnet/minecraft/world/level/pathfinder/PathType;", "sizeX", "sizeY", "sizeZ", "canOpenDoors", "canEnterOpenDoors", "Ljava/util/EnumSet;", "nearbyTypes", "", "returnedEarlyPathType", "findNearbyNodeTypes", "(Lnet/minecraft/world/level/pathfinder/PathfindingContext;IIIIIIZZLjava/util/EnumSet;Lnet/minecraft/world/level/pathfinder/PathType;Lnet/minecraft/core/BlockPos;Ljava/util/List;)Lnet/minecraft/world/level/pathfinder/PathType;", "adjustNodeType", "(Lnet/minecraft/world/level/pathfinder/PathfindingContext;ZZLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/pathfinder/PathType;)Lnet/minecraft/world/level/pathfinder/PathType;", "canWalk", "()Z", "canSwimInLava", "canSwimInWater", "Lnet/minecraft/world/level/material/FluidState;", "fluidState", "canSwimUnderFluid", "(Lnet/minecraft/world/level/material/FluidState;)Z", "canPathThroughLeaves", "canWalkOnWater", "canFly", "isOnGround", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "nodePosToType", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "nodePosToState", "canPathThroughFire", "Z", "getCanPathThroughFire", "setCanPathThroughFire", "(Z)V", "Ljava/util/function/Predicate;", "nodeFilter", "Ljava/util/function/Predicate;", "getNodeFilter", "()Ljava/util/function/Predicate;", "setNodeFilter", "(Ljava/util/function/Predicate;)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nOmniPathNodeMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniPathNodeMaker.kt\ncom/cobblemon/mod/common/pokemon/ai/OmniPathNodeMaker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,834:1\n1#2:835\n12767#3,2:836\n12767#3,2:838\n*S KotlinDebug\n*F\n+ 1 OmniPathNodeMaker.kt\ncom/cobblemon/mod/common/pokemon/ai/OmniPathNodeMaker\n*L\n466#1:836,2\n471#1:838,2\n*E\n"})
public final class OmniPathNodeMaker
extends NodeEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Long2ObjectMap<PathType> nodePosToType = (Long2ObjectMap)new Long2ObjectOpenHashMap();
    @NotNull
    private final Long2ObjectMap<BlockState> nodePosToState = (Long2ObjectMap)new Long2ObjectOpenHashMap();
    private boolean canPathThroughFire;
    @NotNull
    private Predicate<PathType> nodeFilter = OmniPathNodeMaker::nodeFilter$lambda$0;
    public static final float MAX_HITBOX_SIZE_FOR_WALKING = 1.6f;
    public static final float MAX_HITBOX_FOR_VERTICAL_NEIGHBOURS = 2.0f;

    public final boolean getCanPathThroughFire() {
        return this.canPathThroughFire;
    }

    public final void setCanPathThroughFire(boolean bl) {
        this.canPathThroughFire = bl;
    }

    @NotNull
    public final Predicate<PathType> getNodeFilter() {
        return this.nodeFilter;
    }

    public final void setNodeFilter(@NotNull Predicate<PathType> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"<set-?>");
        this.nodeFilter = predicate;
    }

    public void prepare(@NotNull PathNavigationRegion cachedWorld, @NotNull Mob entity) {
        Intrinsics.checkNotNullParameter((Object)cachedWorld, (String)"cachedWorld");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.prepare(cachedWorld, entity);
        this.nodePosToType.clear();
        this.nodePosToState.clear();
    }

    public void done() {
        super.done();
        this.nodePosToType.clear();
        this.nodePosToState.clear();
    }

    @NotNull
    public final BlockState getCachedBlockState(@NotNull PathfindingContext $this$getCachedBlockState, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)$this$getCachedBlockState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Object object = this.nodePosToState.computeIfAbsent(pos.asLong(), arg_0 -> OmniPathNodeMaker.getCachedBlockState$lambda$0($this$getCachedBlockState, pos, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        return (BlockState)object;
    }

    @NotNull
    public Target getTarget(double x, double y, double z) {
        return new Target(super.getNode(Mth.floor((double)x), Mth.floor((double)(y + 0.5)), Mth.floor((double)z)));
    }

    @NotNull
    public Node getStart() {
        int x = Mth.floor((double)this.mob.getBoundingBox().minX);
        int y = Mth.floor((double)(this.mob.getBoundingBox().minY + 0.5));
        int z = Mth.floor((double)this.mob.getBoundingBox().minZ);
        Node node = super.getNode(x, y, z);
        Mob mob = this.mob;
        Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
        BlockPos blockPos = node.asBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"asBlockPos(...)");
        node.type = this.getNodeType(mob, blockPos);
        node.costMalus = this.mob.getPathfindingMalus(node.type);
        Intrinsics.checkNotNull((Object)node);
        return node;
    }

    @NotNull
    public final PathType getNodeType(@NotNull Mob entity, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.getNodeType(entity, pos.getX(), pos.getY(), pos.getZ());
    }

    @NotNull
    public final PathType getNodeType(@NotNull Mob entity, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = this.nodePosToType.computeIfAbsent(BlockPos.asLong((int)x, (int)y, (int)z), arg_0 -> OmniPathNodeMaker.getNodeType$lambda$0(this, x, y, z, entity, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        return (PathType)object;
    }

    public final boolean doesBlockHavePartialCollision(@NotNull PathType pathType) {
        Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
        return pathType == PathType.FENCE || pathType == PathType.DOOR_WOOD_CLOSED || pathType == PathType.DOOR_IRON_CLOSED;
    }

    private final double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.maxUpStep());
    }

    @Nullable
    protected final Node findAcceptedNodeWalk(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, @Nullable Direction direction, @Nullable PathType pathType) {
        Node node;
        Node node2 = null;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableBlockPos2 = mutableBlockPos.set(x, y, z);
        Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos2, (String)"set(...)");
        double d = this.getFloorLevel((BlockPos)mutableBlockPos2);
        if (!this.canFly() && d - nodeFloorLevel > this.getMobJumpHeight()) {
            node = null;
        } else {
            boolean bl;
            float f;
            Mob mob = this.mob;
            Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
            PathType pathType2 = this.getNodeType(mob, x, y, z);
            if (pathType2 == PathType.WALKABLE && direction == Direction.UP) {
                pathType2 = PathType.OPEN;
            }
            if ((f = this.mob.getPathfindingMalus(pathType2)) >= 0.0f) {
                node2 = this.getNodeAndUpdateCostToMax(x, y, z, pathType2, f);
            }
            PathType pathType3 = pathType;
            if (pathType3 != null) {
                PathType it = pathType3;
                boolean bl2 = false;
                bl = this.doesBlockHavePartialCollision(it);
            } else {
                bl = false;
            }
            if (bl && node2 != null && node2.costMalus >= 0.0f && !this.canReachWithoutCollision(node2)) {
                node2 = null;
            }
            if (pathType2 != PathType.WALKABLE) {
                if ((node2 == null || node2.costMalus < 0.0f) && verticalDeltaLimit > 0 && (pathType2 != PathType.FENCE || this.canWalkOverFences()) && pathType2 != PathType.UNPASSABLE_RAIL && pathType2 != PathType.TRAPDOOR && pathType2 != PathType.POWDER_SNOW) {
                    Direction direction2 = direction;
                    Intrinsics.checkNotNull((Object)direction2);
                    PathType pathType4 = pathType;
                    Intrinsics.checkNotNull((Object)pathType4);
                    node2 = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction2, pathType4, mutableBlockPos);
                } else if (pathType2 == PathType.WATER && !this.canFloat()) {
                    node2 = this.tryFindFirstNonWaterBelow(x, y, z, node2);
                } else if (pathType2 == PathType.OPEN) {
                    node2 = this.tryFindFirstGroundNodeBelow(x, y, z);
                } else if (this.doesBlockHavePartialCollision(pathType2) && node2 == null) {
                    node2 = this.getClosedNode(x, y, z, pathType2);
                }
                node = node2;
            } else {
                node = node2;
            }
        }
        return node;
    }

    private final Node getBlockedNode(int x, int y, int z) {
        Node node = this.getNode(x, y, z);
        if (node == null) {
            return null;
        }
        Node node2 = node;
        node2.type = PathType.BLOCKED;
        node2.costMalus = -1.0f;
        return node2;
    }

    private final boolean canReachWithoutCollision(Node node) {
        AABB aABB = this.mob.getBoundingBox();
        Vec3 vec3 = new Vec3((double)node.x - this.mob.getX() + aABB.getXsize() / 2.0, (double)node.y - this.mob.getY() + aABB.getYsize() / 2.0, (double)node.z - this.mob.getZ() + aABB.getZsize() / 2.0);
        int i = Mth.ceil((double)(vec3.length() / aABB.getSize()));
        Vec3 vec32 = vec3.scale((double)(1.0f / (float)i));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"scale(...)");
        vec3 = vec32;
        int j = 1;
        if (j <= i) {
            while (true) {
                AABB aABB2 = aABB = aABB.move(vec3);
                Intrinsics.checkNotNull((Object)aABB2);
                if (this.hasCollisions(aABB2)) {
                    return false;
                }
                if (j == i) break;
                ++j;
            }
        }
        return true;
    }

    private final Node tryFindFirstGroundNodeBelow(int x, int y, int z) {
        int i = y - 1;
        int n = this.mob.level().getMinBuildHeight();
        if (n <= i) {
            while (true) {
                if (y - i > this.mob.getMaxFallDistance()) {
                    return this.getBlockedNode(x, i, z);
                }
                Mob mob = this.mob;
                Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
                PathType pathType = this.getNodeType(mob, x, i, z);
                float f = this.mob.getPathfindingMalus(pathType);
                if (pathType != PathType.OPEN) {
                    return f >= 0.0f ? this.getNodeAndUpdateCostToMax(x, i, z, pathType, f) : this.getBlockedNode(x, i, z);
                }
                if (i == n) break;
                --i;
            }
        }
        return this.getBlockedNode(x, y, z);
    }

    private final Node tryFindFirstNonWaterBelow(int x, int y, int z, Node node) {
        int y2 = y;
        Node node2 = node;
        --y2;
        while (y2 > this.mob.level().getMinBuildHeight()) {
            Mob mob = this.mob;
            Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
            PathType pathType = this.getNodeType(mob, x, y2, z);
            if (pathType != PathType.WATER) {
                return node2;
            }
            node2 = this.getNodeAndUpdateCostToMax(x, y2, z, pathType, this.mob.getPathfindingMalus(pathType));
            --y2;
        }
        return node2;
    }

    private final Node getNodeAndUpdateCostToMax(int x, int y, int z, PathType pathType, float malus) {
        Node node = this.getNode(x, y, z);
        if (node == null && (node = super.getNode(x, y, z)) == null) {
            return null;
        }
        Node node2 = node;
        node2.type = pathType;
        node2.costMalus = (float)Math.max((double)node2.costMalus, (double)malus);
        return node2;
    }

    private final Node tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType, BlockPos.MutableBlockPos pos) {
        Object object;
        Node node = this.findAcceptedNodeWalk(x, y + 1, z, verticalDeltaLimit - 1, nodeFloorLevel, direction, pathType);
        if (node == null) {
            object = null;
        } else if (this.mob.getBbWidth() >= 1.0f) {
            object = node;
        } else if (node.type != PathType.OPEN && node.type != PathType.WALKABLE) {
            object = node;
        } else {
            double d = (double)(x - direction.getStepX()) + 0.5;
            double e = (double)(z - direction.getStepZ()) + 0.5;
            double f = (double)this.mob.getBbWidth() / 2.0;
            BlockPos.MutableBlockPos mutableBlockPos = pos.set(d, (double)(y + 1), e);
            Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"set(...)");
            double d2 = this.getFloorLevel((BlockPos)mutableBlockPos) + 0.001;
            double d3 = this.mob.getBbHeight();
            BlockPos.MutableBlockPos mutableBlockPos2 = pos.set((double)node.x, (double)node.y, (double)node.z);
            Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos2, (String)"set(...)");
            AABB aABB = new AABB(d - f, d2, e - f, d + f, d3 + this.getFloorLevel((BlockPos)mutableBlockPos2) - 0.002, e + f);
            object = this.hasCollisions(aABB) ? null : node;
        }
        return object;
    }

    private final Node getClosedNode(int x, int y, int z, PathType pathType) {
        Node node = this.getNode(x, y, z);
        if (node == null) {
            return null;
        }
        Node node2 = node;
        node2.closed = true;
        node2.type = pathType;
        node2.costMalus = pathType.getMalus();
        return node2;
    }

    private final boolean hasCollisions(AABB boundingBox) {
        return !this.currentContext.level().noCollision((Entity)this.mob, boundingBox);
    }

    private final boolean isDiagonalValidForNonPokemon(Node root, Node xNode, Node zNode) {
        if (this.mob.getMoveControl() instanceof PokemonMoveControl) {
            return true;
        }
        if (zNode != null && xNode != null && zNode.y <= root.y && xNode.y <= root.y) {
            if (xNode.type != PathType.WALKABLE_DOOR && zNode.type != PathType.WALKABLE_DOOR) {
                boolean bl = zNode.type == PathType.FENCE && xNode.type == PathType.FENCE && (double)this.mob.getBbWidth() < 0.5;
                return (zNode.y < root.y || zNode.costMalus >= 0.0f || bl) && (xNode.y < root.y || xNode.costMalus >= 0.0f || bl);
            }
            return false;
        }
        return false;
    }

    protected final double getFloorLevel(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CollisionGetter collisionGetter = this.currentContext.level();
        Intrinsics.checkNotNullExpressionValue((Object)collisionGetter, (String)"level(...)");
        BlockGetter blockGetter = (BlockGetter)collisionGetter;
        if (this.canFloat() && blockGetter.getFluidState(pos).is(FluidTags.WATER)) {
            return (double)pos.getY() + 0.5;
        }
        return this.canFloat() && blockGetter.getFluidState(pos).is(FluidTags.WATER) ? (double)pos.getY() + 0.5 : WalkNodeEvaluator.getFloorLevel((BlockGetter)blockGetter, (BlockPos)pos);
    }

    public int getNeighbors(@NotNull Node[] successors, @NotNull Node node) {
        Node[] pathNode2;
        Object direction2;
        Intrinsics.checkNotNullParameter((Object)successors, (String)"successors");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        EnumMap upperMap = Maps.newEnumMap(Direction.class);
        EnumMap lowerMap = Maps.newEnumMap(Direction.class);
        double d = this.getFloorLevel(new BlockPos(node.x, node.y, node.z));
        boolean strictlyWalkPathing = !this.canFly() && !this.mob.isInWater() && this.mob.getBoundingBox().getSize() < (double)1.6f;
        boolean doVerticalNeighbourChecks = (this.canFly() || this.mob.isInWater()) && this.mob.getBoundingBox().getSize() < 2.0;
        for (Object direction2 : EntriesMappings.entries$0) {
            Node pathNode = null;
            if (!strictlyWalkPathing) {
                Node node2 = this.getNode(node.x + direction2.getStepX(), node.y + direction2.getStepY(), node.z + direction2.getStepZ());
                if (node2 == null) continue;
                pathNode = node2;
            } else {
                Node node3 = this.findAcceptedNodeWalk(node.x + direction2.getStepX(), node.y + direction2.getStepY(), node.z + direction2.getStepZ(), direction2 == Direction.DOWN || direction2 == Direction.UP ? 0 : 1, d, (Direction)direction2, node.type);
                if (node3 == null) continue;
                pathNode = node3;
            }
            Intrinsics.checkNotNull((Object)map);
            ((Map)map).put(direction2, pathNode);
            if (!this.hasNotVisited(pathNode, node)) continue;
            successors[i++] = pathNode;
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            direction2 = (Direction)iterator2.next();
            Direction direction2 = direction2.getClockWise();
            int x = node.x + direction2.getStepX() + direction2.getStepX();
            int z = node.z + direction2.getStepZ() + direction2.getStepZ();
            pathNode2 = null;
            if (!strictlyWalkPathing) {
                Node[] nodeArray = this.getNode(x, node.y, z);
                if (nodeArray == null) continue;
                pathNode2 = nodeArray;
            } else {
                Node node4 = this.findAcceptedNodeWalk(x, node.y, z, direction2 == Direction.DOWN || direction2 == Direction.UP ? 0 : 1, d, (Direction)direction2, node.type);
                if (node4 == null) continue;
                pathNode2 = node4;
            }
            Node[] nodeArray = new Node[]{map.get(direction2), map.get(direction2)};
            if (!this.isAccessibleDiagonal((Node)pathNode2, nodeArray) && (node.type != PathType.BLOCKED || pathNode2.closed) || !this.isDiagonalValidForNonPokemon(node, (Node)map.get(direction2), (Node)map.get(direction2))) continue;
            successors[i++] = pathNode2;
        }
        if (doVerticalNeighbourChecks) {
            Node[] pathNode22;
            Object direction3;
            Mob mob = this.mob;
            Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
            Entity entity = (Entity)mob;
            BlockPos blockPos = node.asBlockPos().above();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
            boolean upIsOpen = WorldExtensionsKt.canFit(entity, blockPos);
            Iterator iterator3 = Direction.Plane.HORIZONTAL.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"iterator(...)");
            direction2 = iterator3;
            while (direction2.hasNext()) {
                direction3 = (Direction)direction2.next();
                Node pathNode23 = null;
                Node node5 = this.getNode(node.x + direction3.getStepX(), node.y + 1, node.z + direction3.getStepZ());
                if (node5 == null) continue;
                pathNode23 = node5;
                if (!upIsOpen || !this.hasNotVisited(pathNode23, node)) continue;
                successors[i++] = pathNode23;
                Intrinsics.checkNotNull((Object)upperMap);
                ((Map)upperMap).put(direction3, pathNode23);
            }
            Iterator iterator4 = Direction.Plane.HORIZONTAL.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator4, (String)"iterator(...)");
            direction2 = iterator4;
            while (direction2.hasNext()) {
                direction3 = (Direction)direction2.next();
                Direction direction2 = direction3.getClockWise();
                Node pathNode24 = null;
                Node node6 = this.getNode(node.x + direction3.getStepX() + direction2.getStepX(), node.y + 1, node.z + direction3.getStepZ() + direction2.getStepZ());
                if (node6 == null) continue;
                pathNode24 = node6;
                pathNode2 = new Node[]{upperMap.get(direction3), upperMap.get(direction2)};
                if (!this.isAccessibleDiagonal(pathNode24, pathNode2)) continue;
                successors[i++] = pathNode24;
            }
            BlockPos.MutableBlockPos connectingBlockPos = new BlockPos.MutableBlockPos();
            Iterator iterator5 = Direction.Plane.HORIZONTAL.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator5, (String)"iterator(...)");
            direction3 = iterator5;
            while (direction3.hasNext()) {
                Direction direction4 = (Direction)direction3.next();
                connectingBlockPos.set((Vec3i)node.asBlockPos().offset(direction4.getNormal()));
                PathfindingContext pathfindingContext = this.currentContext;
                Intrinsics.checkNotNullExpressionValue((Object)pathfindingContext, (String)"currentContext");
                BlockState blockState = this.getCachedBlockState(pathfindingContext, (BlockPos)connectingBlockPos);
                boolean traversableByTangent = blockState.isPathfindable(PathComputationType.AIR);
                if (this.getNode(node.x + direction4.getStepX(), node.y - 1, node.z + direction4.getStepZ()) == null || !this.hasNotVisited((Node)pathNode22, node) || !traversableByTangent) continue;
                successors[i++] = pathNode22;
                Intrinsics.checkNotNull((Object)lowerMap);
                ((Map)lowerMap).put(direction4, pathNode22);
            }
            Iterator iterator6 = Direction.Plane.HORIZONTAL.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator6, (String)"iterator(...)");
            direction3 = iterator6;
            while (direction3.hasNext()) {
                Node pathNode25;
                Direction direction5 = (Direction)direction3.next();
                Direction direction2 = direction5.getClockWise();
                if (this.getNode(node.x + direction5.getStepX() + direction2.getStepX(), node.y - 1, node.z + direction5.getStepZ() + direction2.getStepZ()) == null) continue;
                pathNode22 = new Node[]{lowerMap.get(direction5), lowerMap.get(direction2)};
                if (!this.isAccessibleDiagonal(pathNode25, pathNode22)) continue;
                successors[i++] = pathNode25;
            }
        }
        if (this.mob.getPathfindingMalus(node.type) < 0.0f && i > 1) {
            double x = this.mob.getBoundingBox().minX;
            double y = this.mob.getBoundingBox().minY + 0.5;
            double z = this.mob.getBoundingBox().minZ;
            Vec3 pos = new Vec3(x, y, z);
            Node node7 = successors[0];
            Intrinsics.checkNotNull((Object)node7);
            Node closestSuccessor = node7;
            double closestDistance = closestSuccessor.asVec3().add(0.5, 0.0, 0.5).distanceTo(pos);
            for (int n = 1; n < i; ++n) {
                Node next;
                Intrinsics.checkNotNull((Object)successors[n]);
                double nextDist = next.asVec3().add(0.5, 0.0, 0.5).distanceTo(pos);
                if (!(nextDist < closestDistance)) continue;
                closestSuccessor = next;
                closestDistance = nextDist;
            }
            successors[0] = closestSuccessor;
            i = 1;
        }
        return i;
    }

    public final boolean hasNotVisited(@Nullable Node neighborNode, @NotNull Node pathNode) {
        Intrinsics.checkNotNullParameter((Object)pathNode, (String)"pathNode");
        return neighborNode != null && !neighborNode.closed && (neighborNode.costMalus >= 0.0f || pathNode.costMalus < 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAccessibleDiagonal(@NotNull Node pathNode, Node ... borderNodes) {
        Node it;
        Node element$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)pathNode, (String)"pathNode");
        Intrinsics.checkNotNullParameter((Object)borderNodes, (String)"borderNodes");
        Node[] $this$all$iv = borderNodes;
        boolean $i$f$all = false;
        int n2 = $this$all$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$all$iv[n];
            boolean bl = false;
            if (it == null) return false;
            if (!this.hasNotVisited(pathNode, it)) return false;
            boolean bl2 = true;
            if (bl2) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        $this$all$iv = borderNodes;
        $i$f$all = false;
        n = 0;
        n2 = $this$all$iv.length;
        while (n < n2) {
            it = element$iv = $this$all$iv[n];
            boolean bl3 = false;
            if (it == null) return false;
            if (!(it.costMalus >= 0.0f)) return false;
            boolean bl4 = true;
            if (!bl4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean isValidPathType(@NotNull PathType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!this.nodeFilter.test(type)) {
            return false;
        }
        return (type == PathType.BREACH || type == PathType.WATER || type == PathType.WATER_BORDER) && this.canSwimInWater() ? true : (type == PathType.LAVA && this.canSwimInLava() ? true : (type == PathType.OPEN && this.canFly() ? true : type == PathType.WALKABLE && (this.canWalk() || this.canFly())));
    }

    @Nullable
    protected Node getNode(int x, int y, int z) {
        float nodePenalty = 0.0f;
        Node pathNode = null;
        PathType type = this.addNodePos(x, y, z);
        if (this.isValidPathType(type)) {
            float f;
            float it = f = this.mob.getPathfindingMalus(type);
            boolean bl = false;
            nodePenalty = it;
            if (f >= 0.0f) {
                Node node;
                Node it2 = node = super.getNode(x, y, z);
                boolean bl2 = false;
                pathNode = it2;
                if (node != null) {
                    Intrinsics.checkNotNull((Object)pathNode);
                    pathNode.type = type;
                    pathNode.costMalus = RangesKt.coerceAtLeast((float)pathNode.costMalus, (float)nodePenalty);
                }
            }
        }
        return pathNode;
    }

    @NotNull
    public final PathType addNodePos(int x, int y, int z) {
        Object object = this.nodePosToType.computeIfAbsent(BlockPos.asLong((int)x, (int)y, (int)z), arg_0 -> OmniPathNodeMaker.addNodePos$lambda$0(this, x, y, z, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        return (PathType)object;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public PathType getPathType(@NotNull PathfindingContext pfContext, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)pfContext, (String)"pfContext");
        pos = new BlockPos(x, y, z);
        below = new BlockPos(x, y - 1, z);
        blockState = this.getCachedBlockState(pfContext, pos);
        blockStateBelow = this.getCachedBlockState(pfContext, below);
        isFluid = blockState.getFluidState().isEmpty() == false;
        isWater = isFluid != false && blockState.getFluidState().is(FluidTags.WATER) != false;
        v0 = isLava = isFluid != false && isWater == false && blockState.getFluidState().is(FluidTags.LAVA) != false;
        if (!isFluid) ** GOTO lbl-1000
        v1 = blockState.getFluidState();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getFluidState(...)");
        if (this.canSwimUnderFluid(v1)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        canBreatheUnderFluid = v2;
        belowSolid = blockStateBelow.isSolid();
        solid = blockState.isSolid();
        figuredNode = belowSolid != false && (blockStateBelow.is(BlockTags.FENCES) != false || blockStateBelow.is(BlockTags.WALLS) != false || blockStateBelow.getBlock() instanceof FenceGateBlock != false && (Boolean)blockStateBelow.getValue((Property)FenceGateBlock.OPEN) == false) ? PathType.FENCE : (isWater != false && belowSolid != false && this.canSwimInWater() == false && canBreatheUnderFluid != false ? PathType.WALKABLE : (isWater != false || isLava != false && this.canSwimInLava() != false ? PathType.WATER : (solid == false && belowSolid != false ? PathType.WALKABLE : (solid == false && belowSolid == false ? PathType.OPEN : PathType.BLOCKED))));
        return this.adjustNodeType(pfContext, this.canOpenDoors, this.canPassDoors, below, figuredNode);
    }

    @NotNull
    public PathType getPathTypeOfMob(@NotNull PathfindingContext pfContext, int x, int y, int z, @NotNull Mob mob) {
        PathType pathType;
        Intrinsics.checkNotNullParameter((Object)pfContext, (String)"pfContext");
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        EnumSet<PathType> set = EnumSet.noneOf(PathType.class);
        int sizeX = (int)(mob.getBoundingBox().maxX - mob.getBoundingBox().minX) + 1;
        int sizeY = (int)(mob.getBoundingBox().maxY - mob.getBoundingBox().minY) + 1;
        int sizeZ = (int)(mob.getBoundingBox().maxZ - mob.getBoundingBox().minZ) + 1;
        List returnedEarlyPathType = new ArrayList();
        Intrinsics.checkNotNull(set);
        PathType type = this.findNearbyNodeTypes(pfContext, x, y, z, sizeX, sizeY, sizeZ, this.canOpenDoors, this.canPassDoors, set, PathType.BLOCKED, new BlockPos(x, y, z), returnedEarlyPathType);
        if (set.contains(PathType.LEAVES)) {
            return PathType.OPEN;
        }
        if (set.contains(PathType.FENCE)) {
            return PathType.FENCE;
        }
        if (set.contains(PathType.DAMAGE_CAUTIOUS)) {
            return PathType.DAMAGE_CAUTIOUS;
        }
        if (set.contains(PathType.DANGER_OTHER)) {
            return PathType.DANGER_OTHER;
        }
        if (set.contains(PathType.UNPASSABLE_RAIL)) {
            pathType = PathType.UNPASSABLE_RAIL;
        } else if (set.contains(PathType.DAMAGE_OTHER)) {
            pathType = PathType.DAMAGE_OTHER;
        } else {
            PathType result = (PathType)CollectionsKt.firstOrNull((List)returnedEarlyPathType);
            if (result != null) {
                return result;
            }
            PathType pathType2 = PathType.BLOCKED;
            Iterator iterator = set.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator nearbyTypeIterator = iterator;
            while (nearbyTypeIterator.hasNext()) {
                PathType nearbyType = (PathType)nearbyTypeIterator.next();
                if (mob.getPathfindingMalus(nearbyType) > mob.getPathfindingMalus(pathType2) || nearbyType == PathType.WALKABLE) {
                    Intrinsics.checkNotNull((Object)nearbyType);
                    pathType2 = nearbyType;
                    continue;
                }
                if (type != PathType.WATER || nearbyType != PathType.WATER) continue;
                pathType2 = PathType.WATER;
            }
            pathType = type == PathType.OPEN && mob.getPathfindingMalus(pathType2) == 0.0f && sizeX <= 1 ? PathType.OPEN : pathType2;
        }
        return pathType;
    }

    @NotNull
    public final PathType findNearbyNodeTypes(@NotNull PathfindingContext pfContext, int x, int y, int z, int sizeX, int sizeY, int sizeZ, boolean canOpenDoors, boolean canEnterOpenDoors, @NotNull EnumSet<PathType> nearbyTypes, @NotNull PathType type, @NotNull BlockPos pos, @NotNull List<PathType> returnedEarlyPathType) {
        Intrinsics.checkNotNullParameter((Object)pfContext, (String)"pfContext");
        Intrinsics.checkNotNullParameter(nearbyTypes, (String)"nearbyTypes");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(returnedEarlyPathType, (String)"returnedEarlyPathType");
        PathType type2 = type;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    int l = i + x;
                    int m = j + y;
                    int n = k + z;
                    PathType currentType = this.getPathType(pfContext, l, m, n);
                    if (i == 0 && j == 0 && k == 0 && currentType != null) {
                        type2 = currentType;
                    }
                    nearbyTypes.add(currentType);
                    switch (WhenMappings.$EnumSwitchMapping$0[currentType.ordinal()]) {
                        case 1: {
                            return type2;
                        }
                        case 2: {
                            return type2;
                        }
                        case 3: {
                            return type2;
                        }
                        case 4: {
                            return type2;
                        }
                        case 5: {
                            return type2;
                        }
                    }
                    if (!(this.mob.getPathfindingMalus(currentType) < 0.0f)) continue;
                    returnedEarlyPathType.add(currentType);
                    return currentType;
                }
            }
        }
        return type2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final PathType adjustNodeType(@NotNull PathfindingContext pfContext, boolean canOpenDoors, boolean canEnterOpenDoors, @NotNull BlockPos pos, @NotNull PathType type) {
        PathType pathType;
        Intrinsics.checkNotNullParameter((Object)pfContext, (String)"pfContext");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        BlockState blockState = this.getCachedBlockState(pfContext, pos);
        if (blockState.isAir() && type != PathType.RAIL) {
            return PathType.OPEN;
        }
        Block block = blockState.getBlock();
        if (blockState.is(Blocks.CACTUS)) return PathType.DANGER_OTHER;
        if (blockState.is(Blocks.SWEET_BERRY_BUSH)) {
            return PathType.DANGER_OTHER;
        }
        if (NodeEvaluator.isBurningBlock((BlockState)blockState) && !this.canPathThroughFire) {
            if (!blockState.is(Blocks.MAGMA_BLOCK)) return PathType.DANGER_FIRE;
            if (this.isOnGround()) {
                return PathType.DANGER_FIRE;
            }
        }
        if (blockState.is(Blocks.WITHER_ROSE)) return PathType.DAMAGE_CAUTIOUS;
        if (blockState.is(Blocks.POINTED_DRIPSTONE)) {
            return PathType.DAMAGE_CAUTIOUS;
        }
        if (type == PathType.DOOR_WOOD_CLOSED && canOpenDoors && canEnterOpenDoors) {
            pathType = PathType.WALKABLE_DOOR;
            return pathType;
        }
        if (type == PathType.DOOR_OPEN && !canEnterOpenDoors) {
            pathType = PathType.BLOCKED;
            return pathType;
        }
        if (type == PathType.RAIL && !(block instanceof BaseRailBlock)) {
            BlockPos blockPos = pos.below();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"below(...)");
            if (!(this.getCachedBlockState(pfContext, blockPos).getBlock() instanceof BaseRailBlock)) {
                pathType = PathType.UNPASSABLE_RAIL;
                return pathType;
            }
        }
        if (type != PathType.LEAVES) {
            pathType = type;
            return pathType;
        }
        if (blockState.getBlock() == CobblemonBlocks.SACCHARINE_LEAVES && this.canPathThroughLeaves()) {
            pathType = PathType.OPEN;
            return pathType;
        }
        pathType = PathType.BLOCKED;
        return pathType;
    }

    public final boolean canWalk() {
        boolean bl;
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).canWalk();
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean canSwimInLava() {
        boolean bl;
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).canSwimInLava();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean canSwimInWater() {
        boolean bl;
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).canSwimInWater();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean canSwimUnderFluid(@NotNull FluidState fluidState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).canSwimUnderFluid(fluidState);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean canPathThroughLeaves() {
        boolean bl;
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).canPathThroughSaccLeaves();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean canWalkOnWater() {
        boolean bl;
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).canWalkOnWater();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean canFly() {
        boolean bl;
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).canFly();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isOnGround() {
        boolean bl;
        if (this.mob instanceof OmniPathingEntity) {
            Mob mob = this.mob;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.OmniPathingEntity");
            bl = ((OmniPathingEntity)mob).entityOnGround();
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean nodeFilter$lambda$0(PathType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final BlockState getCachedBlockState$lambda$0(PathfindingContext $this_getCachedBlockState, BlockPos $pos, long it) {
        return $this_getCachedBlockState.getBlockState($pos);
    }

    private static final PathType getNodeType$lambda$0(OmniPathNodeMaker this$0, int $x, int $y, int $z, Mob $entity, long it) {
        PathfindingContext pathfindingContext = this$0.currentContext;
        Intrinsics.checkNotNullExpressionValue((Object)pathfindingContext, (String)"currentContext");
        return this$0.getPathTypeOfMob(pathfindingContext, $x, $y, $z, $entity);
    }

    private static final PathType addNodePos$lambda$0(OmniPathNodeMaker this$0, int $x, int $y, int $z, long it) {
        PathfindingContext pathfindingContext = this$0.currentContext;
        Intrinsics.checkNotNullExpressionValue((Object)pathfindingContext, (String)"currentContext");
        Mob mob = this$0.mob;
        Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
        return this$0.getPathTypeOfMob(pathfindingContext, $x, $y, $z, mob);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/cobblemon/mod/common/pokemon/ai/OmniPathNodeMaker$Companion;", "", "<init>", "()V", "", "MAX_HITBOX_SIZE_FOR_WALKING", "F", "MAX_HITBOX_FOR_VERTICAL_NEIGHBOURS", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathType.values().length];
            try {
                nArray[PathType.FENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.LEAVES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.DAMAGE_CAUTIOUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.UNPASSABLE_RAIL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.DAMAGE_OTHER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

