/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.serverhandling.trade;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.net.messages.server.trade.CancelTradePacket;
import com.cobblemon.mod.common.net.messages.server.trade.UpdateTradeOfferPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.trade.TradeParticipant;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/net/serverhandling/trade/UpdateTradeOfferHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/cobblemon/mod/common/net/messages/server/trade/UpdateTradeOfferPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lcom/cobblemon/mod/common/net/messages/server/trade/UpdateTradeOfferPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "common"})
public final class UpdateTradeOfferHandler
implements ServerNetworkPacketHandler<UpdateTradeOfferPacket> {
    @NotNull
    public static final UpdateTradeOfferHandler INSTANCE = new UpdateTradeOfferHandler();

    private UpdateTradeOfferHandler() {
    }

    @Override
    public void handle(@NotNull UpdateTradeOfferPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ActiveTrade activeTrade = TradeManager.INSTANCE.getActiveTrade(uUID);
        if (activeTrade == null) {
            CobblemonNetwork.INSTANCE.sendPacket(player, new CancelTradePacket());
            return;
        }
        ActiveTrade trade = activeTrade;
        UUID uUID2 = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        TradeParticipant tradeParticipant = trade.getTradeParticipant(uUID2);
        Pair<UUID, PartyPosition> newOffer = packet.getNewOffer();
        if (newOffer == null) {
            trade.updateOffer(tradeParticipant, null);
        } else {
            Pair<UUID, PartyPosition> pair = newOffer;
            UUID pokemonId = (UUID)pair.component1();
            PartyPosition partyPosition = (PartyPosition)pair.component2();
            PlayerPartyStore party = PlayerExtensionsKt.party(player);
            Pokemon pokemon = party.get(partyPosition);
            if (pokemon == null || !Intrinsics.areEqual((Object)pokemon.getUuid(), (Object)pokemonId)) {
                return;
            }
            if (!pokemon.getTradeable()) {
                return;
            }
            trade.updateOffer(tradeParticipant, pokemon);
        }
    }
}

