/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.trade;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.net.IntSize;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001f\u001eB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u00198\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "Ljava/util/UUID;", "traderId", "Lnet/minecraft/network/chat/MutableComponent;", "traderName", "", "Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon;", "traderParty", "<init>", "(Ljava/util/UUID;Lnet/minecraft/network/chat/MutableComponent;Ljava/util/List;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "Ljava/util/UUID;", "getTraderId", "()Ljava/util/UUID;", "Lnet/minecraft/network/chat/MutableComponent;", "getTraderName", "()Lnet/minecraft/network/chat/MutableComponent;", "Ljava/util/List;", "getTraderParty", "()Ljava/util/List;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Companion", "TradeablePokemon", "common"})
public final class TradeStartedPacket
implements NetworkPacket<TradeStartedPacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID traderId;
    @NotNull
    private final MutableComponent traderName;
    @NotNull
    private final List<TradeablePokemon> traderParty;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private static final ResourceLocation ID = MiscUtilsKt.cobblemonResource("trade_started");

    public TradeStartedPacket(@NotNull UUID traderId, @NotNull MutableComponent traderName, @NotNull List<TradeablePokemon> traderParty) {
        Intrinsics.checkNotNullParameter((Object)traderId, (String)"traderId");
        Intrinsics.checkNotNullParameter((Object)traderName, (String)"traderName");
        Intrinsics.checkNotNullParameter(traderParty, (String)"traderParty");
        this.traderId = traderId;
        this.traderName = traderName;
        this.traderParty = traderParty;
        this.id = ID;
    }

    @NotNull
    public final UUID getTraderId() {
        return this.traderId;
    }

    @NotNull
    public final MutableComponent getTraderName() {
        return this.traderName;
    }

    @NotNull
    public final List<TradeablePokemon> getTraderParty() {
        return this.traderParty;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeUUID(this.traderId);
        BufferUtilsKt.writeText(buffer, (Component)this.traderName);
        buffer.writeCollection((Collection)this.traderParty, (arg_0, arg_1) -> TradeStartedPacket.encode$lambda$1((arg_0, arg_1) -> TradeStartedPacket.encode$lambda$0(buffer, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Unit encode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, TradeablePokemon v) {
        $buffer.writeNullable((Object)v, (arg_0, arg_1) -> TradeStartedPacket.encode$lambda$0$1((arg_0, arg_1) -> TradeStartedPacket.encode$lambda$0$0($buffer, arg_0, arg_1), arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit encode$lambda$0$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, TradeablePokemon v2) {
        v2.encode($buffer);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$0$1(Function2 $tmp0, Object object, TradeablePokemon object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final void encode$lambda$1(Function2 $tmp0, Object object, TradeablePokemon object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket;", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket;", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public final TradeStartedPacket decode(@NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            UUID uUID = buffer.readUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
            MutableComponent mutableComponent = BufferUtilsKt.readText(buffer).copy();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
            List list = buffer.readList(arg_0 -> Companion.decode$lambda$1(arg_0 -> Companion.decode$lambda$0(buffer, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
            return new TradeStartedPacket(uUID, mutableComponent, list);
        }

        private static final TradeablePokemon decode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
            return (TradeablePokemon)$buffer.readNullable(arg_0 -> Companion.decode$lambda$0$1(arg_0 -> Companion.decode$lambda$0$0($buffer, arg_0), arg_0));
        }

        private static final TradeablePokemon decode$lambda$0$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
            return TradeablePokemon.Companion.decode($buffer);
        }

        private static final TradeablePokemon decode$lambda$0$1(Function1 $tmp0, Object object) {
            return (TradeablePokemon)$tmp0.invoke(object);
        }

        private static final TradeablePokemon decode$lambda$1(Function1 $tmp0, Object object) {
            return (TradeablePokemon)$tmp0.invoke(object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 32\u00020\u0001:\u00013BE\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012B\u0011\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0011\u0010\u0015J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010#R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010-\u001a\u0004\b.\u0010/R\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u00100\u001a\u0004\b1\u00102\u00a8\u00064"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon;", "", "Ljava/util/UUID;", "pokemonId", "Lnet/minecraft/resources/ResourceLocation;", "species", "", "", "aspects", "", "level", "Lcom/cobblemon/mod/common/pokemon/Gender;", "gender", "Lnet/minecraft/world/item/ItemStack;", "heldItem", "", "tradeable", "<init>", "(Ljava/util/UUID;Lnet/minecraft/resources/ResourceLocation;Ljava/util/Set;ILcom/cobblemon/mod/common/pokemon/Gender;Lnet/minecraft/world/item/ItemStack;Z)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "Lcom/cobblemon/mod/common/pokemon/RenderablePokemon;", "asRenderablePokemon", "()Lcom/cobblemon/mod/common/pokemon/RenderablePokemon;", "Ljava/util/UUID;", "getPokemonId", "()Ljava/util/UUID;", "Lnet/minecraft/resources/ResourceLocation;", "getSpecies", "()Lnet/minecraft/resources/ResourceLocation;", "Ljava/util/Set;", "getAspects", "()Ljava/util/Set;", "I", "getLevel", "()I", "Lcom/cobblemon/mod/common/pokemon/Gender;", "getGender", "()Lcom/cobblemon/mod/common/pokemon/Gender;", "Lnet/minecraft/world/item/ItemStack;", "getHeldItem", "()Lnet/minecraft/world/item/ItemStack;", "Z", "getTradeable", "()Z", "Companion", "common"})
    public static final class TradeablePokemon {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UUID pokemonId;
        @NotNull
        private final ResourceLocation species;
        @NotNull
        private final Set<String> aspects;
        private final int level;
        @NotNull
        private final Gender gender;
        @NotNull
        private final ItemStack heldItem;
        private final boolean tradeable;

        public TradeablePokemon(@NotNull UUID pokemonId, @NotNull ResourceLocation species, @NotNull Set<String> aspects2, int level, @NotNull Gender gender, @NotNull ItemStack heldItem, boolean tradeable) {
            Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
            Intrinsics.checkNotNullParameter((Object)species, (String)"species");
            Intrinsics.checkNotNullParameter(aspects2, (String)"aspects");
            Intrinsics.checkNotNullParameter((Object)((Object)gender), (String)"gender");
            Intrinsics.checkNotNullParameter((Object)heldItem, (String)"heldItem");
            this.pokemonId = pokemonId;
            this.species = species;
            this.aspects = aspects2;
            this.level = level;
            this.gender = gender;
            this.heldItem = heldItem;
            this.tradeable = tradeable;
        }

        @NotNull
        public final UUID getPokemonId() {
            return this.pokemonId;
        }

        @NotNull
        public final ResourceLocation getSpecies() {
            return this.species;
        }

        @NotNull
        public final Set<String> getAspects() {
            return this.aspects;
        }

        public final int getLevel() {
            return this.level;
        }

        @NotNull
        public final Gender getGender() {
            return this.gender;
        }

        @NotNull
        public final ItemStack getHeldItem() {
            return this.heldItem;
        }

        public final boolean getTradeable() {
            return this.tradeable;
        }

        public TradeablePokemon(@NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            ResourceLocation resourceLocation = pokemon.getSpecies().getResourceIdentifier();
            Set<String> set = pokemon.getAspects();
            int n = pokemon.getLevel();
            Gender gender = pokemon.getGender();
            ItemStack itemStack = pokemon.heldItem().copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            this(uUID, resourceLocation, set, n, gender, itemStack, pokemon.getTradeable());
        }

        public final void encode(@NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.writeUUID(this.pokemonId);
            BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.species);
            buffer.writeCollection((Collection)this.aspects, (arg_0, arg_1) -> TradeablePokemon.encode$lambda$1((arg_0, arg_1) -> TradeablePokemon.encode$lambda$0(buffer, arg_0, arg_1), arg_0, arg_1));
            NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_SHORT, this.level);
            NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, this.gender.ordinal());
            BufferUtilsKt.writeItemStack(buffer, this.heldItem);
            buffer.writeBoolean(this.tradeable);
        }

        @NotNull
        public final RenderablePokemon asRenderablePokemon() {
            Species species = PokemonSpecies.getByIdentifier(this.species);
            Intrinsics.checkNotNull((Object)species);
            return new RenderablePokemon(species, this.aspects, null, 4, null);
        }

        private static final Unit encode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, String v) {
            ByteBuf byteBuf = (ByteBuf)$buffer;
            Intrinsics.checkNotNull((Object)v);
            BufferUtilsKt.writeString(byteBuf, v);
            return Unit.INSTANCE;
        }

        private static final void encode$lambda$1(Function2 $tmp0, Object object, String object2) {
            $tmp0.invoke(object, (Object)object2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon;", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/net/messages/client/trade/TradeStartedPacket$TradeablePokemon;", "common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TradeablePokemon decode(@NotNull RegistryFriendlyByteBuf buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                UUID uUID = buffer.readUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
                ResourceLocation resourceLocation = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
                List list = buffer.readList(arg_0 -> Companion.decode$lambda$1(Companion::decode$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
                return new TradeablePokemon(uUID, resourceLocation, CollectionsKt.toSet((Iterable)list), NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_SHORT), Gender.values()[NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_BYTE)], BufferUtilsKt.readItemStack(buffer), buffer.readBoolean());
            }

            private static final String decode$lambda$0(FriendlyByteBuf it) {
                Intrinsics.checkNotNull((Object)it);
                return BufferUtilsKt.readString((ByteBuf)it);
            }

            private static final String decode$lambda$1(Function1 $tmp0, Object object) {
                return (String)$tmp0.invoke(object);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

