/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.storage.pc;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.net.UnsplittablePacket;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001 B-\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/storage/pc/SetPCPokemonPacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "Lcom/cobblemon/mod/common/api/net/UnsplittablePacket;", "Ljava/util/UUID;", "storeID", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "storePosition", "Lkotlin/Function1;", "Lnet/minecraft/core/RegistryAccess;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "<init>", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lkotlin/jvm/functions/Function1;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "Ljava/util/UUID;", "getStoreID", "()Ljava/util/UUID;", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "getStorePosition", "()Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "Lkotlin/jvm/functions/Function1;", "getPokemon", "()Lkotlin/jvm/functions/Function1;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Companion", "common"})
public final class SetPCPokemonPacket
implements NetworkPacket<SetPCPokemonPacket>,
UnsplittablePacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID storeID;
    @NotNull
    private final PCPosition storePosition;
    @NotNull
    private final Function1<RegistryAccess, Pokemon> pokemon;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private static final ResourceLocation ID = MiscUtilsKt.cobblemonResource("set_pc_pokemon");

    public SetPCPokemonPacket(@NotNull UUID storeID, @NotNull PCPosition storePosition, @NotNull Function1<? super RegistryAccess, ? extends Pokemon> pokemon) {
        Intrinsics.checkNotNullParameter((Object)storeID, (String)"storeID");
        Intrinsics.checkNotNullParameter((Object)storePosition, (String)"storePosition");
        Intrinsics.checkNotNullParameter(pokemon, (String)"pokemon");
        this.storeID = storeID;
        this.storePosition = storePosition;
        this.pokemon = pokemon;
        this.id = ID;
    }

    @NotNull
    public final UUID getStoreID() {
        return this.storeID;
    }

    @NotNull
    public final PCPosition getStorePosition() {
        return this.storePosition;
    }

    @NotNull
    public final Function1<RegistryAccess, Pokemon> getPokemon() {
        return this.pokemon;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeUUID(this.storeID);
        BufferUtilsKt.writePCPosition((ByteBuf)buffer, this.storePosition);
        StreamCodec<RegistryFriendlyByteBuf, Pokemon> streamCodec = Pokemon.Companion.getS2C_CODEC();
        RegistryAccess registryAccess = buffer.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        streamCodec.encode((Object)buffer, this.pokemon.invoke((Object)registryAccess));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/storage/pc/SetPCPokemonPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/net/messages/client/storage/pc/SetPCPokemonPacket;", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/net/messages/client/storage/pc/SetPCPokemonPacket;", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public final SetPCPokemonPacket decode(@NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            UUID uuid = buffer.readUUID();
            PCPosition position = BufferUtilsKt.readPCPosition((ByteBuf)buffer);
            ByteBuf bufferCache = buffer.readBytes(buffer.readableBytes());
            Intrinsics.checkNotNull((Object)uuid);
            return new SetPCPokemonPacket(uuid, position, (Function1<? super RegistryAccess, ? extends Pokemon>)((Function1)arg_0 -> Companion.decode$lambda$0(bufferCache, arg_0)));
        }

        private static final Pokemon decode$lambda$0(ByteBuf $bufferCache, RegistryAccess it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Pokemon pokemon = (Pokemon)Pokemon.Companion.getS2C_CODEC().decode((Object)new RegistryFriendlyByteBuf($bufferCache, it));
            $bufferCache.release();
            Intrinsics.checkNotNull((Object)pokemon);
            return pokemon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

