/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.battle;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.ChallengeManager;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001*B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fB)\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001b\u0010\u001aR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020%8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleChallengeNotificationPacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "Ljava/util/UUID;", "challengeID", "senderID", "", "challengerIDs", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "", "expiryTime", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/util/List;Lcom/cobblemon/mod/common/battles/BattleFormat;I)V", "battleChallengeId", "challengerId", "(Ljava/util/UUID;Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/BattleFormat;I)V", "Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;", "challenge", "(Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "Ljava/util/UUID;", "getChallengeID", "()Ljava/util/UUID;", "getSenderID", "Ljava/util/List;", "getChallengerIDs", "()Ljava/util/List;", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "getBattleFormat", "()Lcom/cobblemon/mod/common/battles/BattleFormat;", "I", "getExpiryTime", "()I", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Companion", "common"})
public final class BattleChallengeNotificationPacket
implements NetworkPacket<BattleChallengeNotificationPacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID challengeID;
    @NotNull
    private final UUID senderID;
    @NotNull
    private final List<UUID> challengerIDs;
    @NotNull
    private final BattleFormat battleFormat;
    private final int expiryTime;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private static final ResourceLocation ID = MiscUtilsKt.cobblemonResource("battle_challenge_notification");

    public BattleChallengeNotificationPacket(@NotNull UUID challengeID, @NotNull UUID senderID, @NotNull List<UUID> challengerIDs, @NotNull BattleFormat battleFormat, int expiryTime) {
        Intrinsics.checkNotNullParameter((Object)challengeID, (String)"challengeID");
        Intrinsics.checkNotNullParameter((Object)senderID, (String)"senderID");
        Intrinsics.checkNotNullParameter(challengerIDs, (String)"challengerIDs");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        this.challengeID = challengeID;
        this.senderID = senderID;
        this.challengerIDs = challengerIDs;
        this.battleFormat = battleFormat;
        this.expiryTime = expiryTime;
        this.id = ID;
    }

    @NotNull
    public final UUID getChallengeID() {
        return this.challengeID;
    }

    @NotNull
    public final UUID getSenderID() {
        return this.senderID;
    }

    @NotNull
    public final List<UUID> getChallengerIDs() {
        return this.challengerIDs;
    }

    @NotNull
    public final BattleFormat getBattleFormat() {
        return this.battleFormat;
    }

    public final int getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    public BattleChallengeNotificationPacket(@NotNull UUID battleChallengeId, @NotNull UUID challengerId, @NotNull BattleFormat battleFormat, int expiryTime) {
        Intrinsics.checkNotNullParameter((Object)battleChallengeId, (String)"battleChallengeId");
        Intrinsics.checkNotNullParameter((Object)challengerId, (String)"challengerId");
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"battleFormat");
        this(battleChallengeId, challengerId, CollectionsKt.listOf((Object)challengerId), battleFormat, expiryTime);
    }

    public BattleChallengeNotificationPacket(@NotNull ChallengeManager.BattleChallenge challenge) {
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        this(challenge.getRequestID(), challenge.getSenderID(), challenge instanceof ChallengeManager.MultiBattleChallenge ? ((ChallengeManager.MultiBattleChallenge)challenge).getSenderTeam().getTeamPlayersUUID() : CollectionsKt.listOf((Object)challenge.getSenderID()), challenge.getBattleFormat(), challenge.getExpiryTime());
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeUUID(this.challengeID);
        buffer.writeUUID(this.senderID);
        buffer.writeCollection((Collection)this.challengerIDs, (arg_0, arg_1) -> BattleChallengeNotificationPacket.encode$lambda$1((arg_0, arg_1) -> BattleChallengeNotificationPacket.encode$lambda$0(buffer, arg_0, arg_1), arg_0, arg_1));
        this.battleFormat.saveToBuffer(buffer);
        buffer.writeInt(this.expiryTime);
    }

    private static final Unit encode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, UUID value) {
        $buffer.writeUUID(value);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$1(Function2 $tmp0, Object object, UUID object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleChallengeNotificationPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/net/messages/client/battle/BattleChallengeNotificationPacket;", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleChallengeNotificationPacket;", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public final BattleChallengeNotificationPacket decode(@NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            UUID uUID = buffer.readUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
            UUID uUID2 = buffer.readUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"readUUID(...)");
            List list = buffer.readList(arg_0 -> Companion.decode$lambda$1(Companion::decode$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
            return new BattleChallengeNotificationPacket(uUID, uUID2, list, BattleFormat.Companion.loadFromBuffer(buffer), buffer.readInt());
        }

        private static final UUID decode$lambda$0(FriendlyByteBuf it) {
            return it.readUUID();
        }

        private static final UUID decode$lambda$1(Function1 $tmp0, Object object) {
            return (UUID)$tmp0.invoke(object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

