/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeCollection.class})
public class RecipeCollectionMixin {
    @Shadow
    @Final
    private Set<RecipeHolder<?>> fitsDimensions;
    @Shadow
    @Final
    private Set<RecipeHolder<?>> craftable;
    @Shadow
    @Final
    private List<RecipeHolder<?>> recipes;

    @Inject(method={"canCraft(Lnet/minecraft/world/entity/player/StackedContents;IILnet/minecraft/stats/RecipeBook;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void customCanCraft(StackedContents handler, int width, int height, RecipeBook book, CallbackInfo ci) {
        for (RecipeHolder<?> recipeHolder : this.recipes) {
            boolean bl;
            boolean bl2 = bl = recipeHolder.value().canCraftInDimensions(width, height) && book.contains(recipeHolder);
            if (bl) {
                this.fitsDimensions.add(recipeHolder);
            } else {
                this.fitsDimensions.remove(recipeHolder);
            }
            if (bl && handler.canCraft(recipeHolder.value(), null)) {
                this.craftable.add(recipeHolder);
                continue;
            }
            this.craftable.remove(recipeHolder);
        }
        ci.cancel();
    }
}

