/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.ModAPI;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.item.PokedexItem;
import com.cobblemon.mod.common.item.WearableItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Unique
    private final String MODEL_PATH = Cobblemon.implementation != null && Cobblemon.implementation.getModAPI() == ModAPI.FABRIC ? "fabric_resource" : "standalone";
    @Shadow
    @Final
    private ItemModelShaper itemModelShaper;

    @Shadow
    public abstract void render(ItemStack var1, ItemDisplayContext var2, boolean var3, PoseStack var4, MultiBufferSource var5, int var6, int var7, BakedModel var8);

    @Inject(method={"render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$overrideItemModel(ItemStack stack, ItemDisplayContext renderMode, boolean leftHanded, PoseStack matrices, MultiBufferSource multiBufferSource, int light, int overlay, BakedModel model, CallbackInfo ci) {
        BakedModel replacementModel;
        Item item;
        boolean shouldBe2d = renderMode == ItemDisplayContext.GUI || renderMode == ItemDisplayContext.FIXED;
        ResourceLocation resourceLocation = null;
        if (shouldBe2d) {
            Item item2 = stack.getItem();
            if (item2 instanceof PokeBallItem) {
                PokeBallItem pokeBallItem = (PokeBallItem)item2;
                resourceLocation = pokeBallItem.getPokeBall().getModel2d();
            } else {
                item2 = stack.getItem();
                if (item2 instanceof PokedexItem) {
                    PokedexItem pokedexItem = (PokedexItem)item2;
                    resourceLocation = pokedexItem.getType().getItemSpritePath();
                }
            }
        }
        if (renderMode != ItemDisplayContext.HEAD && (item = stack.getItem()) instanceof WearableItem) {
            WearableItem wearableItem = (WearableItem)item;
            resourceLocation = wearableItem.getModel2d();
        }
        if (resourceLocation != null && !ItemRendererMixin.cobblemon$isSameModel(model, replacementModel = this.itemModelShaper.getModelManager().getModel(new ModelResourceLocation(resourceLocation, "inventory")))) {
            ci.cancel();
            this.render(stack, renderMode, leftHanded, matrices, multiBufferSource, light, overlay, replacementModel);
        }
    }

    @Inject(method={"getModel(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$getItemModel(ItemStack stack, Level world, LivingEntity entity, int seed, CallbackInfoReturnable<BakedModel> cir) {
        ResourceLocation resourceLocation = null;
        Item item = stack.getItem();
        if (item instanceof PokeBallItem) {
            PokeBallItem pokeBallItem = (PokeBallItem)item;
            resourceLocation = pokeBallItem.getPokeBall().getModel3d();
        } else {
            item = stack.getItem();
            if (item instanceof PokedexItem) {
                PokedexItem pokedexItem = (PokedexItem)item;
                boolean isScanModel = entity instanceof Player && entity.getUseItem() == stack && entity.isUsingItem();
                boolean canOpenScreen = entity != null && (entity.getOffhandItem() == stack && !(entity.getMainHandItem().getItem() instanceof PokedexItem) || entity.getMainHandItem() == stack);
                resourceLocation = pokedexItem.getType().getItemModelPath((String)(isScanModel ? "scanning" : (canOpenScreen ? null : "off")));
            } else {
                item = stack.getItem();
                if (item instanceof WearableItem) {
                    WearableItem wearableItem = (WearableItem)item;
                    resourceLocation = wearableItem.getModel3d();
                }
            }
        }
        if (resourceLocation != null) {
            BakedModel model = this.itemModelShaper.getModelManager().getModel(new ModelResourceLocation(resourceLocation, this.MODEL_PATH));
            ClientLevel clientWorld = world instanceof ClientLevel ? (ClientLevel)world : null;
            BakedModel overriddenModel = model.getOverrides().resolve(model, stack, clientWorld, entity, seed);
            cir.setReturnValue((Object)(overriddenModel == null ? this.itemModelShaper.getModelManager().getMissingModel() : overriddenModel));
        }
    }

    @Unique
    private static boolean cobblemon$isSameModel(BakedModel original, BakedModel replacement) {
        return original.equals((Object)replacement) || original.getParticleIcon().contents().name().equals((Object)replacement.getParticleIcon().contents().name()) && original.getParticleIcon().contents().width() == replacement.getParticleIcon().contents().width() && original.getParticleIcon().contents().height() == replacement.getParticleIcon().contents().height();
    }
}

