/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.client.render.player.MountedPlayerRenderer;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin {
    @Shadow
    @Final
    public ModelPart head;
    @Shadow
    @Final
    public ModelPart hat;
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart rightLeg;
    @Shadow
    @Final
    public ModelPart leftLeg;
    @Shadow
    @Final
    public ModelPart body;

    @Inject(method={"setupAnim*"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;copyFrom(Lnet/minecraft/client/model/geom/ModelPart;)V", shift=At.Shift.BEFORE)})
    public void cobblemon$animateRiders(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        Entity vehicle;
        MountedPlayerRenderer.shouldApplyRootAnimation = false;
        if (MountedPlayerRenderer.relevantPartsByName.size() <= 1) {
            MountedPlayerRenderer.relevantPartsByName.put("arm_left", this.leftArm);
            MountedPlayerRenderer.relevantPartsByName.put("arm_right", this.rightArm);
            MountedPlayerRenderer.relevantPartsByName.put("leg_left", this.leftLeg);
            MountedPlayerRenderer.relevantPartsByName.put("leg_right", this.rightLeg);
            MountedPlayerRenderer.relevantPartsByName.put("head", this.head);
            MountedPlayerRenderer.relevantPartsByName.put("hat", this.hat);
            MountedPlayerRenderer.relevantPartsByName.put("torso", this.body);
        }
        if ((vehicle = entity.getVehicle()) instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)vehicle;
            if (entity instanceof OrientationControllable) {
                Boolean shouldRotatePlayerHead = pokemonEntity.ifRidingAvailableSupply(false, (behaviour, settings, state) -> behaviour.shouldRotateRiderHead(settings, state, pokemonEntity));
                if (!shouldRotatePlayerHead.booleanValue()) {
                    netHeadYaw = 0.0f;
                    headPitch = 0.0f;
                    if (this.head != null) {
                        this.head.yRot = 0.0f;
                        this.head.xRot = 0.0f;
                    }
                }
                if (!(entity instanceof AbstractClientPlayer)) {
                    return;
                }
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                MountedPlayerRenderer.shouldApplyRootAnimation = true;
                MountedPlayerRenderer.INSTANCE.animate((HumanoidModel<AbstractClientPlayer>)((HumanoidModel)this), pokemonEntity, player, netHeadYaw, headPitch, ageInTicks, limbSwing, limbSwingAmount);
            }
        }
    }
}

