/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import com.cobblemon.mod.common.api.scheduling.ClientTaskTracker;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Predicate;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Unique
    long lastTime = -1L;

    @Inject(method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, at={@At(value="TAIL")})
    public void render(DeltaTracker counter, boolean tick, CallbackInfo ci) {
        Minecraft client = Minecraft.getInstance();
        long newTime = System.currentTimeMillis();
        if (client.isPaused()) {
            this.lastTime = newTime;
            return;
        }
        if (this.lastTime != -1L) {
            ClientTaskTracker.INSTANCE.update((float)(newTime - this.lastTime) / 1000.0f);
        }
        this.lastTime = newTime;
    }

    @ModifyArg(method={"pick(Lnet/minecraft/world/entity/Entity;DDF)Lnet/minecraft/world/phys/HitResult;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"), index=4)
    private Predicate<Entity> filterPokemonVehicle(Predicate<Entity> original, @Local(ordinal=0, argsOnly=true) Entity entity) {
        return entityX -> (entity.getVehicle() != entityX || !(entityX instanceof PokemonEntity)) && original.test((Entity)entityX);
    }
}

