/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.world.CobblemonStructureIDs;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={JigsawPlacement.Placer.class})
public abstract class StructurePoolGeneratorMixin {
    Map<String, Integer> generatedStructureGroupCounts;
    private static final Map<String, Integer> structureMaxes;
    private static final Map<ResourceLocation, Set<String>> structureGroups;

    public Set<String> getGroups(ResourceLocation structureIdentifier) {
        return structureGroups.getOrDefault(structureIdentifier, Set.of());
    }

    public boolean hasReachedMaximum(ResourceLocation structureIdentifier) {
        Set<String> groups = this.getGroups(structureIdentifier);
        for (String group : groups) {
            int count = this.generatedStructureGroupCounts.getOrDefault(group, 0);
            if (count < structureMaxes.getOrDefault(group, Integer.MAX_VALUE)) continue;
            return true;
        }
        return false;
    }

    public void incrementStructureCount(ResourceLocation structureIdentifier) {
        Set<String> groups = this.getGroups(structureIdentifier);
        for (String group : groups) {
            this.generatedStructureGroupCounts.put(group, this.generatedStructureGroupCounts.getOrDefault(group, 0) + 1);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/core/Registry;ILnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;Ljava/util/List;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="RETURN")})
    private void onStructurePoolGeneratorCreation(Registry<StructureTemplatePool> registry, int maxSize, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> children, RandomSource random, CallbackInfo ci) {
        this.generatedStructureGroupCounts = new HashMap<String, Integer>();
    }

    @ModifyVariable(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at=@At(value="STORE"), ordinal=1)
    private Iterator<StructurePoolElement> reduceStructurePoolElementIterator(Iterator<StructurePoolElement> iterator) {
        ArrayList<StructurePoolElement> reducedList = new ArrayList<StructurePoolElement>();
        while (iterator.hasNext()) {
            StructurePoolElement structure = iterator.next();
            ResourceLocation structurePieceLocationKey = StructurePoolGeneratorMixin.getCobblemonOnlyLocation(structure);
            if (structurePieceLocationKey == null) {
                reducedList.add(structure);
                continue;
            }
            if (this.hasReachedMaximum(structurePieceLocationKey)) continue;
            reducedList.add(structure);
        }
        return reducedList.iterator();
    }

    @Inject(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at={@At(value="NEW", target="Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void afterTryPlacingChildren(PoolElementStructurePiece poolElementStructurePiece, MutableObject<VoxelShape> mutableObject, int i, boolean bl, LevelHeightAccessor levelHeightAccessor, RandomState randomState, PoolAliasLookup poolAliasLookup, LiquidSettings liquidSettings, CallbackInfo ci, @Local(ordinal=1) StructurePoolElement structurePoolElement) {
        ResourceLocation structureLocationKey = StructurePoolGeneratorMixin.getCobblemonOnlyLocation(structurePoolElement);
        if (structureLocationKey != null) {
            this.incrementStructureCount(structureLocationKey);
        }
    }

    private static ResourceLocation getCobblemonOnlyLocation(StructurePoolElement structurePoolElement) {
        ResourceLocation location = StructurePoolGeneratorMixin.getLocationIfAvailable(structurePoolElement);
        if (location == null) {
            return null;
        }
        if (!location.getNamespace().equals("cobblemon")) {
            return null;
        }
        return location;
    }

    private static ResourceLocation getLocationIfAvailable(StructurePoolElement structurePoolElement) {
        if (structurePoolElement instanceof LegacySinglePoolElement) {
            LegacySinglePoolElement legacySinglePoolElement = (LegacySinglePoolElement)structurePoolElement;
            if (legacySinglePoolElement.template.left().isEmpty()) {
                return null;
            }
            return (ResourceLocation)legacySinglePoolElement.template.left().get();
        }
        if (structurePoolElement instanceof SinglePoolElement) {
            SinglePoolElement singlePoolElement = (SinglePoolElement)structurePoolElement;
            if (singlePoolElement.template.left().isEmpty()) {
                return null;
            }
            return (ResourceLocation)singlePoolElement.template.left().get();
        }
        return null;
    }

    static {
        structureGroups = new HashMap<ResourceLocation, Set<String>>();
        String pokecenter = "pokecenter";
        String berry = "berry_farm";
        structureGroups.put(CobblemonStructureIDs.VILLAGE_PLAINS_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_DESERT_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_SAVANNA_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_SNOWY_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.VILLAGE_TAIGA_POKECENTER, Set.of(pokecenter));
        structureGroups.put(CobblemonStructureIDs.SAVANNA_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SAVANNA_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.PLAINS_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.PLAINS_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SNOWY_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.SNOWY_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.DESERT_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.DESERT_BERRY_LARGE, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.TAIGA_BERRY_SMALL, Set.of(berry));
        structureGroups.put(CobblemonStructureIDs.TAIGA_BERRY_LARGE, Set.of(berry));
        HashMap<String, Integer> aMap = new HashMap<String, Integer>();
        aMap.put(pokecenter, 1);
        aMap.put(berry, 2);
        structureMaxes = Collections.unmodifiableMap(aMap);
    }
}

