/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.client.sound.BattleMusicController;
import com.cobblemon.mod.common.client.sound.SoundTracker;
import com.cobblemon.mod.common.duck.SoundEngineDuck;
import com.cobblemon.mod.common.duck.SoundManagerDuck;
import net.minecraft.client.resources.sounds.BiomeAmbientSoundsHandler;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.UnderwaterAmbientSoundInstances;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundManager.class})
public abstract class SoundManagerMixin
implements SoundManagerDuck {
    @Shadow
    @Final
    private SoundEngine soundEngine;

    @Shadow
    public abstract boolean isActive(SoundInstance var1);

    private boolean isAmbientLoop(SoundInstance sound) {
        return sound instanceof BiomeAmbientSoundsHandler.LoopSoundInstance || sound instanceof UnderwaterAmbientSoundInstances.UnderwaterAmbientSoundInstance;
    }

    private boolean filterCondition(SoundInstance sound) {
        return !this.isAmbientLoop(sound) && this.isActive((SoundInstance)BattleMusicController.INSTANCE.getMusic()) && BattleMusicController.INSTANCE.getFilteredCategories().contains(sound.getSource());
    }

    private boolean ambientLoopCondition(SoundInstance sound) {
        return this.isAmbientLoop(sound) && this.isActive((SoundInstance)BattleMusicController.INSTANCE.getMusic()) && BattleMusicController.INSTANCE.getFilteredCategories().contains(sound.getSource());
    }

    @Override
    public void pauseSounds(@Nullable ResourceLocation id, @Nullable SoundSource category) {
        ((SoundEngineDuck)this.soundEngine).pauseSounds(id, category);
    }

    @Override
    public void resumeSounds(@Nullable ResourceLocation id, @Nullable SoundSource category) {
        ((SoundEngineDuck)this.soundEngine).resumeSounds(id, category);
    }

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playStart(SoundInstance sound, CallbackInfo cb) {
        if (this.filterCondition(sound)) {
            cb.cancel();
        }
    }

    @Inject(method={"playDelayed(Lnet/minecraft/client/resources/sounds/SoundInstance;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playStart(SoundInstance sound, int delay, CallbackInfo cb) {
        if (this.filterCondition(sound)) {
            cb.cancel();
        }
    }

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at={@At(value="TAIL")})
    public void playEnd(SoundInstance sound, CallbackInfo cb) {
        if (this.ambientLoopCondition(sound)) {
            this.pauseSounds(sound.getLocation(), SoundSource.AMBIENT);
        }
    }

    @Inject(method={"playDelayed(Lnet/minecraft/client/resources/sounds/SoundInstance;I)V"}, at={@At(value="TAIL")})
    public void playEnd(SoundInstance sound, int delay, CallbackInfo cb) {
        if (this.ambientLoopCondition(sound)) {
            this.pauseSounds(sound.getLocation(), SoundSource.AMBIENT);
        }
    }

    @Inject(method={"stop()V"}, at={@At(value="TAIL")})
    public void stop(CallbackInfo cb) {
        SoundTracker.Companion.clear();
    }
}

