/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.api.entity.EntitySideDelegate;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.entity.PosableEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public class EntityRenderDispatcherMixin {
    @Shadow
    private Map<PlayerSkin.Model, EntityRenderer<? extends Player>> playerRenderers;

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="TAIL")})
    public void resourceManagerReloadHook(ResourceManager resourceManager, CallbackInfo ci) {
        CobblemonClient.INSTANCE.onAddLayer(this.playerRenderers);
    }

    @Inject(method={"renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;FFFF)V"}, at={@At(value="TAIL")})
    private static void renderLocators(PoseStack poseStack, VertexConsumer buffer, Entity entity, float red, float green, float blue, float alpha, CallbackInfo ci) {
        PosableEntity posableEntity;
        EntitySideDelegate<?> entitySideDelegate;
        if (entity instanceof PosableEntity && (entitySideDelegate = (posableEntity = (PosableEntity)entity).getDelegate()) instanceof PosableState) {
            PosableState state = (PosableState)((Object)entitySideDelegate);
            state.getLocatorStates().forEach((locator, matrix) -> {
                poseStack.pushPose();
                Vec3 pos = matrix.getOrigin().subtract(entity.position());
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)AABB.ofSize((Vec3)pos, (double)0.25, (double)0.25, (double)0.25), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                poseStack.popPose();
            });
        }
    }
}

